/* load.c - load a menu into memory
 *
 * $Id: load.c,v 1.1.1.1 1999/12/02 20:02:21 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "mstring.h"
#include "terminal.h"
#include "viewmenu.h"


/* Load the menu title into data structure "data".
 */
void menuview_loadtitle (menudata_t data) {
  FILE * fptr;
  char * a;
  int i, j;

  if (!data->menu->title) return;

  fptr = fopen (data->menu->title, "r");
  if (!fptr) return;

  while (!feof (fptr) && data->title_lines < 8) {
    data->buf[0] = 0;
    fgets (data->buf, 1024, fptr);
    if (data->buf[0] == '#') continue;	/* skip lines starting with # */
    mstripbs (data->buf);
    a = strchr (data->buf, '\n');
    if (a) *a = 0;
    if ((data->menu->title_type == MENU_TITLE_CENTRE)
        && (mstrlen (data->buf) > 0)) {
      j = (t_cols - mstrlen (data->buf)) / 2;
      if ((j + strlen (data->buf) + 1) >= sizeof (data->buf)) {
        j = sizeof (data->buf) - strlen (data->buf) - 2;	/* !overrun */
        if (j < 0) j = 0;
      }
      memmove (data->buf + j, data->buf, strlen (data->buf) + 1);
      for (i = 0; i < j; i ++) data->buf[i] = ' ';
    }
    data->titleline[data->title_lines] = strdup (data->buf);
    data->title_lines ++;
  }

  fclose (fptr);
}


/* Load menu file into menu viewer data structure "data". Returns nonzero on
 * error.
 *
 * If "data->status" is not -1, data->file is taken to be a directory and
 * is listed. All entries within it will inherit status "data->status".
 */
int menuview_loadmenu (menudata_t data) {
  struct passwd * p;
  struct stat sb;
  FILE * fptr = 0;
  char * user;
  int i, j, l, m;

  if (data->status == -1) {		/* not a listed directory */
    fptr = fopen (data->file, "r");
    if (!fptr) return (1);
  }

  if (data->menu) {
    menu_free (data->menu);
    data->menu = 0;
  }
  for (i = 0; i < data->title_lines; i ++) {
    free (data->titleline[i]);
    data->titleline[i] = 0;
  }

  if (data->status == -1) {
    data->menu = menu_load (fptr, data->file);
    fclose (fptr);
  } else {
    data->menu = menuview_loadlisted (data);
  }

  if (!data->menu) return (1);

  data->last_accessed = time (0);
  data->title_lines = 0;

  data->maxlen = 0;
  for (i = 0; i < data->menu->num_entries; i ++) {
    if ((data->menu->menu[i].key != 0) && (data->menu->menu[i].title)) {
      l = mstrlen (data->menu->menu[i].title);
      if (l > data->maxlen) data->maxlen = l;
    }
  }

  stat (data->file, &sb);
  p = getpwuid (sb.st_uid);
  if (p) user = p->pw_name; else user = 0;

  menuview_loadtitle (data);

  if (data->title_lines > 0) {
    strcpy (data->buf, "\035CB");
    for (i = 0;					/* !overrun */
         (i < t_cols) && (strlen (data->buf) < (sizeof (data->buf) - 64));
         i ++) {
      data->buf[i + 3] = '~';
    }
    data->buf[i+3] = 0;
    if (user) {
      m = strlen (data->buf) - 7 - strlen (user) - strlen (data->keypath);
      if (strlen (data->keypath) < 1) m += 3;
      if (m < 0) m = 0;
      data->buf[m] = 0;
      strcat (data->buf, " ");
      strcat (data->buf, user);
      if (strlen (data->keypath) > 0) {
        strcat (data->buf, " <\035B");
        strcat (data->buf, data->keypath);
        strcat (data->buf, "\035b>");
      }
      strcat (data->buf, " ~~");
    }
    strcat (data->buf, "\035CA");
    data->titleline[data->title_lines] = strdup (data->buf);
    data->title_lines ++;
  } else {
    strncpy (data->buf, data->title, sizeof (data->buf) - 64);
    data->buf[sizeof (data->buf) - 64] = 0;
    i = mstrindex (data->buf, t_cols - 3 - strlen (data->keypath));
    data->buf[i] = 0;
    strcat (data->buf, "\035a <\035B");
    strcat (data->buf, data->keypath);
    strcat (data->buf, "\035b>\035CA");
    j = (t_cols - mstrlen (data->buf)) / 2;
    if ((j + strlen (data->buf) + 1) >= sizeof (data->buf)) {
      j = sizeof (data->buf) - strlen (data->buf) - 2;		/* !overrun */
      if (j < 0) j = 0;
    }
    memmove (data->buf + j, data->buf, strlen (data->buf) + 1);
    for (i = 0; i < j; i ++) data->buf[i] = ' ';
    data->titleline[data->title_lines] = strdup (data->buf);
    data->title_lines ++;
    strcpy (data->buf, "\035CB");
    for (i = 0;					/* !overrun */
         (i < t_cols) && (strlen (data->buf) < (sizeof (data->buf) - 64));
         i ++) {
      data->buf[i + 3] = '~';
    }
    strcat (data->buf, "\035CA");
    data->titleline[data->title_lines] = strdup (data->buf);
    data->title_lines ++;
  }

  return (0);
}

/* EOF */
