/* wipe.c - initialise a vt_info
 *
 * $Id: wipe.c,v 1.1.1.1 1999/12/02 20:01:17 ivarch Exp $
 */

#include <string.h>
#include "Internal.h"


/* Initialise "vt" by clearing text and attributes, putting the cursor at
 * the top left, wiping the in-escape-sequence and pending action flags,
 * blanking the xterm title, clearing all current attributes, and setting
 * the current colour to white on black.
 *
 * Returns nonzero on error.
 */
int vt100_reset (vt_info vt) {
  int i;

  if (!vt) return (1);

  vt->x = 1;	/* position cursor at top left */
  vt->y = 1;

  vt->current_attr  = VT_COLOUR_WHITE << VT_FOREGROUND_SHIFT;	/* fg=white */
  vt->current_attr |= VT_COLOUR_BLACK << VT_BACKGROUND_SHIFT;	/* bg=black */

  vt->esc_state = VT_ESnone;	/* not in an escape sequence */

  for (i = 0; i < (vt->rows * vt->cols); i ++) {
    vt->text[i] = ' ';
    vt->attrs[i] = vt->current_attr;
  }

  vt->pending = 0;	/* no actions pending */
  vt->xtitle[0] = 0;	/* blank xterm title */
 
  return (0);
}

/* EOF */
