/* action.c - perform and/or queue an action
 *
 * $Id: action.c,v 1.1.1.1 1999/12/02 20:00:52 ivarch Exp $
 */

#include "Internal.h"


/* Call the callback for "action" if one is set, and if it's OK to continue,
 * perform that action, otherwise mark it as "pending".
 *
 * The return value is negative on error, zero on success, and positive if
 * the callback was called and returned 1, thus marking the action as pending.
 */
int vt100_action (vt_info vt, long action) {
  int r;

  if (!vt) return (-1);

  if ((vt->callback_function) && (vt->callback_mask & action)) {
    r = (vt->callback_function)(vt, action, vt->callback_pointer);
    if (r < 0) return (-1);
    if (r > 0) {
      vt->pending |= action;
      return (1);
    }
  }

  return (vt100_do_action (vt, action));
}

/* EOF */
