/* $Header: /home/vph/develop/lore/RCS/lore.cc,v 1.94 1996/10/25 19:47:04 vph Exp vph $ */
/*****************************************************************************
*                           Linux OMEN Reader 1.xx                           *
*                  Copyrights (c) 1995 by Ville Hallivuori.                  *
*                                                                            *
*    This program is free software; you can redistribute it and/or modify    *
*    it under the terms of the GNU General Public License version 2 as       *
*    published by the Free Software Foundation.                              *
*                                                                            *
*    This program is distributed in the hope that it will be useful,         *
*    but WITHOUT ANY WARRANTY; without even the implied warranty of          *
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
*    GNU General Public License for more details.                            *
*                                                                            *
*    You should have received a copy of the GNU General Public License       *
*    along with this program; if not, write to the Free Software             *
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               *
*                                                                            *
*****************************************************************************/

//NOTE: This program mus be complied with option "-lncurses"

/*****************************************************************************
* Includes                                                                   *
*****************************************************************************/

#include <iostream.h>                       //C++'s standard libary
#include <ostream.h>                        //File output
#include "menu.h"
#include <fstream.h>                        //File input
#include <stdio.h>                          //C's standard libary
#include <stdarg.h>
#include <ctype.h>
#include <glob.h>                           //File findind libary
#include <string.h>                         //String handling libary
#include <ncurses/curses.h>                 //Screen/keyboard handling libary
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/timeb.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>
#include "lore.h"                           //Lore's own definitions

int CurMsg=0;                               //Curent message (what you are reading on the moment)
char OutText[81];                           //Buffer for various output

char FindText[28];                            //Text to fid
int FFDone;                                   //1, if find first has been used
int sessionindex;                             //Index for MListBox class
int pid_m;                                    //pid of lores main-procces
int HasColors;                                //1 if terminal suport colors
int SManager;                                 //1 if we are reading messages 
/*****************************************************************************
* Pointers to global classes                                                 *
*****************************************************************************/

AppMenus *MenuBar;                          //Menubar when reading
AppMenus *MMenuBar;                         //Menubar on session selection
MsgScreen *Message;                         //UserInterface on reading messages
BBSInfo *BInfo;                             //Contains all from SYSTEMxy.BBS
Messages *MsgInfo;                          //Contains all from NEWMSGxy.TXT
Config *Settings;                           //LORE's configuration
MListBox *SesList;                          //SEssion selection
FHandler *FileH;                            //Archive handling
SkipList *Skip;                             //Skipping
boutstream *bout_msg;
boutstream *bout_lb;

boutstream::boutstream(int x1,int y1,int x2,int y2)
{
  int xj;
  int yj;
  if (x1 < 1) x1 = 1; if (x1 > 80) x1 = 80; //Range chekking
  if (y1 < 1) y1 = 1; if (y1 > LINES) y1 = LINES;
  if (x2 < 1) x2 = 1; if (x2 > 80) x2 = 80;
  if (y2 < 1) y2 = 1; if (y2 > LINES) y2 = LINES;
  sx = x1;                                  //Coordinates of left/up corner
  sy = y1;
  xsize = x2-x1+1;                          //Size of layer
  ysize = y2-y1+1;
  colors = new unsigned char [ysize*xsize]; //Creates layers
  chars = new unsigned char [xsize*ysize];
  for (yj=0; yj<ysize; yj++)                //Layer has no color
    for (xj=0; xj<xsize; xj++)
      colors [xj+yj*xsize] = '\0';
  for (yj=0; yj<ysize; yj++)
    for (xj=0; xj<xsize; xj++)
      chars [xj+yj*xsize] = ' ';
}

boutstream::~boutstream(void)               //Frees memory
{
  delete colors;                            //Deletes layer from memory
  delete chars;
}

void boutstream::setcolor(int x1,int y1,int x2,int y2,int fg,int bg)
{
  x1--; x2--;                               //Position on array
  y1--; y2--;
  if (x1<0) x1=0; if (x2>xsize-1) x2=xsize-1; //Range checking
  if (y1<0) y1=0; if (y2>ysize-1) y2=ysize-1;
  int xj;
  int yj;
  int bold = 0;
  int reverse = 0;
  if (fg > 1000) fg=fg-1000;
  if (fg > 100)
    {
      fg = fg-100;
      bold = 1;
    }
  if (bg > 1000)
    {
      bg = bg-1000;
      reverse = 1;
    }
  if (bg > 100) bg = bg-100;
  fg=fg-30;
  bg=bg-30;
  unsigned char fgmask = fg;
  unsigned char bgmask = bg;
  bg=bg<<4;
  bgmask=bg;
  unsigned char cattribute = (fgmask | bgmask);
  if (bold == 1) cattribute = (cattribute | 0x08);
  if (reverse == 1) cattribute = (cattribute | 0x80);
  for (yj=y1; yj<=y2; yj++)
    for (xj=x1; xj<=x2; xj++)
      colors [xj+xsize*yj] = cattribute;
}

void boutstream::writexy(int x,int y, unsigned char *atext)
{
  x--; y--;                                 //Position on array
  int j;
  int tsize=strlen((char *)atext);          //**************MUUTA
  if (x<0) x=0; if (y<0) y=0;               //Ranges chekking
  if (x+tsize>xsize) tsize=xsize-x;
  if (y>ysize-1) y=ysize-1;
  for (j=0; j<tsize; j++)
    {
      chars[x+j+xsize*y]=atext[j];
    }
}

unsigned char *boutstream::setcattrib(unsigned char ca)
{
  static unsigned char buffer[64];
  unsigned char color;
  unsigned char colorstr[3];
  colorstr[2]='\0';
  strcpy((char *)buffer,"\033[0m");                 //Clears attributes
  unsigned char bgc=ca;
  bgc=bgc>>4;
  bgc=(bgc & 0x07);
  bgc=bgc+48;
  if (HasColors==1)                         //If we are using a colorterminal
    {
      color = (ca & 0x07);                  //Foreground color
      color = color+48;
      strcat((char *)buffer,"\033[");
      colorstr[0]='3';colorstr[1]=color;
      strcat((char *)buffer,(const char *)colorstr);
      strcat((char *)buffer,"m");
      color = bgc;                          //Background color
      strcat((char *)buffer,"\033[");
      colorstr[0]='4';colorstr[1]=color;
      strcat((char *)buffer,(const char *)colorstr);
      strcat((char *)buffer,"m");
    }
  else
    {
      if (ca & 0x80) strcat((char *)buffer,"\033[7m"); //Reverse video
    }
  if (ca & 0x08) strcat((char *)buffer,"\033[1m");  //If text is bold.
  return (buffer);
}      
	 
void boutstream::draw(int x1, int y1, int x2, int y2)
{
  int xj; int yj;
  x1--; y1--; x2--; y2--;
  if (x1<0) x1=0; if (x2>xsize-1) x2=xsize-1; //Range checking
  if (y1<0) y1=0; if (y2>ysize-1) y2=ysize-1;
  unsigned char buffer[512];
  unsigned char ocaddribute;
  char addstr[2];
  addstr[1]='\0';
  ocaddribute=colors[x1+y1*xsize];
  strcpy((char *)buffer,(const char *)setcattrib(colors[x1+y1*xsize]));
  for (yj=y1; yj<=y2; yj++)
    {
      for (xj=x1; xj<=x2; xj++)
	{
	  if (colors[xj+yj*xsize]!=ocaddribute)
	    {
	      strcat((char *)buffer,(const char *)setcattrib(colors[xj+yj*xsize]));
	      ocaddribute=colors[xj+yj*xsize];
	    }
	  addstr[0]=chars[xj+yj*xsize];
  	  strcat((char *)buffer,(const char *)addstr);
	}
      GotoXY(sx+x1,sy+yj);
      cout<<buffer<<flush;
      buffer[0]='\0';
    }
}

void MakeMenu(void)                           //Creates menubars
{
  MenuBar=new AppMenus;                       //Menus while reading messages
  mnu_root = MenuBar->AddMenu("-",-1,1);
  mnu_about = MenuBar->AddMenu("About",mnu_root,1,LAbout);
  MenuBar->AddMenu("",mnu_root,2);
  mnu_exit = MenuBar->AddMenu("Exit",mnu_root,1,ExitMnu);  
  mnu_file = MenuBar->AddMenu("File",-1,1);
  mnu_closesession = MenuBar->AddMenu("Close session",mnu_file,1,ReturnMListBox);
  mnu_removesession = MenuBar->AddMenu("Remove session",mnu_file,1,RmSessionL);
  mnu_replypacket = MenuBar->AddMenu("Reply-packet",mnu_file,1,RP);
  mnu_edit = MenuBar->AddMenu("Edit",-1,1);
  mnu_find = MenuBar->AddMenu("Find",mnu_edit,1,FindFirst);
  mnu_findnext = MenuBar->AddMenu("Find next",mnu_edit,1,FindNext);
  MenuBar->AddMenu("",mnu_edit,2);
  mnu_markings = MenuBar->AddMenu("Bookmarks",mnu_edit,1,Markings);
  mnu_messagestoyou = MenuBar->AddMenu("Messages to you",mnu_edit,1,MTY);
  MenuBar->AddMenu("",mnu_edit,2);
  mnu_savetofile = MenuBar->AddMenu("Save to file",mnu_edit,1,Save2File);
  mnu_skipsubject = MenuBar->AddMenu("Skip subject",mnu_edit,1,SkipSubject);
  mnu_skipwriter = MenuBar->AddMenu("Skip writer",mnu_edit,1,SkipName);
  mnu_message = MenuBar->AddMenu("Message",-1,1);
  mnu_folowup = MenuBar->AddMenu("Folowup",mnu_message,1,ReplyMsg);
  mnu_postmessage = MenuBar->AddMenu("Post message",mnu_message,1,PostNewMsg);
  mnu_listwrittenmessages = MenuBar->AddMenu("List operations",mnu_message,1,LOper);
  MenuBar->AddMenu("",mnu_message,2);
  mnu_removemessage = MenuBar->AddMenu("Remove message (SysOp)",mnu_message,1,RmMsg);
  mnu_movemessage = MenuBar->AddMenu("Move Message   (SysOp)",mnu_message,1,MvMsg);
  mnu_makeprivate = MenuBar->AddMenu("Make private   (SysOp)",mnu_message,1,MkPriv);
  MenuBar->AddMenu("",mnu_message,2);
  mnu_index= MenuBar->AddMenu("Index",mnu_message,1,Index);
  mnu_help = MenuBar->AddMenu("Help",-1,1);
  mnu_keys = MenuBar->AddMenu("Keys",mnu_help,1,RHelp);
  MMenuBar=new AppMenus;                      //Menus on session-select -screen
  Mnu_root = MMenuBar->AddMenu("-",-1,1);
  Mnu_about = MMenuBar->AddMenu("About",Mnu_root,1,LAbout);
  MMenuBar->AddMenu("",Mnu_root,2);
  Mnu_exit = MMenuBar->AddMenu("Exit",Mnu_root,1,ExitNow);
  Mnu_session = MMenuBar->AddMenu("Sessions",-1,1);
  Mnu_removesession =  MMenuBar->AddMenu("Remove session",Mnu_session,1,RmSessionL);
  Mnu_settings = MMenuBar->AddMenu("Settings",-1,1);
  Mnu_global = MMenuBar->AddMenu("Global settings", Mnu_settings, 1,setglobal);
  Mnu_thisbbs = MMenuBar->AddMenu("Settings for BBS", Mnu_settings, 1,setbbs);
  Mnu_help = MMenuBar->AddMenu("Help",-1,1);
  Mnu_keys = MMenuBar->AddMenu("Keys",Mnu_help,1,SHelp);
}

/*****************************************************************************
*  File Handler - unzips new messages                                        *
*****************************************************************************/

FHandler::FHandler(void)                      //Initial values
{
  strcpy(TmpDir,Settings->LoreHome);
  strcat(TmpDir,"tmp/");
}

FHandler::~FHandler(void)                     //Dosen't dp anything
{
}

void FHandler::AddEntry(char *Ext)            //Adds entry to sessions.dat
{
  char buffer[256];
  time_t curtime;
  struct tm *loctime;
  char FileName[200];                         //Full name of sessions.dat
  char PointerName[200];                      //Name of POINTERSxy.zzz
  char SFile[200];                            //Name of SYSTEMxy.BBS
  char SysName[41];                           //Name of system
  int j;
  int Size;                                   //Length of System name
  char input1;
  strcpy(FileName,Settings->LoreHome);
  strcat(FileName,"sessions.dat");
  strcpy(SFile,Settings->LoreHome);
  strcat(SFile,"SYSTEM");
  strcat(SFile,IDc);
  strcat(SFile,".");
  strcat(SFile,Ext);
  ofstream Sessions(FileName,ios::app);       //Opens sessions.dat for append..
  if (Sessions.fail())
    {
      cerr<<"Error: cant open \"" <<FileName<<"\" for writing.\n";
      cerr<<"Hit any key to exit";
      cerr<<"Confirmed: "<<getch()<<'\n';
      ExitNow();
    }
  ifstream SysFile(SFile);                    //Opens SYSTEMxy.BBS -file
  if (SysFile.fail())
    {
      cerr<<"Error: cant open \""<<SFile<<"\" for reading.\n";
      cerr<<"Hit any key to exit";
      cerr<<"Confirmed: "<<getch()<<'\n';
      ExitNow();
    }
  SysFile.get(input1);                        //Reads length of system name
  Size=input1;
  Sessions<<input1;                           //Writes length of name
  for (j=0; j<=39; j++)                       //Reads name (40 chars)
    {
      SysFile.get(input1);
      SysName[j]=input1;
    }
  SysName[Size]='\0';                         //Adds null to end of name
  SysFile.close();                            //Closes SYSTEMxy.BBS -file
  curtime = time (NULL);                      //Finds out curent date
  loctime = localtime (&curtime);
  strftime (buffer, 256, "%d-%b-%y", loctime);//Formats date 
  Sessions<<SysName<<" "<<IDc<<" "<<Ext<<" "<<buffer<<'\n';
  Sessions.close();                           //closes session.dat
  strcpy(PointerName,Settings->LoreHome);     //File to save messagepointers
  strcat(PointerName,"POINTERS");
  strcat(PointerName,IDc);
  strcat(PointerName,".");
  strcat(PointerName,Ext);
  ofstream Pointers(PointerName);             //Creates pointer-file
  Pointers<<0;                                //Sets 0 to starting message
  Pointers.close();                           //Closes pointerfile
}

void FHandler::itos(int INro)                 //Converts integer to string
{
  int Digit0, Digit1, Digit2;
  char SNro[4];
  Digit0=INro/100;
  Digit1=(INro-Digit0*100)/10;
  Digit2=INro-Digit0*100-Digit1*10;
  SNro[0]=48+Digit0;
  SNro[1]=48+Digit1;
  SNro[2]=48+Digit2;
  SNro[3]='\0';
  strcpy(FExt,SNro);
}

void FHandler::ReadIDChars(char *FileName)    //Reads ID-characters
{
  int Size=strlen(FileName);                  //Size of FileName
  IDc[0]=toupper(FileName[Size-6]);           //Capitalizes file id(chars)
  IDc[1]=toupper(FileName[Size-5]);
  IDc[2]='\0';
}

int FHandler::GetFreeNro(void)                //Gets first fee number for 
{                                             //extension
  glob_t OldMsg;                              //Info about old msg-packets
  char **ONames;
  char *OName;
  char Nro[4];
  int FirstFree=0;                            //First free extension
  int FNumbers[1000];                         //Used extensions
  int OSize=0;
  int j;
  strcpy(FileMask,Settings->LoreHome);        //Constructs FileMask
  strcat(FileMask,"NEWMSG");
  strcat(FileMask,IDc);
  strcat(FileMask,".???");
  OldMsg.gl_offs=0;
  glob(FileMask, 0, NULL, &OldMsg);
  ONames=OldMsg.gl_pathv;
  for (j=0; j<=999; j++) FNumbers[j]=0;       //Clears array
  for (j=0; j<OldMsg.gl_pathc; j++)           //Marks all uset extensions
    {
      OName=ONames[j];
      OSize=strlen(OName);
      Nro[0]=OName[OSize-3];
      Nro[1]=OName[OSize-2];
      Nro[2]=OName[OSize-1];
      Nro[3]='\0';
      FNumbers[atoi(Nro)]=1;
    }
  for (j=0; j<=999; j++)                      //Finds first free extension
    {
      if (FNumbers[j]==0)
	{
	  FirstFree=j;
	  break;                              //Stops looping, when unused
	}
    }
  globfree(&OldMsg);                          //Frees used memory
  return(FirstFree);                          //Returns first free extension
}

void FHandler::UnZip(char *FileName, char *ToDir) //UnZips messages
{
  char buffer[200];
  strcpy(buffer,Settings->LoreHome);
  strcat(buffer,"unzip.sh");
  int a = 0;
  fork();                                     //Make clone
  if (getpid()==pid_m)                        //Original program wates until 
    {                                         //clone has unzipped messages
      int status;      
      wait(&status);
    }                                         //Clone unzips messages and die
  else a=execl(buffer,"unzip.sh",FileName,ToDir,NULL);
  if (a == -1)
    {
      cerr<<"Unzipping failed\n Press any ke to continue.\n";
      getch();
    }
}

void FHandler::ReMove(char *FileName)         //Removes Zipped packet
{
  fork();                                     //Make clone
  if (getpid()==pid_m)                        //Original program wates until
    {                                         //clone has removed Zip packet
      int status;      
      wait(&status);
    }                                         //CLone unzips messages and die.
  else execl("/bin/rm","rm",FileName,NULL);
}

char *FHandler::CutName(char *FName)          //Separates files-name and -path
{
  int j=strlen(FName)-1;
  int i=0;
  static char RealName[200];
  while (FName[j-1]!='/') j--;                //J is set to point begin of name
  do
    {
      RealName[i]=FName[j];
      i++;
      j++;
    }
  while (FName[j-1]!='.');
  RealName[i]='\0';
  strcat(RealName,FExt);
  return (RealName);
}

    
void FHandler::Move(void)                     //Moves files to loredir
{
  glob_t UZFiles;                             //Unzipped files
  char MoveMask[200]; 
  strcpy(MoveMask,TmpDir);                    //All uzipped files
  strcat(MoveMask,"/*");
  strcat(MoveMask,IDc);
  strcat(MoveMask,".???");
  UZFiles.gl_offs=0;
  glob(MoveMask, 0, NULL, &UZFiles);         //Finds all unzipped files
  char **FileNames=UZFiles.gl_pathv;         //Names of found files
  char *FileName;                            //Name of file under procces
  char *RealName;
  char MoveTo[200]; 
  for (int j=0; j<UZFiles.gl_pathc; j++)     //Moving loop
    {
      FileName=FileNames[j];
      RealName=CutName(FileName);
      strcpy(MoveTo,Settings->LoreHome);
      strcat(MoveTo,RealName);
      fork();                               //Makes clone
      if (getpid()==pid_m)                  //Original program wates until
        {                                   //clone has moved files
	  int status;
	  wait(&status);
        }                                   //Clone moves files and die
      else execl("/bin/mv","mv",FileName,MoveTo,NULL);
    }
  globfree(&UZFiles);                       //Frees memory

  /*Suport for lower case names.*/
  MoveMask[0] = '\0'; 
  strcpy(MoveMask,TmpDir);
  strcat(MoveMask,"/*");
  char nIDc[3];
  strcpy (nIDc, IDc);
  for (int i = 0; i<2; i++) nIDc[i] = (char tolower(nIDc[i]));
  strcat(MoveMask,nIDc);
  strcat(MoveMask,".???");
  UZFiles.gl_offs=0;
  glob(MoveMask, 0, NULL, &UZFiles);         //Finds all unzipped files
  FileNames=UZFiles.gl_pathv;
  MoveTo[0] = '\0'; 
  for (int j=0; j<UZFiles.gl_pathc; j++)     //Moving loop
    {
      FileName=FileNames[j];
      RealName=CutName(FileName);
      strcpy(MoveTo,Settings->LoreHome);
      for (unsigned int i = 0; i<strlen (RealName)-1; i++)
	RealName[i] = (char) toupper(RealName[i]);
      strcat(MoveTo, RealName);
      fork();                               //Makes clone
      if (getpid()==pid_m)                  //Original program wates until
        {                                   //clone has moved files
	  int status;
	  wait(&status);
        }                                   //Clone moves files and die
      else execl("/bin/mv","mv",FileName,MoveTo,NULL);
    }
  globfree(&UZFiles);                       //Frees memory
}

void FHandler::GetNew(void)                 //Unzips new messagepackets
{
  glob_t MsgPackets;                        //Info about MsgPackets
  strcpy(DownMask,Settings->DownLoad);      //Files to unzip
  strcat(DownMask,"omen??.zip"); 
  MsgPackets.gl_offs=0;
  glob(DownMask, 0, NULL, &MsgPackets);     //Find all new messagepackets
  char **FileNames=MsgPackets.gl_pathv;     //Names of found files
  char *FileName;                           //Name of file under procces
  for (int j=0; j<MsgPackets.gl_pathc; j++) //UnZipping loop
    {
      FileName=FileNames[j];                //Name of ZipFile
      UnZip(FileName,TmpDir);               //Unzips ZipFile
      ReadIDChars(FileName);                //Reads ID-chars from ZipFile
      itos(GetFreeNro());                   //New extension for msg-files
      Move();
      AddEntry(FExt);
      ReMove(FileName);
    }
  globfree(&MsgPackets);                    //Frees used memory
}
    

/*****************************************************************************
* Session selection list                                                     *
*****************************************************************************/

void MListBox::ReadSessions(void)           //Reads list of open sessions
{
  char FileName[200];                       //Full name of sessions.dat
  int Size;                                 //Length of Name
  char input1;
  LastItem=-1;                              //No items yet
  CurItem=0;
  OnSrcItem=0;
  strcpy(FileName,Settings->LoreHome);
  strcat(FileName,"sessions.dat");
  ifstream SFile(FileName);                 //Stream from sessions.dat
  while (!SFile.eof())
    {
      SFile.get(input1);                    //Reads length of system name
      if (!SFile.good()) break;
      LastItem++;
      Size=input1;
      int j;
      for (j=0; j<Size; j++)            //Reads name
	{
          SFile.get(input1);
	  Items[LastItem].Name[j]=input1;
	}
      Items[LastItem].Name[j]='\0';
      SFile>>Items[LastItem].IDc;           //Reads ID-characters
      Items[LastItem].IDc[2]='\0';
      SFile>>Items[LastItem].Index;         //Reads index-string
      Items[LastItem].Index[3]='\0';
      SFile>>Items[LastItem].Date;          //Reads opening-date
      Items[LastItem].Date[9]='\0';
      if (SFile.peek()=='\n') SFile.get(input1);
    }
  SFile.close();
}
  
MListBox::MListBox(void)                    //Constructor
{
  bout_lb=new boutstream(1,2,80,LINES-1);
  LastItem=-1;
  CurItem=0;
  OnSrcItem=0;
  ClrAttrib();                              //Resets screen attributes
  EraseDisplay();
  GotoXY(1,1);
  cout<<"Unzipping new messages... be patient\n\n";
  FileH= new FHandler;
  FileH->GetNew();                          //UnZip new messages
  delete FileH;
  ClrAttrib();                              //Resets screen
  EraseDisplay();
  ReadSessions();                           //Reads list of open sessions
  Draw();
}

void MListBox::RmSession(void)              //Removes session
{
  glob_t RmFiles;                           //Files to be removed
  char RmMask[200];
  strcpy(RmMask,Settings->LoreHome);        //Constructs mask to match r-files
  strcat(RmMask,"*");
  strcat(RmMask,"*");
  strcat(RmMask, Items[CurItem].IDc);
  strcat(RmMask,".");
  strcat(RmMask, Items[CurItem].Index);
  RmFiles.gl_offs=0;
  glob(RmMask, 0, NULL, &RmFiles);          //Find all files to be removed
  char **FileNames=RmFiles.gl_pathv;        //Names of found files
  char *FileName;                           //Name of file under procces
  int j;
  for (j=0; j<RmFiles.gl_pathc; j++)    //Removing loop
    {
      FileName=FileNames[j];
      fork();                               //Make clone
      if (getpid()==pid_m)                  //Original program wates until
        {                                   //clone has removed files
	  int status;     
	  wait(&status);
        }                                   //Clone removes files, and die
      else execl("/bin/rm","rm",FileName,NULL);
    }
  char NSesFile[200];
  strcpy(NSesFile,Settings->LoreHome);      //Full name of sessions.dat
  strcat(NSesFile,"sessions.dat");
  ofstream CSessions(NSesFile,ios::trunc);  //Open and clears sessions.dat
  CSessions.close();
  ofstream NSessions(NSesFile);
  for (j=0; j<=LastItem; j++)
    { 
      if (j!=CurItem)
	{
	  NSessions<<(unsigned char)strlen(Items[j].Name)<<Items[j].Name<<" "
		   <<Items[j].IDc<<" "<<Items[j].Index<<" "<<Items[j].Date
		   <<'\n';
	}
    }
  NSessions.close();
  LastItem=-1;
  CurItem=0;
  OnSrcItem=0;
  ReadSessions();                           //Reads list of open sessions
  globfree(&RmFiles);
}

void MListBox::StatusLine(void)             //Draws statusline
{
  ClrAttrib();
  TextColor(StatFgColor);
  TextBackColor(StatBgColor);
  resetOT();
  GotoXY(1,LINES);
  cout<<OutText;
  GotoXY(2,LINES);
  cout<<"Lore "<<LORE_VERSION
      <<"  |  [ESC] Menu    [UP/DOWN] Move    [ENTER] Select"<<flush;
}

void MListBox::Draw(void)                   //Draws list and background
{  
  bout_lb->setcolor(1,1,80,LINES-2,SLstFgColor,SLstBgColor);
  resetOT();
  for (int j=1; j<LINES-1; j++)               //Draws background
    {
      bout_lb->writexy(1,j,(unsigned char *)OutText);
    }
  DrawSubject();                            //Draws subject
  if (LastItem!=-1)                         //Draws items
    {
      int j=OnSrcItem;
      while((j<=LastItem)&&((j-OnSrcItem)<(LINES-7)))
	{
	  DrawItem(j);
	  j++;
	}
    }
  StatusLine();                             //Draws statusline
  bout_lb->draw(1,1,80,LINES-2);
}

void MListBox::DrawItem(int Index)          //Draws one item
{
  char Buffer[42];
  char *Space;
  int Size;
  int PosY=5+Index-OnSrcItem;               //Position of item on screen
  if (Index==CurItem)                       //Colors for selected item
    {
      bout_lb->setcolor(20,PosY,59,PosY,ASLstFgColor,ASLstBgColor);
    }
  else                                      //Colors for nonselected item 
    {
      bout_lb->setcolor(20,PosY,59,PosY,SLstFgColor,SLstBgColor);
    }
  strcpy(Buffer," ");
  strcat(Buffer,Items[Index].Name);
  Size=40-9-strlen(Buffer);
  Space= new char[Size];
  int j;
  for (j=0; j<Size; j++) Space[j]=' ';
  Space[j-1]='\0';
  strcat(Buffer,Space);
  strcat(Buffer,Items[Index].Date);
  strcat(Buffer," ");
  bout_lb->writexy(20,PosY,(unsigned char *)Buffer);
  bout_lb->draw(20,PosY,59,PosY);
}

void MListBox::DrawSubject(void)            //Open sessions/No -"-  -line
{
  bout_lb->setcolor(20,3,59,3,ASLstFgColor,ASLstBgColor);
  if (LastItem==-1)
    {
      bout_lb->writexy(20,3,(unsigned char *)"            No open sessions            ");
    }
  else
    {
      bout_lb->writexy(20,3,(unsigned char *)"             Open sessions              ");
    }
}
      
void MListBox::ScrollDown(void)             //Scrolls list down
{
  OnSrcItem++;
  int j=OnSrcItem;
  while((j<=LastItem)&&((j-OnSrcItem)<(LINES-7))) //Draws items on screen
    {
      DrawItem(j);
      j++;
    }
}

void MListBox::ScrollUp(void)               //Scrolls list up
{
  OnSrcItem--;
  int j=OnSrcItem;
  while((j<=LastItem)&&((j-OnSrcItem)<(LINES-7))) //Draws item on screen
    {
      DrawItem(j);
      j++;
    }
}

void MListBox::ReadMsg(void)                //Goes to reading-mode
{
  char SystemFile[200];
  char MsgFile[200];
  char BNameFile[200];
  strcpy(SystemFile,Settings->LoreHome);    //Construct name of SYSTEMxy.BBS
  strcat(SystemFile,"SYSTEM");
  strcat(SystemFile, Items[CurItem].IDc);
  strcat(SystemFile,".");
  strcat(SystemFile, Items[CurItem].Index);
  strcpy(MsgFile,Settings->LoreHome);       //Construct name of NEWMSGxy.TXT
  strcat(MsgFile,"NEWMSG");
  strcat(MsgFile, Items[CurItem].IDc);
  strcat(MsgFile,".");
  strcat(MsgFile, Items[CurItem].Index);
  strcpy(BNameFile,Settings->LoreHome);      
  strcat(BNameFile,"BNAMES");
  strcat(BNameFile, Items[CurItem].IDc);
  strcat(BNameFile,".");
  strcat(BNameFile, Items[CurItem].Index);
  ClrAttrib();                              //Resets screen
  EraseDisplay();
  Settings->ReadBBS(CurItem);               //Reads BBS's settings
  MsgInfo = new Messages(MsgFile);          //All message-data
  BInfo = new BBSInfo(SystemFile);          //Information about BBS  
  BInfo->ReadFile();                        //Reads all info about BBS
  ReadBNames(BNameFile);                    //Reads long boardnames
  MsgInfo->ReadMessages();                  //Read messages
  SManager=1;                               //We are reading messages
  Skip=new SkipList;                        //Skiplist
  Skip->ReadFiles();                        //Read previously skipped subj&wri
  Message = new MsgScreen(CurItem);         //Display object
  Message->Handle();                        //Interface
  delete Message;                           //Deletes display-object
  delete Skip;                              //Deletes skiplist
  SManager=0;                               //We are seleting session
  delete BInfo;                             //Deletes BBS-info from memory
  delete MsgInfo;                           //Deletes MSG-info from memory
  ClrAttrib();                              //Resets screen
  EraseDisplay();
  Draw();                                   //Draws sessionselectionlistbox
  MMenuBar->BMenuBar();                     //Draws new menubar
}


void MListBox::Handle(void)                 //Interface
{
  int input1;
  MMenuBar->BMenuBar();                     //Draws menubar
  do
    {
      do 
        {
	  GotoXY (0,0);
	  input1=getch();              //Reads keyboard
        }
      while ((input1!=27)&&(input1!=KEY_DOWN)&&(input1!=KEY_UP)&&(input1!=10)
	     &&(input1!='x')&&(input1!='h')&&(input1!='?')&&(input1!='m'));
      switch(input1)
       { 
       case KEY_DOWN: if (CurItem<LastItem) //Next item
	 {
	   CurItem++;
           if ((CurItem-OnSrcItem)==(LINES-7))
	     {
	       ScrollDown();
	     }
           else
	     {
	       DrawItem(CurItem-1);
	       DrawItem(CurItem);
	     }
	 }
         break;
       case KEY_UP: if (CurItem>0)          //Previous item
	 {
           CurItem--;
	   if ((CurItem-OnSrcItem)==-1)
	     {
	       ScrollUp();
	     }
	   else
	     {
	       DrawItem(CurItem+1);
	       DrawItem(CurItem);
	     }
	 }
	 break;
       case 10: if (LastItem>=0)            //Read session
	 {
	   sessionindex=CurItem;
	   ReadMsg();
	 }
	 break;
       case 27: MMenuBar->Handle();         //Menus
         Draw();
	 MMenuBar->BMenuBar();
	 break;
       case 'm': MMenuBar->Handle();        //Menus
         Draw();
	 MMenuBar->BMenuBar();
	 break;
       case 'x': ExitNow();                 //Keyboard shortcuts
	 break;
       case 'h': SHelp();
	 Draw();
	 MMenuBar->BMenuBar();
	 break;
       case '?': SHelp();
	 Draw();
	 MMenuBar->BMenuBar();
	 break;
       }
    }
  while ((input1!=27)||(input1!=18));
}

/*****************************************************************************
*  All LORE's configuration info                                             *
*****************************************************************************/

Config::Config(void)                        //All LORE's configuration info
{
  strcpy(LoreHome,getenv("HOME"));          //Get home-directory from $HOME
  strcat(LoreHome,"/.LORE/");               //Add LORE's part of directory
  strcpy(DownLoad,getenv("HOME"));          //Default dowload directory
  strcat(DownLoad,"/");
  strcpy(UpLoad,getenv("HOME"));            //Default upload directory
  strcat(UpLoad,"/");
  strcpy(Editor,"/usr/bin/jed");            //Default editor
  strcpy(Signature,getenv("HOME"));         //Default signature
  strcat(Signature,"/.signature");
  strcpy(TagLine,getenv("HOME"));           //Default tagline
  strcat(TagLine,"/.tagline");
  IBMConv=1;                                //Character-conversion defaults
  SF7Conv=1;
  OutChars=0;
  ReadGConfig();                            //Reads/writes new  config-file
}

int Config::ReadBBS(int IndexID)            //Reads BBS's configuration file
{
  char CfgName[200];
  int FirstTime=0;
  strcpy (CfgName,LoreHome);                //Name of configuration file
  strcat (CfgName,"config.");
  strcat (CfgName,SesList->Items[IndexID].IDc);
  ifstream CfgFile(CfgName);
  if (CfgFile.fail())                       //If first time
    {
      CfgFile.close();                      //CLoses file tempolari
      ofstream ConfFile(CfgName);           //Writes configuration info.
      ConfFile<<"DO_NOT_EDIT_THIS_FILE_BY_HAND 0 0 0 1 1";
      ConfFile.close();
      CfgFile.open(CfgName);
      FirstTime=1;
    }
  char input1[200];
  int size=0;
  CfgFile>>input1;                          //Reads "DO_NOTE_EDIT_TH...
  CfgFile>>size;                            //Reads all other data
  int j;
  for (j=0; j<size; j++)
    {
      UName[j]=CfgFile.get();
    }
  UName[j]=0;
  CfgFile>>size;
  for (j=0; j<size; j++)
    {
      UAlias[j]=CfgFile.get();
    }
  UAlias[j]=0;
  CfgFile>>OutChars;
  CfgFile>>SF7Conv;
  CfgFile>>IBMConv;
  CfgFile.close();
  if (FirstTime==1) SetBBS(IndexID);        //First time  verify settings
  return (FirstTime);
}

void Config::SetBBS(int IndexID)            //BBS's settings - dialog
{    
  char Caption[50];                         //Caption of confuguration window
  strcpy(Caption,SesList->Items[IndexID].Name);
  SWin = new Window(20,5,61,18,Caption);    //Gonfiguration window
  SWin->Draw();
  char *BUName=new char[strlen(UName)];
  char *BUAlias=new char[strlen(UAlias)];
  strcpy(BUName,UName);
  strcpy(BUAlias,UAlias);
  GotoXY(23,7); cout<<"Your name";
  GotoXY(23,8); cout<<"Your alias";
  GotoXY(23,10); cout<<"BBS characterset";
  GotoXY(23,12); cout<<"Conversion (incoming)";
  GotoXY(23,17); cout<<"[ENTER] Save    [ESC] Cancel";
  TextBox txt_name(34,58,7,UName);          //Creates textboxes
  TextBox txt_alias(34,58,8,UAlias);
  txt_name.Draw();
  txt_alias.Draw();
  VSelect vs_charset(40,58,10,2);
  vs_charset.Active=OutChars;
  strcpy(vs_charset.Items[0],"ISO Latin 1");
  strcpy(vs_charset.Items[1],"IBM 8");
  strcpy(vs_charset.Items[2],"SF 7");
  vs_charset.Draw(0);
  char SF7C[]="SF7";
  char IBM8C[]="IBM8";
  CheckBox chk_sf7(26,13,SF7C,SF7Conv);
  CheckBox chk_ibm8(26,14,IBM8C,IBMConv);
  chk_sf7.Draw(0);
  chk_ibm8.Draw(0);
  //chk_ibm8.Handle();
  //vs_charset.Handle();
  cout<<flush;
  int Field=0;                              //Number of curent control
  int operation;                            //1=next -1=prev 0=OK 99=cancel
  do                                        //Handles swinsing between cont-
    {                                       //rols
      switch(Field)
	{
	case 0: operation=txt_name.ReadInput(30);
	  break;
	case 1: operation=txt_alias.ReadInput(30);
	  break;
	case 2: operation=vs_charset.Handle();
	  break;
	case 3: operation=chk_sf7.Handle();
	  break;
	case 4: operation=chk_ibm8.Handle();
	  break;
	}
      if (operation==1)
       {
	 if (Field<4)
	   {
	     Field++;
	   }
	 else Field=0;
       }
      if (operation==-1)
       {
	 if (Field>0)
	   {
	     Field--;
	   }
	 else Field=4;
       }
    }
  while ((operation!=0)&&(operation!=99));
  if (operation==99)                        //When canceling, undo settings
    {
      strcpy(UName,BUName);
      strcpy(UAlias,BUAlias);
    }
  else
    {
      SF7Conv=chk_sf7.Status;               //When accepting, write settings
      IBMConv=chk_ibm8.Status;
      OutChars=vs_charset.Active;
      char CfgName[200];                    //Name of configurationfile
      strcpy (CfgName,LoreHome);
      strcat (CfgName,"config.");
      strcat (CfgName,SesList->Items[IndexID].IDc);
      ofstream CConfig(CfgName,ios::trunc); //Open and clears config.XY
      CConfig.close();
      ofstream ConfFile(CfgName);           //Writes configuration info.
      ConfFile<<"DO_NOT_EDIT_THIS_FILE_BY_HAND "<<strlen(UName)
	<<UName<<" "<<strlen(UAlias)<<UAlias<<" "<<OutChars
	<<" "<<SF7Conv<<" "<<IBMConv;
      ConfFile.close();
    }
  delete BUName;
  delete BUAlias;
  delete SWin;
}
  
void Config::ReadGConfig(void)              //Reads global settings from file
{
  char buffer[200];
  char CfgName[200];                        //Name of configurationfile
  char input1[200];
  int FirstTime=0;
  strcpy (CfgName,LoreHome);
  strcat (CfgName,"config.dat");
  ifstream CfgFile(CfgName);
  if (CfgFile.fail())                       //If firs time
    {
      CfgFile.close();                      //CLoses file tempolari
      strcpy(buffer,LoreHome);
      buffer[strlen(buffer)-1]='\0';        //Creates directoryes
      fork();
      if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
      else execl("/bin/mkdir","mkdir",buffer,NULL);
      strcpy(buffer,LoreHome);
      strcat(buffer,"tmp");
      fork();
      if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
      else execl("/bin/mkdir","mkdir",buffer,NULL);
      ofstream ConfFile(CfgName);           //Writes configuration info.
      ConfFile<<"DO_NOT_EDIT_THIS_FILE_BY_HAND "<<LORE_VERSION<<" "
	      <<"/usr/bin/jed "<<getenv("HOME")<<"/ "<<getenv("HOME")<<"/ "
	      <<getenv("HOME")<<"/.signature "<<getenv("HOME")<<"/.tagline";
      ConfFile.close();
      strcpy(buffer,LoreHome);              //Writes (and chmod) scripts   
      strcat(buffer,"unzip.sh");
      ofstream unzip(buffer);
      unzip<<"#! /bin/tcsh\n/usr/bin/unzip -j $1 -d $2\n";
      unzip.close();
      fork();
      if (getpid()==pid_m)
	{
	  int status;
	  wait(&status);
	}
      else execl("/bin/chmod","chmod","777",buffer,NULL);
      strcpy(buffer,LoreHome);
      strcat(buffer,"del.sh");
      ofstream del(buffer);
      del<<"#! /bin/tcsh\n/bin/rm  $1 $2\n";
      del.close();
      fork();
      if (getpid()==pid_m)
	{
	  int status;
	  wait(&status);
	}
      else execl("/bin/chmod","chmod","777",buffer,NULL);
      strcpy(buffer,LoreHome);
      strcat(buffer,"zip.sh");
      ofstream zip(buffer);
      zip<<"#! /bin/tcsh\n/usr/bin/zip -D $1 $2\n";
      zip.close();
      fork();
      if (getpid()==pid_m)
	{
	  int status;
	  wait(&status);
	}
      else execl("/bin/chmod","chmod","777",buffer,NULL);
      CfgFile.open(CfgName);
      FirstTime=1;
    }
  CfgFile>>input1;                          //Reads "DO_NOTE_EDIT_TH...
  CfgFile>>input1;                          //Reads version
  CfgFile>>Editor;
  CfgFile>>DownLoad;
  CfgFile>>UpLoad;
  CfgFile>>Signature;
  CfgFile>>TagLine;
  CfgFile.close();
  if (FirstTime==1) SetGlob();
}

int Config::CheckPaths(void)                 //Cheks that all paths are OK
{
  if ((Editor[0]!='/')||(DownLoad[0]!='/')||(UpLoad[0]!='/')
      ||(Signature[0]!='/')||(TagLine[0]!='/'))
    {
      Window win_error(25,10,57,16,"ERROR");
      win_error.Draw();
      GotoXY(28,12);
      cout<<"All paths must be absolute."<<flush;
      GotoXY(28,13);
      cout<<"They must begin with \'/\'."<<flush;
      GotoXY(28,15);
      cout<<"[ENTER] OK"<<flush;
      int input;
      do
	{
	  GotoXY (0,0);
	  input=getch();
	}
      while (input!=10);
      return (-1);
    }
  return(0);
}

void Config::SetGlob(void)                  //Global configuration dialog
{
  int NoErrors=0;
  char Caption[]="LORE's configuration";    //Caption of confuguration window
  char *BEditor=new char[strlen(Editor)];   //Bacups of settings (used if can)
  char *BDownLoad=new char[strlen(DownLoad)];//user press ESC
  char *BUpLoad=new char[strlen(UpLoad)];
  char *BSignature=new char[strlen(Signature)];
  char *BTagLine=new char[strlen(TagLine)];
  strcpy(BEditor,Editor);                   //Makes BackUp copyes
  strcpy(BDownLoad,DownLoad);
  strcpy(BUpLoad,UpLoad);
  strcpy(BSignature,Signature);
  strcpy(BTagLine,TagLine);
  SWin = new Window(6,5,74,19,Caption);     //Gonfiguration window
  do
    {
      SWin->Draw();
      GotoXY(9,7); cout<<"Editor";          //Prins labels
      GotoXY(9,9); cout<<"Directories:";
      GotoXY(12,10); cout<<"Download";
      GotoXY(12,11); cout<<"Upload";
      GotoXY(9,13); cout<<"Files:";
      GotoXY(12,14); cout<<"Signature";
      GotoXY(12,15); cout<<"Tagline";
      GotoXY(9,18); cout<<"[UP/DOWN] Move    [ENTER] OK    [ESC] Cancel";
      TextBox txt_editor(16,71,7,Editor);   //Creates textboxes
      txt_editor.Draw();
      TextBox txt_download(22,71,10,DownLoad);
      txt_download.Draw();
      TextBox txt_upload(22,71,11,UpLoad);
      txt_upload.Draw();
      TextBox txt_signature(22,71,14,Signature);
      txt_signature.Draw();
      TextBox txt_tagline(22,71,15,TagLine);
      txt_tagline.Draw();
      int TField=0;                         //Number of curent textbox
      int operation;                        //1=next -1=prev 0=OK 99=cancel
      do                                    //Handles swinsing between text-
	{                                   //boxes
	  switch(TField)
	    {
	    case 0: operation=txt_editor.ReadInput(198);
	      break;
	    case 1: operation=txt_download.ReadInput(198);
	      break;
	    case 2: operation=txt_upload.ReadInput(198);
	      break;
	    case 3: operation=txt_signature.ReadInput(198);
	      break;
	    case 4: operation=txt_tagline.ReadInput(198);
	      break;
	    }
	  if (operation==1)                 //Moves to next textbox
	    {
	      if (TField<4)
		{
		  TField++;
		}
	      else TField=0;
	    }
	  if (operation==-1)                //Moves to previous textbox
	    {
	      if (TField>0)
		{
		  TField--;
		}
	      else TField=4;
	    }
	}
      while ((operation!=0)&&(operation!=99));
      if (operation==99)                    //Restores backups, if operation
	{                                   //was canceled
	  NoErrors=0;
	  strcpy(Editor,BEditor);
	  strcpy(DownLoad,BDownLoad);
	  strcpy(UpLoad,BUpLoad);
	  strcpy(Signature,BSignature);
	  strcpy(TagLine,BTagLine);
	}
      if (operation==0)                     //If user accepted settings
	{
	  NoErrors=CheckPaths();
	  if (DownLoad[strlen(DownLoad)-1]!='/')
	    {
	      int dsize=strlen(DownLoad);
	      DownLoad[dsize]='/';
	      DownLoad[dsize+1]='\0';
	    }
	  if (UpLoad[strlen(UpLoad)-1]!='/')
	    {
	      int dsize=strlen(UpLoad);
	      UpLoad[dsize]='/';
	      UpLoad[dsize+1]='\0';
	    }
	}
    }
  while (NoErrors!=0);
  char CfgName[200];                        //Name of configurationfile
  strcpy (CfgName,LoreHome);
  strcat (CfgName,"config.dat");
  ofstream CConfig(CfgName,ios::trunc);     //Open and clears config.dat
  CConfig.close();
  ofstream ConfFile(CfgName);               //Writes configuration info.
  ConfFile<<"DO_NOT_EDIT_THIS_FILE_BY_HAND "<<LORE_VERSION<<" "
	  <<Editor<<" "<<DownLoad<<" "<<UpLoad<<" "<<Signature
	  <<" "<<TagLine;
  ConfFile.close();
  delete SWin;                              //Deletes backups
  delete BEditor;
  delete BDownLoad;
  delete BUpLoad;
  delete BSignature;
  delete BTagLine;
}

/*****************************************************************************
* Class to show/reedit/undo all operations create by PostMsg -class          *
*****************************************************************************/

void OperList::ReadOperations(void)         //Reads all headerfiles
{
  unsigned char input;
  LastOperation=-1;
  int j,k;
  int ssize;
  glob_t Headers;
  char **Names;
  char *Name;
  char FileMask[200];
  strcpy(FileMask,Settings->LoreHome);      //Constructs FileMask
  strcat(FileMask,"MSGH");
  strcat(FileMask,"???");
  strcat(FileMask,SesList->Items[sessionindex].IDc);
  strcat(FileMask,".");
  strcat(FileMask,SesList->Items[sessionindex].Index);
  Headers.gl_offs=0;
  glob(FileMask, 0, NULL, &Headers);
  Names=Headers.gl_pathv;
  Operations=new OStruct[Headers.gl_pathc];
  for (j=0; j<Headers.gl_pathc; j++)
    {
      LastOperation=j;
      Name=Names[j];
      ifstream HFile(Name);
      if (HFile.fail())
	{
	  cerr<<"Error: cant open \""<<Name<<"\" for reading.\n";
	  cerr<<"Hit any key to exit";
	  cerr<<"Confirmend: "<<getch()<<'\n';
	  ExitNow();
	}
      HFile.get(Operations[j].Command);     //Reads Command
      HFile.get(input); Operations[j].CurBoard=input;  //Reads CurBoard
      HFile.get(input); Operations[j].MoveBoard=input; //Reads MoveBoard
      HFile.get(input); HFile.get(input);   //Removes MsgNumber from stream  
      HFile.get(input); ssize=input;        //Reads size of WhoTo
      for (k=0; k<35; k++)                  //Reads WhoTo
	{
	  HFile.get(Operations[j].WhoTo[k]);
	}
      Operations[j].WhoTo[k]='\0';
      HFile.get(input); ssize=input;        //Reads size of Subject
      for (k=0; k<72; k++)                  //Reads Subject
	{
	  HFile.get(Operations[j].Subject[k]);
	}
      if ((Operations[j].Command & 0x08)!=8)  //Revision h (word for board)
	{
	  Operations[j].MoveBoard=Operations[j].MoveBoard<<8;
	  Operations[j].CurBoard=(Operations[j].CurBoard|Operations[j].MoveBoard);
	}
      else
	{
	  for (k=0; k<28; k++)  HFile.get(input); //Useles info
	  HFile.get(input); int HB=input;
	  HFile.get(input); int HMB=input;
	  HB=HB<<8; HB=HMB<<8;
          Operations[j].CurBoard=(Operations[j].CurBoard | HB);
	  Operations[j].MoveBoard=(Operations[j].MoveBoard|HMB);
	}
      Operations[j].Subject[k]='\0';
      HFile.close();
      int NSize=strlen(Name);               //Ripes all useful info from
      Operations[j].Extension[0]=Name[NSize-3];  //filename
      Operations[j].Extension[1]=Name[NSize-2];
      Operations[j].Extension[2]=Name[NSize-1];
      Operations[j].Extension[3]='\0';
      Operations[j].IDchars[0]=Name[NSize-6];
      Operations[j].IDchars[1]=Name[NSize-5];
      Operations[j].IDchars[2]='\0';
      Operations[j].FIndex[0]=Name[NSize-9];
      Operations[j].FIndex[1]=Name[NSize-8];
      Operations[j].FIndex[2]=Name[NSize-7];
      Operations[j].FIndex[3]='\0';
    }
  globfree(&Headers);
}

void OperList::GetBoardName(unsigned int BrdNum, char *BrdName) //BrdN->BrdName
{
  int j;
  for (j=0; j<=BInfo->MaxBoard; j++)
    {
      if (BInfo->Boards[j].BrdNro==BrdNum)
	{
	  break;
	}     
    }
  strcpy(BrdName,BInfo->Boards[j].BrdName);
}

void OperList::MsgMnu(int Index)            //Things to do message (menu)
{
  char MsgFile[200];
  char HFile[200];
  strcpy(MsgFile,Settings->LoreHome);
  strcat(MsgFile,"MSG");
  strcat(MsgFile,Operations[Index].FIndex);
  strcat(MsgFile,Operations[Index].IDchars);
  strcat(MsgFile,".");
  strcat(MsgFile,Operations[Index].Extension);
  strcpy(HFile,Settings->LoreHome);
  strcat(HFile,"MSGH");
  strcat(HFile,Operations[Index].FIndex);
  strcat(HFile,Operations[Index].IDchars);
  strcat(HFile,".");
  strcat(HFile,Operations[Index].Extension);
  Window win_Menu(30,11,51,16,"Menu");      //Window for menu
  win_Menu.Draw();
  ListBox lst_Menu(33,13,49,14,0);          //Actual menu
  lst_Menu.AddItem(" Edit message   ");
  lst_Menu.AddItem(" Remove message ");
  lst_Menu.Draw();
  int curitem;
  do                                        //Menuloop
    {
      curitem=lst_Menu.Handle();            //Userinput
      if (curitem==0)                       //Edit message
	{
	  char EBase[200];                  //Editor name without path
	  int Size=strlen(Settings->Editor);
	  int j=Size-1;
	  while ((Settings->Editor[j-1]!='/')&&(j>0))
	    {
	      j--;
	    }
	  int i=0;
	  while (j<Size)
	    {
	      EBase[i]=Settings->Editor[j];
	      j++;
	      i++;
	    }
	  EBase[i]='\0';
          fork();                           //Makes clone
          TextColor(white);
          TextBackColor(black);
          ClrAttrib();
          EraseDisplay();
	  int a = 0;
	  if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
	  else
	    {
	      a=execl(Settings->Editor,EBase,MsgFile,NULL);
	      if (a == -1)
		{
		  cerr<<"ERROR: Can't execute editor.\n "
		      <<"Press any ke to continue.\n";
		  getch();
		  exit(1);
		}
	    }
	  TextColor(white);
          TextBackColor(black);
          ClrAttrib();
          EraseDisplay();
	  win_Menu.Draw();
	  lst_Menu.Draw();
        }
      if (curitem==1)
	{
	  fork();                           //Makes clone
          if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
	  else execl("/bin/rm","rm",MsgFile,NULL);
          fork();                           //Makes clone
          if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
	  else execl("/bin/rm","rm",HFile,NULL);
          char Buffer[80];
	  strnadd(Buffer,0," <OPERATION UNDOED>",65);
	  Buffer[65]='\0';
	  lst_Operations->ModifyItem(Buffer,Index);
	  Operations[Index].Command=0x00;
	}
    }
  while ((curitem!=-1)&&(curitem!=1));
}

void OperList::UndoMnu(int Index)           //Undo operation (menu)
{
  char HFile[200];
  strcpy(HFile,Settings->LoreHome);
  strcat(HFile,"MSGH");
  strcat(HFile,Operations[Index].FIndex);
  strcat(HFile,Operations[Index].IDchars);
  strcat(HFile,".");
  strcat(HFile,Operations[Index].Extension);
  Window win_Menu(30,11,51,15,"Menu");      //Window for menu
  win_Menu.Draw();
  ListBox lst_Menu(33,13,49,13,0);          //Actual menu
  lst_Menu.AddItem(" Undo operation ");
  lst_Menu.Draw();
  int curitem;
  do                                        //Menuloop
    {
      curitem=lst_Menu.Handle();            //Userinput 
      if (curitem==0)
	{
          fork();
          if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
	  else execl("/bin/rm","rm",HFile,NULL);
          char Buffer[80];
	  strnadd(Buffer,0," <OPERATION UNDOED>",65);
	  Buffer[65]='\0';
	  lst_Operations->ModifyItem(Buffer,Index);
	  Operations[Index].Command=0x00;
	}
    }
  while ((curitem!=-1)&&(curitem!=0));
}
  
void OperList::LisOper(void)                //Lists all operatons
{
  ReadOperations();                         //Reads all headerfiles
  int Selected;                             //Selected item
  char Buffer[80];
  int j;
  Window win_Operations(5,5,75,21,"List of operations"); //Creates window
  win_Operations.Draw();
  GotoXY(8,20); cout<<"[ENTER] Commands menu  [ESC] Close"<<flush;
  int CI=0;
  lst_Operations=new ListBox(8,7,72,18,CI);
  for (j=0; j<=LastOperation; j++)          //Adds operetions to list
    {
      for (int i=0; i<78; i++) Buffer[i]=' '; Buffer[79]='\0';
      if (0x01 & Operations[j].Command)  strnadd(Buffer,1,"Msg",3);
      if (0x02 & Operations[j].Command)  strnadd(Buffer,1,"Del",3);
      if (0x08 & Operations[j].Command)  strnadd(Buffer,1,"Mov",3);
      if (0x04 & Operations[j].Command)  strnadd(Buffer,1,"Pri",3);
      strnadd(Buffer,6,Operations[j].Subject,23);
      strnadd(Buffer,31,Operations[j].WhoTo,17);
      if (0x08 & Operations[j].Command)     //When moving, two boardnames
	{
          char BoardName[74];
	  GetBoardName(Operations[j].CurBoard,BoardName);
	  strnadd(Buffer,50,BoardName,6);
	  strnadd(Buffer,56,"=>",2);
	  GetBoardName(Operations[j].MoveBoard,BoardName);
	  strnadd(Buffer,58,BoardName,6);
	}
      else
	{
	  char BoardName[74];
	  GetBoardName(Operations[j].CurBoard,BoardName);
	  strnadd(Buffer,50,BoardName,15);
	}
      Buffer[65]='\0';
      lst_Operations->AddItem(Buffer);
    }
  lst_Operations->Draw();
  do
    {
      Selected=lst_Operations->Handle();
      if ((Selected!=-1)&&(LastOperation!=-1))
	{
	  if (0x01 & Operations[Selected].Command)
	    {
	      MsgMnu(Selected);
	    }
          else if (Operations[Selected].Command!=0x00)
	    {
	      UndoMnu(Selected);
	    }
	  win_Operations.Draw();
          GotoXY(8,20); cout<<"[ENTER] Commands menu  [ESC] Close"<<flush;
	  lst_Operations->Draw();
	}  
    }
  while (Selected!=-1);
}


/*****************************************************************************
* Posts message (new message, folowup, move, delete pub/priv togle)          *
*****************************************************************************/

int PostMsg::AskBoard(void)                 //Asks where message will be put
{
  char WCapt[23];
  char Buffer[80];
  //char BNro[4];
  int input1;
  if (MsgType==1) strcpy(WCapt,"Posting - select board");
  if (MsgType==2) strcpy(WCapt,"Folowup - select board");
  if (MsgType==4) strcpy(WCapt,"Moving - select board");
  Window win_SelBoard(5,5,75,21,WCapt);     //Creates window
  Window win_Error(28,10,54,16,"ERROR");
  win_SelBoard.Draw();
  GotoXY(8,20); cout<<"[ENTER] OK    [UP/DOWN] Move    [ESC] Cancel";
  int CI;
  int q=0;
  for (q=0; q<=BInfo->MaxBoard; q++)
    {
      if (BInfo->Boards[q].BrdNro==MsgInfo->MBase[CurMsg].BrdNum) break;
    }
  if (q>BInfo->MaxBoard) q=0;
  if (MsgType==1) CI=0;
  if (MsgType==2) CI=q;
  if (MsgType==4) CI=0;
  ListBox lst_Boards(8,7,72,18,CI);
  for (int j=0; j<=BInfo->MaxBoard; j++)
    {
      for (int i=5; i<78; i++) Buffer[i]=' ';
      Buffer[0] = '\0';
      sprintf (Buffer, "%5d ", BInfo->Boards[j].BrdNro);
      strnadd(Buffer,6,BInfo->Boards[j].BrdName,46);
      if (0x10 & BInfo->Boards[j].BrdStatus)//Board attributes
	{
	  strnadd(Buffer,53,"Net",3);
	}
      else strnadd(Buffer,53,"---",3);
      if (0x04 & BInfo->Boards[j].BrdStatus)
	{
	  strnadd(Buffer,57,"Pri",3);
	}
      else strnadd(Buffer,57,"---",3);
      if (0x08 & BInfo->Boards[j].BrdStatus)
	{
	  strnadd(Buffer,61,"Pub",3);
	}
      else strnadd(Buffer,61,"---",3);
      Buffer[65]='\0';
      lst_Boards.AddItem(Buffer);
    }
  lst_Boards.Draw();
  do
    {
      BrdIndex=lst_Boards.Handle();
      if (BrdIndex==-1) return (-1);
      if (!(0x01 & BInfo->Boards[BrdIndex].BrdStatus)) //Errormessages
	{
	  win_Error.Draw();
	  GotoXY(31,12); cout<<"You don\'t have write-";
	  GotoXY(31,13); cout<<"rights on this board.";
	  GotoXY(31,15); cout<<"[ENTER] OK";
	  do
	    {
	      GotoXY (0,0);
	      input1=getch();
	    }
	  while (input1!=10);
	  win_SelBoard.Draw();
	  GotoXY(8,20); cout<<"[ENTER] OK    [UP/DOWN] Move    [ESC] Cancel";
	  lst_Boards.Draw();
	}
    }
  while (!(0x01 & BInfo->Boards[BrdIndex].BrdStatus));
  return (lst_Boards.ret_brd_nro (BrdIndex));
}

int PostMsg::AskMsgInfo(void)               //Ask subject, reseirver, P/R
{
  char WCapt[50];
  if (MsgType==1) strcpy(WCapt,"Posting - message info");
  if (MsgType==2) strcpy(WCapt,"Folowup - message info");
  if (MsgType==4) strcpy(WCapt,"Moving - message info"); 
  Window win_MsgInfo(5,10,75,18,WCapt);     //Creates window
  win_MsgInfo.Draw();
  GotoXY(8,12); cout<<"To";                 //Labels
  if (MsgType==4)
    {
      GotoXY(8,12);
      cout<<"From";
    }
  GotoXY(8,13); cout<<"Subject";
  GotoXY(8,15); cout<<"Security";
  GotoXY(8,17); cout<<"[ENTER] OK    [UP/DOWN] Move    [ESC] Cancel";
  TextBox txt_To(17,51,12,WhoTo);           //Input-fields
  txt_To.Draw();
  TextBox txt_Subject(17,72,13,Subject);
  txt_Subject.Draw();
  VSelect vs_Security(17,32,15,1);
  vs_Security.Active=Security;
  strcpy(vs_Security.Items[0],"Public");
  strcpy(vs_Security.Items[1],"Private");
  vs_Security.Draw(0);
  int Field=0;                              //Number of curent control
  if (MsgType==4) Field=1;
  int operation;                            //1=next -1=prev 0=OK 99=cancel
  do                                        //Handles swinsing between cont-
    {                                       //rols
      switch(Field)
	{
	case 0: operation=txt_To.ReadInput(34);
	  break;
	case 1: operation=txt_Subject.ReadInput(72);
	  break;
	case 2: operation=vs_Security.Handle();
	  break;
	}
      if (operation==1)
       {
	 if (Field<2)
	   {
	     Field++;
	   }
	 else
	   {
	     Field=0;
	     if (MsgType==4)
	       {
		 Field=1;
	       }
	   }
       }
      if (operation==-1)
       {
         if ((MsgType==4)&&(Field==1)) Field=0;
	 if (Field>0)
	   {
	     Field--;
     	   }
	 else
	   {
	     Field=2;
	   }
       }
    }
  while ((operation!=0)&&(operation!=99));
  if (operation==99) return(-1);
  Security=vs_Security.Active;
  if (((0x08 & BInfo->Boards[BrdIndex].BrdStatus)!=8)&&(Security==0))
      {
	Security=1;
	Window win_Error(26,10,57,17,"ERROR"); //Errormessages
	win_Error.Draw();
        GotoXY(29,12); cout<<"This  board hasn\'t  public";
	GotoXY(29,13); cout<<"messages. Setting security";
	GotoXY(29,14); cout<<"private.";
	GotoXY(29,16); cout<<"[ENTER] OK";
        int input1;
	do
	  {
	    GotoXY (0,0);
	    input1=getch();
	  }
	while (input1!=10);
      }
  if (((0x04 & BInfo->Boards[BrdIndex].BrdStatus)!=4)
      &&(Security==1))
      {
	Security=0;
	Window win_Error(26,10,57,17,"ERROR");
	win_Error.Draw();
        GotoXY(29,12); cout<<"This board hasn\'t private";
	GotoXY(29,13); cout<<"messages. Setting security";
	GotoXY(29,14); cout<<"public.";
	GotoXY(29,16); cout<<"[ENTER] OK";
        int input1;
	do
	  {
	    GotoXY (0,0);
	    input1=getch();
	  }
	while (input1!=10);
      }
  return(0);
}

void PostMsg::GetFreeNames(char *MsgFile, char *HeaderFile)
{
  glob_t OldMsg;                            //Previously posted messages
  char **ONames;
  char *OName;
  char Nro[4];
  char FileMask[200];
  int FirstFree=0;                          //First free index
  int FNumbers[1000];                       //Used indexs
  int OSize=0;
  int j;
  strcpy(FileMask,Settings->LoreHome);      //Constructs FileMask
  strcat(FileMask,"MSGH");
  strcat(FileMask,"???");
  strcat(FileMask,SesList->Items[sessionindex].IDc);
  strcat(FileMask,".");
  strcat(FileMask,SesList->Items[sessionindex].Index);
  OldMsg.gl_offs=0;
  glob(FileMask, 0, NULL, &OldMsg);
  ONames=OldMsg.gl_pathv;
  for (j=0; j<=999; j++) FNumbers[j]=0;     //Clears array
  for (j=0; j<OldMsg.gl_pathc; j++)         //Marks all used inexs
    {
      OName=ONames[j];
      OSize=strlen(OName);
      Nro[0]=OName[OSize-9];
      Nro[1]=OName[OSize-8];
      Nro[2]=OName[OSize-7];
      Nro[3]='\0';
      FNumbers[atoi(Nro)]=1;
    }
  for (j=0; j<=999; j++)                    //Finds first free index
    {
      if (FNumbers[j]==0)
	{
	  FirstFree=j;
	  break;                            //Stops looping, when unused found
	}
    }
  globfree(&OldMsg);
  char stFirstFree[4];
  uitos(FirstFree,stFirstFree);
  strcpy(MsgFile,Settings->LoreHome);
  strcat(MsgFile,"MSG");
  strcat(MsgFile,stFirstFree);
  strcat(MsgFile,SesList->Items[sessionindex].IDc);
  strcat(MsgFile,".");
  strcat(MsgFile,SesList->Items[sessionindex].Index);
  strcpy(HeaderFile,Settings->LoreHome);
  strcat(HeaderFile,"MSGH");
  strcat(HeaderFile,stFirstFree);
  strcat(HeaderFile,SesList->Items[sessionindex].IDc);
  strcat(HeaderFile,".");
  strcat(HeaderFile,SesList->Items[sessionindex].Index);
}

void PostMsg::EditMessage(char *MsgFile)    //Starts editor
{
  ofstream MFile(MsgFile);
  MFile<<" All lines should be shorter than 72 characters. Remove these 2 lines!\n";
  MFile<<"(======================================================================)\n";
  if (MsgType==2)                           //If we are replying, quote message
    {
      unsigned char buffer1[512];
      unsigned char buffer2[512];
      strcpy((char *)buffer2, QUOTE_PREF);
      for (int k=0; k<Message->MxLine; k++)
	{
          strcpy((char *)buffer1,(char *)buffer2);
	  strcpy((char *)buffer2, QUOTE_PREF);
	  strcat((char *)buffer1,Message->MsgText[k]);
          if (strlen((const char *)buffer1)>71)
	    {
	      int h;
	      h=71;
	      while ((buffer1[h]!=' ')&&(h>0)) h--;
	      buffer1[h]='\0'; h++;
	      int g=3;
	      while (buffer1[h]!='\0')
		{
		  buffer2[g]=buffer1[h];
                  g++; h++;
		}
	      buffer2[g]='\0';
	    }
	  else buffer1[72]='\0';
	  MFile<<buffer1<<'\n';
	}
      while (strlen((char *)buffer2)>71)
	{           
	  strcpy((char *)buffer1,(char *)buffer2);
	  strcpy((char *)buffer2, QUOTE_PREF);
	  if (strlen((const char *)buffer1)>71)
	    {
	      int h;
	      h=71;
	      while ((buffer1[h]!=' ')&&(h>0)) h--;
	      buffer1[h]='\0'; h++;
	      int g=3;
	      while (buffer1[h]!='\0')
		{
		  buffer2[g]=buffer1[h];
                  g++; h++;
		}
	      buffer2[g]='\0';
	    }
	  else buffer1[72]='\0';
	}
      MFile<<buffer1<<'\n';
    }
  ifstream TagFile(Settings->TagLine);
  unsigned char Buffer[256][256];
  int MxLine=-1;
  if (!TagFile.fail())
    {
      MFile<<"\n\n. . . ";                      //Tagline
      int pos=-1;
      while (!TagFile.eof())
	{
	  MxLine++;
	  do
	    {
	      pos++;
	      TagFile.get(Buffer[MxLine][pos]);
	    }
	  while ((!TagFile.eof())&&(Buffer[MxLine][pos]!=0x0a)&&(pos<255));
	  Buffer[MxLine][pos]='\0';
          pos=-1;
	}
      int TLine;
      TLine=(int) random();
      while (TLine>MxLine) TLine=TLine/2;
      MFile<<Buffer[TLine]<<'\n';
    }
  ifstream SigFile(Settings->Signature);    //Signature
  unsigned char input;
  if (!SigFile.fail())
    {
      MFile<<"\n\n";
      while (!SigFile.eof())
	{
	  SigFile.get(input);
	  MFile<<input;
	}
    }
  SigFile.close();
  TagFile.close();
  MFile.close(); 
  char EBase[200];                          //Editor's name without path
  int Size=strlen(Settings->Editor);
  int j=Size-1;
  while ((Settings->Editor[j-1]!='/')&&(j>0))
    {
      j--;
    }
  int i=0;
  while (j<Size)
    {
      EBase[i]=Settings->Editor[j];
      j++;
      i++;
    }
  EBase[i]='\0';
  TextColor(white);
  TextBackColor(black);
  ClrAttrib();
  EraseDisplay();
  fork();                                   //Make clone  
  if (getpid()==pid_m)
    {
      int status;
      wait(&status);
    }
  else
    {
      int a = execl(Settings->Editor,EBase,MsgFile,NULL);
      if (a == -1)
	{
	  cerr<<"ERROR: Can't execute editor.\n "
	      <<"Press any ke to continue.\n";
	  getch();
	  exit(1);
	}
    }
  TextColor(white);
  TextBackColor(black);
  ClrAttrib();
  EraseDisplay();
}

void PostMsg::WriteHeader(char *HeaderFile) //Writes message header to file
{
  ofstream HFile(HeaderFile);               //Stream to header-file
  int j;
  unsigned char WCommand;
  unsigned char WCurBoard;              
  unsigned char WMoveBoard;
  unsigned char WMsgNumber[2];              //Emulates one 16bit word
  unsigned char WWhoTo[37];
  unsigned char WSubject[74];
  unsigned char WDestZone[2];
  unsigned char WDestNet[2];
  unsigned char WDestNode[2];
  unsigned char WNetAttrib;
  unsigned char WCurHighBoard='\0';
  unsigned char WMoveHighBoard='\0';
  unsigned char WSpace='\0';
  WCommand=0x00; 
  WCurBoard=0x00;
  WMoveBoard=0x00;
  WMsgNumber[0]=0x00; WMsgNumber[1]=0x00;
  for (j=0; j<37; j++) WWhoTo[j]=0x00;
  for (j=0; j<74; j++) WSubject[j]=0x00;
  WDestZone[1]=DestZone; WDestZone[0]=(DestZone>>8); //Integer to word
  WDestNet[1]=DestNet; WDestNet[0]=(DestNet>>8);
  WDestNode[1]=DestNode; WDestNode[0]=(DestNode>>8);
  WNetAttrib=0x00;
  WSpace=0x00;
  if (MsgType==1)                           //If we are writing new message
    {
      WCommand=WCommand+0x01;
      WCurBoard=Board;
      WMoveBoard=(Board>>8);
      j=strlen(WhoTo);                      //Size of WhoTo
      WWhoTo[0]=j;
      strcat((char *)WWhoTo,(const char *)WhoTo);
      j=strlen(Subject);
      WSubject[0]=j;
      strcat((char *)WSubject,(const char *)Subject);
    }
  if (MsgType==2)                           //If we are replying to  message
    {
      WCommand=WCommand+0x01;
      WCurBoard=Board;
      WMoveBoard=(Board>>8);
      j=strlen(WhoTo);
      WWhoTo[0]=j;
      strcat((char *)WWhoTo,(const char *)WhoTo);
      j=strlen(Subject);
      WSubject[0]=j;
      strcat((char *)WSubject,(const char *)Subject);
      unsigned int MsgNro=MsgInfo->MBase[CurMsg].MsgNum;
      WMsgNumber[1]=MsgNro;  WMsgNumber[0]=(MsgNro>>8);
    }
  if (MsgType==3)                           //If we are deleting message
    {
      WCommand=0x02;
      WCurBoard=MsgInfo->MBase[CurMsg].BrdNum;
      Board=MsgInfo->MBase[CurMsg].BrdNum;
      WMoveBoard=(Board>>8);
      j=strlen(MsgInfo->MBase[CurMsg].From);
      WWhoTo[0]=j;
      strcat((char *)WWhoTo,(const char *)MsgInfo->MBase[CurMsg].From);
      unsigned int MsgNro=MsgInfo->MBase[CurMsg].MsgNum;
      WMsgNumber[1]=MsgNro;  WMsgNumber[0]=(MsgNro>>8);
    }
   if (MsgType==4)                          //If we are moving message
    {
      WCommand=0x08;
      WCurBoard=MsgInfo->MBase[CurMsg].BrdNum;
      Board=MsgInfo->MBase[CurMsg].BrdNum;
      WCurHighBoard=(Board>>8);
      WMoveBoard=MoveTo;
      WMoveHighBoard=(MoveTo>>8);
      j=strlen(WhoTo);
      WWhoTo[0]=j;
      strcat((char *)WWhoTo,(const char *)WhoTo);
      unsigned int MsgNro=MsgInfo->MBase[CurMsg].MsgNum;
      WMsgNumber[1]=MsgNro;  WMsgNumber[0]=(MsgNro>>8);
      j=strlen(Subject);
      WSubject[0]=j;
      strcat((char *)WSubject,(const char *)Subject);
    }
  if (MsgType==5)                           //If we are making message priv.
    {
      WCommand=0x04;
      WCurBoard=MsgInfo->MBase[CurMsg].BrdNum;
      Board=MsgInfo->MBase[CurMsg].BrdNum;
      WMoveBoard=(Board>>8);
      j=strlen(MsgInfo->MBase[CurMsg].From);
      WWhoTo[0]=j;
      strcat((char *)WWhoTo,(const char *)MsgInfo->MBase[CurMsg].From);
      unsigned int MsgNro=MsgInfo->MBase[CurMsg].MsgNum;
      WMsgNumber[1]=MsgNro;  WMsgNumber[0]=(MsgNro>>8);
    }
  if (Security==1) WCommand=WCommand+0x10;  //If message is private
  HFile<<WCommand;
  HFile<<WCurBoard;
  HFile<<WMoveBoard;
  HFile<<WMsgNumber[0]; HFile<<WMsgNumber[1];
  for (j=0; j<36; j++) HFile<<WWhoTo[j];
  for (j=0; j<73; j++) HFile<<WSubject[j];
  HFile<<WDestZone[0];HFile<<WDestZone[1];
  HFile<<WDestNet[0];HFile<<WDestNet[1];
  HFile<<WDestNode[0];HFile<<WDestNode[1];
  HFile<<WNetAttrib;
  for (j=0; j<21; j++) HFile<<WSpace;       //Alias
  HFile<<WCurHighBoard;
  HFile<<WMoveHighBoard;
  for (j=0; j<6; j++) HFile<<WSpace;
  HFile.close();
}

int PostMsg::AskNetMail(void)               //Ask information ned by netmail
{
  char Zone[5]; strcpy(Zone,"0");           //NetMail address on string-form
  char Net[5];  strcpy(Net,"0");
  char Node[5]; strcpy(Node,"0");
  Window win_NetMail(23,10,57,17,"Posting - netmail info");
  win_NetMail.Draw();
  GotoXY(26,12); cout<<"Zone";              //Labels
  GotoXY(26,13); cout<<"Net";
  GotoXY(26,14); cout<<"Node";
  GotoXY(26,16); cout<<"[UP/DOWN]    [ENTER]   [ESC]";
  TextBox txt_Zone(31,34,12,Zone);          //Input-fields
  TextBox txt_Net(31,34,13,Net);
  TextBox txt_Node(31,34,14,Node);
  txt_Zone.Draw();
  txt_Net.Draw();
  txt_Node.Draw();
  int Field=0;                              //Number of curent control
  int operation;                            //1=next -1=prev 0=OK 99=cancel
  do                                        //Handles swinsing between cont-
    {                                       //rols
      switch(Field)
	{
	case 0: operation=txt_Zone.ReadInput(4);
	  break;
	case 1: operation=txt_Net.ReadInput(4);
	  break;
	case 2: operation=txt_Node.ReadInput(4);
	  break;
	}
      if (operation==1)
       {
	 if (Field<2)
	   {
	     Field++;
	   }
	 else Field=0;
       }
      if (operation==-1)
       {
	 if (Field>0)
	   {
	     Field--;
	   }
	 else Field=2;
       }
    }
  while ((operation!=0)&&(operation!=99));
  if (operation==99) return(-1);
  DestZone=atoi(Zone);
  DestNet=atoi(Net);
  DestNode=atoi(Node);
  return(0);
}

int PostMsg::NewMessage(void)               //Posts new message
{
  char MessageFile[200];
  char HeaderFile[200];
  MsgType=1;
  strcpy(WhoTo,"All");
  strcpy(Subject,"");
  Board=AskBoard();                         //Whic board message will be put
  if (Board==-1) return(-1);                //If aborted or no write permmis.
  if (0x04 & BInfo->Boards[BrdIndex].BrdStatus)
                                            //Sets default for security (if
    {                                       //private is avaible, it's priva-
      Security=1;                           //te).
    }
  else Security=0;
  if (AskMsgInfo()==-1) return(-1);         //Ask whoto, subject and security
  DestZone=0;
  DestNet=0;
  DestNode=0;
  if (0x10 & BInfo->Boards[BrdIndex].BrdStatus)//If board is netmailboard
    {
      if (AskNetMail()==-1) return(-1);     //Asks netmail info
    }
  GetFreeNames(MessageFile,HeaderFile);     //Get unused names for files
  WriteHeader(HeaderFile);
  EditMessage(MessageFile);
  return(0);
}

int PostMsg::ReplyMessage(void)             //Replyes to message
{
  char MessageFile[200];
  char HeaderFile[200];
  MsgType=2;
  strcpy(WhoTo,MsgInfo->MBase[CurMsg].From);
  strcpy(Subject,MsgInfo->MBase[CurMsg].Subject);
  Board=AskBoard();                         //Whic board message will be put
  if (Board==-1) return(-1);                //If aborted or no write permmis.
  if (0x04 & BInfo->Boards[BrdIndex].BrdStatus)//Sets default for security (if
    {                                       //private is avaible, it's priva-
      Security=1;                           //te).
    }
  else Security=0;
  if (AskMsgInfo()==-1) return(-1);         //Ask whoto, subject and security
  DestZone=0;
  DestNet=0;
  DestNode=0;
  if (0x10 & BInfo->Boards[BrdIndex].BrdStatus)//If board is netmailboard
    {
      if (AskNetMail()==-1) return(-1);     //Asks netmail info
    }
  GetFreeNames(MessageFile,HeaderFile);     //Get unused names for files
  WriteHeader(HeaderFile);
  EditMessage(MessageFile);
  return (0);
}

int PostMsg::RemoveMsg(void)                //Removes message (SysOp only)
{
  char MessageFile[200];
  char HeaderFile[200];
  int q=0;
  for (q=0; q<=BInfo->MaxBoard; q++)
    if (strcmp(BInfo->Boards[q].BrdName,MsgInfo->MBase[CurMsg].BrdName)==0)
      break;
  if (BInfo->Boards[q].BrdStatus & 0x02) {
  MsgType=3;
  DestZone=0;
  DestNet=0;
  DestNode=0;
  GetFreeNames(MessageFile,HeaderFile);     //Get unused names for files
  WriteHeader(HeaderFile);
  Window win_removed(20,10,61,17,"Notice");
  win_removed.Draw();
  GotoXY(24,12); cout<<"Message has been removed. This will";
  GotoXY(24,13); cout<<"take  a efect after you have uploa-";
  GotoXY(24,14); cout<<"det returnpacket.";
  GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
  int input1;
  do
    {
      GotoXY (0,0);
      input1=getch();
    }
  while (input1!=10);
  return (0);
  }
  else
    {
      Window win_ERROR(20,10,60,17,"ERROR");
      win_ERROR.Draw();
      GotoXY(24,12); cout<<"Moderator priviledges reguired to ";
      GotoXY(24,13); cout<<"perform this operation. You aren't";
      GotoXY(24,14); cout<<"moderator. Opertion aborted!";
      GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
      int input1;
      do
        {
	  GotoXY (0,0);
          input1=getch();
        }
      while (input1!=10);
    }
  return (-1);
}

int PostMsg::MoveMsg(void)                  //Moves message (SysOp only)
{
  char MessageFile[200];
  char HeaderFile[200];
  int q=0;
  for (q=0; q<=BInfo->MaxBoard; q++)
    if (strcmp(BInfo->Boards[q].BrdName,MsgInfo->MBase[CurMsg].BrdName)==0)
      break;
  if (BInfo->Boards[q].BrdStatus & 0x02) {
  MsgType=4;
  DestZone=0;
  DestNet=0;
  DestNode=0;
  MoveTo=AskBoard();                        //Whic board msg will be moved
  if (MoveTo==-1) return(-1);               //If aborted or no write permmis.
  if (0x04 & BInfo->Boards[BrdIndex].BrdStatus)//Sets default for security (if
    {                                       //private is avaible, it's priva-
      Security=1;                           //te).
    }
  else Security=0;
  strcpy(Subject,MsgInfo->MBase[CurMsg].Subject);
  strcpy(WhoTo,MsgInfo->MBase[CurMsg].From);
  if (AskMsgInfo()==-1) return(-1);
  GetFreeNames(MessageFile,HeaderFile);     //Get unused names for files
  WriteHeader(HeaderFile);
  Window win_removed(20,10,60,17,"Notice");
  win_removed.Draw();
  GotoXY(24,12); cout<<"Message has been moved.  This will";
  GotoXY(24,13); cout<<"take a efect after you have uploa-";
  GotoXY(24,14); cout<<"det returnpacket.";
  GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
  int input1;
  do
    {
      GotoXY (0,0);
      input1=getch();
    }
  while (input1!=10);
  return (0);
  }
  else
    {
      Window win_ERROR(20,10,60,17,"ERROR");
      win_ERROR.Draw();
      GotoXY(24,12); cout<<"Moderator priviledges reguired to ";
      GotoXY(24,13); cout<<"perform this operation. You aren't";
      GotoXY(24,14); cout<<"moderator. Opertion aborted!";
      GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
      int input1;
      do
        {
	  GotoXY (0,0);
          input1=getch();
        }
      while (input1!=10);
    }
  return (-1);
}

int PostMsg::MakePrivate(void)              //Makes msg private (SysOp only)
{
  char MessageFile[200];
  char HeaderFile[200];
  int q=0;
  for (q=0; q<=BInfo->MaxBoard; q++)
    if (strcmp(BInfo->Boards[q].BrdName,MsgInfo->MBase[CurMsg].BrdName)==0)
      break;
  if (BInfo->Boards[q].BrdStatus & 0x04) {
  if (BInfo->Boards[q].BrdStatus & 0x02) {
  MsgType=5;
  DestZone=0;
  DestNet=0;
  DestNode=0;
  GetFreeNames(MessageFile,HeaderFile);     //Get unused names for files
  WriteHeader(HeaderFile);
  Window win_removed(20,10,60,17,"Notice");
  win_removed.Draw();
  GotoXY(24,12); cout<<"Message is now private.  This will";
  GotoXY(24,13); cout<<"take a efect after you have uploa-";
  GotoXY(24,14); cout<<"det returnpacket.";
  GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
  int input1;
  do
    {
      GotoXY(0,0);
      input1=getch();
    }
  while (input1!=10);
  return (0);
  }
  else
    {
      Window win_ERROR(20,10,60,17,"ERROR");
      win_ERROR.Draw();
      GotoXY(24,12); cout<<"Moderator priviledges reguired to ";
      GotoXY(24,13); cout<<"perform this operation. You aren't";
      GotoXY(24,14); cout<<"moderator. Opertion aborted!";
      GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
      int input1;
      do
        {
	  GotoXY (0,0);
          input1=getch();
        }
      while (input1!=10);
    }
  }
  else
    {
      Window win_ERROR(20,10,60,17,"ERROR");
      win_ERROR.Draw();
      GotoXY(24,12); cout<<"This board haven't private flack. ";
      GotoXY(24,13); cout<<"Try to move this message to Mail- ";
      GotoXY(24,14); cout<<"are. Opertion aborted!";
      GotoXY(24,16); cout<<"[ENTER] OK"<<flush;
      int input1;
      do
        {
	  GotoXY (0,0);
          input1=getch();
        }
      while (input1!=10);
    }
  return (-1);
}

/*****************************************************************************
* Class to create return-packet (handles allso converting characters)        *
*****************************************************************************/

void RPacket::WriteHeader(void)             //Creates one big headerfile from 
{                                           //from numerous separate headers
  if (OList->LastOperation >=0) {           //If there is minimum 1 operation
  unsigned char input;
  char HeaderFile[200];
  char buffer[200];
  strcpy(HeaderFile,Settings->LoreHome);    //Name of headerfile to create
  strcat(HeaderFile,"/tmp/HEADER");
  strcat(HeaderFile,SesList->Items[sessionindex].IDc);
  strcat(HeaderFile,".BBS");
  ofstream HFile(HeaderFile,ios::trunc);
  HFile.close();
  HFile.open(HeaderFile);
  for (int j=0; j<=OList->LastOperation; j++) //Copy separate headers to hfile
    {
      strcpy(buffer,Settings->LoreHome);
      strcat(buffer,"MSGH");
      strcat(buffer,OList->Operations[j].FIndex);
      strcat(buffer,OList->Operations[j].IDchars);
      strcat(buffer,".");
      strcat(buffer,OList->Operations[j].Extension);
      ifstream ReadFile(buffer);
      if (!ReadFile.fail())
	{
	  while (!ReadFile.eof())
	    {
	      ReadFile.get(input);
              input=OConvert(input);
	      if (ReadFile.fail()!=0) break;
	      HFile<<input;
	    }
	}
      else cerr<<"Ignoring header from \""<<buffer<<"\".\n";
      ReadFile.close();
    }
  HFile.close();
}}

void RPacket::WriteMessages(void)           //Converts chars, line-end
{
  char buffer[200];
  unsigned char input;
  if (OList->LastOperation>=0) {
    for (int j=0; j<=OList->LastOperation; j++) //Chek all operations
    {
      if (0x01 & OList->Operations[j].Command) //If operation is message
	{
	  strcpy(buffer,Settings->LoreHome);   //Name of messagefile
	  strcat(buffer,"MSG");
          strcat(buffer,OList->Operations[j].FIndex);
          strcat(buffer,OList->Operations[j].IDchars);
          strcat(buffer,".");
          strcat(buffer,OList->Operations[j].Extension);
          ifstream ReadFile(buffer);
	  strcpy(buffer,Settings->LoreHome);
	  strcat(buffer,"/tmp/MSG");
	  strcat(buffer,OList->Operations[j].IDchars); //File to write
          char Num100[5];
	  uitos(j,Num100);
	  char Num10[4];
	  Num10[0]=Num100[1]; Num10[1]=Num100[2]; Num10[3]='\0';
	  strcat(buffer,Num10);
	  strcat(buffer,".TXT");
	  ofstream ToFile(buffer, ios::trunc);
	  ToFile.close();
	  ToFile.open(buffer);
	  if (!ReadFile.fail())           //If there is no errors
	    {
	      while (!ReadFile.eof())
		{
		  ReadFile.get(input);
                  if (ReadFile.fail()!=0) break;
                  input=OConvert(input);
		  if (input==0x0a)          //add dos-line-end
		    {
		      input=0x0d;
		      ToFile<<input;
		      input=0x0a;
		      ToFile<<input;
		    }
		  else ToFile<<input;
		}
	    }
	  ReadFile.close();
	  ToFile.close();
	}
    }
}}

void RPacket::WriteSkip(void)               //Writes skipfile (subject)
{
  char CopyFrom[200];
  char CopyTo[200];
  int thereis=0;
  strcpy(CopyFrom,Settings->LoreHome);      //Sile to read from skipped subjs
  strcat(CopyFrom,"SKIPSUBJ.");
  strcat(CopyFrom,SesList->Items[sessionindex].IDc);
  ifstream Test(CopyFrom);
  if (!Test.fail()) thereis=1;
  Test.close();
  if (thereis==1)                           //Copyes skipfile
    {
      strcpy(CopyTo,Settings->LoreHome);
      strcat(CopyTo,"tmp/SKIP");
      strcat(CopyTo,SesList->Items[sessionindex].IDc);
      strcat(CopyTo,".PST");
      fork();
      if (getpid()==pid_m)
	{
	  int status;
	  wait(&status);
	}
      else execl("/bin/cp","cp",CopyFrom,CopyTo,NULL);
    }
}

void RPacket::ClearTemp(void)               //Deletes ~/-LORE/tmp/*
{
  char DelMask[200];
  char Delsh[200];
  strcpy(DelMask,Settings->LoreHome);
  strcat(DelMask,"tmp/*");
  strcpy(Delsh,Settings->LoreHome);
  strcat(Delsh,"del.sh");
  fork();
  if (getpid()==pid_m)
    {
      int status;
      wait(&status);
    }
  else execl(Delsh,"del.sh",DelMask,NULL);
}

void RPacket::WriteTrash(void)              //Writers to skip
{
  char ReadFrom[200];
  strcpy(ReadFrom,Settings->LoreHome);      //File to read from
  strcat(ReadFrom,"SKIPNAME.");
  strcat(ReadFrom,SesList->Items[sessionindex].IDc);
  ifstream RFile(ReadFrom);
  if (!RFile.fail())                      //If skipfile exist
    {
      char WriteTo[200];                    //File to write to
      strcpy(WriteTo,Settings->LoreHome);
      strcat(WriteTo,"tmp/TRASH");
      strcat(WriteTo,SesList->Items[sessionindex].IDc);
      strcat(WriteTo,".PST");
      ofstream WFile(WriteTo);
      unsigned char input;
      while (!RFile.eof())                //Loop until eof
	{
	  RFile.get(input);
	  if (RFile.fail()!=0) break;
	  input=OConvert(input);            //Converts characters
	  if (input==0x0a)                  //Adds DOS-line-end
	    {
	      input=0x0d;
	      WFile<<input;
	      input=0x0a;
	      WFile<<input;
	    }
	  else WFile<<input;
	}
      WFile.close();
    }
  RFile.close();
}

void RPacket::ZipPackets(void)              //Zipps repplypacket
{
  char ZipFile[200];
  char ZipMask[200];
  char Zipsh[200];
  strcpy(ZipFile,Settings->UpLoad);
  strcat(ZipFile,"RETURN");
  strcat(ZipFile,SesList->Items[sessionindex].IDc);
  strcat(ZipFile,".ZIP");
  strcpy(ZipMask,Settings->LoreHome);
  strcat(ZipMask,"tmp/*");
  strcpy(Zipsh,Settings->LoreHome);
  strcat(Zipsh,"zip.sh");
  fork();
  if (getpid()==pid_m)
    {
      int status;
      wait(&status);
    }
  else execl(Zipsh,"zip.sh",ZipFile,ZipMask,NULL);
}

int RPacket::IsOld(void)                    //Test if there is old repplypacket
{
  char ZipFile[200];
  int Exist=0;
  strcpy(ZipFile,Settings->UpLoad);
  strcat(ZipFile,"RETURN");
  strcat(ZipFile,SesList->Items[sessionindex].IDc);
  strcat(ZipFile,".ZIP");
  ifstream TestFile(ZipFile);
  if (!TestFile.fail()) Exist=1;
  TestFile.close();
  if (Exist==1)
    {
      Window win_ERROR(22,10,58,16,"ERROR");
      win_ERROR.Draw();
      GotoXY(25,12); cout<<"Old returnpacket exists ENTER";
      GotoXY(25,13); cout<<"to remove it or ESC to cancel.";
      GotoXY(25,15); cout<<"[ENTER] Remove    [ESC] Cancel"<<flush;
      int input;
      GotoXY (0,0);
      do
	{
	  input=getch();
	}
      while ((input!=10)&&(input!=27));
      char Delsh[200];
      if (input==27) return (-1);
      else
	{
     	  strcpy(Delsh,Settings->LoreHome);
	  strcat(Delsh,"del.sh");
	  fork();
	  if (getpid()==pid_m)
	    {
	      int status;
	      wait(&status);
	    }
	  else execl(Delsh,"del.sh",ZipFile,NULL);
	}
    }
  return (0);
}

void RPacket::WriteAll(void)                //Creates reply-packet
{
  if (IsOld()==0)                           //Test if tehere is old rpacket
    {
      ClearTemp();                          //Clears temp -directory
      WriteHeader();                        //Writes one big header
      WriteMessages();                      //Writes messagefiles at DOS-format
      WriteSkip();                          //Writes skipfile
      WriteTrash();                         //Writes trash file at DOS-format
      ZipPackets();                         //Zip replypacker and mv to updir
      ClearTemp();                          //Clears tempdir
    }
}

RPacket::RPacket()                          //Creates one class which is needet
{
  OList= new OperList;
  OList->ReadOperations();
}

RPacket::~RPacket()                         //Deletes made class
{
  delete OList;
}


/*****************************************************************************
* Main program                                                               *
*****************************************************************************/

int main(void)
{  
  sigblock(SIGINT);
  HasColors=0;
  FFDone=0;
  SManager=0;
  pid_m=getpid();                             //Pid of curent procces
  initscr(); cbreak(); noecho();              //Initialisation of screen
  keypad(stdscr,TRUE); start_color(); clear(); refresh();
  if (strcmp(getenv("TERM"),"xterm")==0)
    {
      cout<<"You TERM-enviroment variable  indicates,  that you are using\n";
      cout<<"some kind of xterm. Pleas note, that  using xterm will cause\n";
      cout<<"much slowdown.  Note allso, that  color_xterm isn't goot for\n";
      cout<<"this program because color_xterm has only 8 colors, and this\n";
      cout<<"program uses 16 colors. It will work in  color_xterm,  but I\n";
      cout<<"recomment that you would use local console or ansi_xterm. \n\n";
    }
  cout<<"Is your terminal capable to colors (Y/N)? "<<flush;
  char *cp;
  cp = getenv("LORE_COLORS");
  if (cp == NULL)
    {
      int input;
      do
	{
	  input=getch();
	}
      while ((input!='Y')&&(input!='y')&&(input!='N')&&(input!='n'));
      if ((input=='Y')||(input=='y')) HasColors=1;
    }
  else if (strcmp (cp, "true") == 0)
    {
      cout<<"Y ($LORE_COLORS=true)\n";
      HasColors = 1;
    }
  else if (strcmp (cp, "false") == 0) cout<<"N ($LORE_COLORS=false)\n";
  else cerr<<"$LORE_COLORS must be true or false, or unset.\n";
    
  Settings = new Config;                      //LORE's configuration
  MakeMenu();                                 //Creates menus
  SesList = new MListBox;                     //Session selection listbox
  SesList->Handle();
  delete FileH; 
  ClrAttrib();
  echo();
  endwin();
  delete BInfo;
  delete MsgInfo;
  delete Settings;
}


/*****************************************************************************
*  Help while reading messages                                               *
*****************************************************************************/

void RHelp(void)
{
  Window win_Help(2,2,78,LINES-1,"Help");
  win_Help.Draw();
  ListBox lst_Help(5,4,75,LINES-3,0);
  lst_Help.AddItem(" Moving                                                                ");
  lst_Help.AddItem("   Up         Moves one line up                                        ");
  lst_Help.AddItem("   Down       Moves one line down                                      ");
  lst_Help.AddItem("   Left       Previous message                                         ");
  lst_Help.AddItem("   Right, n   Next message                                             ");
  lst_Help.AddItem("   Space      Next screen                                              ");
  lst_Help.AddItem("   Enter      Next/screen and if end of message, next message          ");
  lst_Help.AddItem("                                                                       ");
  lst_Help.AddItem(" Shortcuts                                                             ");
  lst_Help.AddItem("   ESC, m     Menu (wait 1 second, because of terminal-escapes)        ");
  lst_Help.AddItem("   h,?        This helpscreen                                          ");
  lst_Help.AddItem("   i          Index                                                    ");
  lst_Help.AddItem("   f          Folowup                                                  ");
  lst_Help.AddItem("   p          Post message                                             ");
  lst_Help.AddItem("   b          Bookmarks                                                ");
  lst_Help.AddItem("   s          Skip subject                                             ");
  lst_Help.AddItem("   w          Skip writer                                              ");
  lst_Help.AddItem("   F          Find                                                     ");
  lst_Help.AddItem("   g          Find next                                                ");
  lst_Help.AddItem("   o          Save to file                                             ");
  lst_Help.AddItem("   x          Exit                                                     ");
  lst_Help.AddItem("   c          Close session                                            ");
  lst_Help.AddItem("   R          Remove message        (SysOp)                            ");
  lst_Help.AddItem("   P          Make message private  (SysOp)                            ");
  lst_Help.AddItem("   M          Move message          (SysOp)                            ");
  lst_Help.AddItem("                                                                       ");
  lst_Help.AddItem(" Dialogs                                                               ");
  lst_Help.AddItem("   ENTER      OK/Save/Menu                                             ");
  lst_Help.AddItem("   ESC        Close/Cancel                                             ");
  lst_Help.AddItem("   Up         Moves selector up                                        ");
  lst_Help.AddItem("   Down       Moves selector down                                      ");
  lst_Help.AddItem("                                                                       ");
  lst_Help.AddItem(" Now press ESC or ENTER to close help.                                 ");
  lst_Help.Draw();
  lst_Help.Handle();
}


/*****************************************************************************
*  Help in session selection listboc                                         *
*****************************************************************************/

void SHelp(void)
{
  Window win_Help(2,2,78,LINES-1,"Help");
  win_Help.Draw();
  ListBox lst_Help(5,4,75,LINES-3,0);
  lst_Help.AddItem(" Moving                                                                ");
  lst_Help.AddItem("   Up         Moves selector one line up                               ");
  lst_Help.AddItem("   Down       Moves selector one line down                             ");
  lst_Help.AddItem("   Enter      Selects session                                          ");
  lst_Help.AddItem("                                                                       ");
  lst_Help.AddItem(" Shortcuts                                                             ");
  lst_Help.AddItem("   ESC, m     Menu (wait 1 second, because of terminal-escapes)        ");
  lst_Help.AddItem("   h,?        This helpscreen                                          ");
  lst_Help.AddItem("   x          Exit                                                     ");
  lst_Help.AddItem("                                                                       ");
  lst_Help.AddItem(" Dialogs                                                               ");
  lst_Help.AddItem("   ENTER      OK/Save/Menu                                             ");
  lst_Help.AddItem("   ESC        Close/Cancel                                             ");
  lst_Help.AddItem("   Up         Moves selector up                                        ");
  lst_Help.AddItem("   Down       Moves selector down                                      ");
  lst_Help.AddItem("                                                                       ");
  lst_Help.AddItem(" Now press ESC or ENTER to close help.                                 ");
  lst_Help.Draw();
  lst_Help.Handle();
}


/*****************************************************************************
*  About-box                                                                 *
*****************************************************************************/

void LAbout(void)
{
  Window AboutWin(2,2,78,LINES-1,"About");
  AboutWin.Draw();
  ListBox lst_About(5,4,75,LINES-3,0);
  char a[77];
  strcpy(a, "                      Linux OMEN Reader ");
  strcat(a, LORE_VERSION);
  strcat(a,"                           "); 
  lst_About.AddItem (a);
  lst_About.AddItem("               Copyrights (c) 1995 by Ville Hallivuori.                ");
  lst_About.AddItem("                                                                       ");
  lst_About.AddItem(" This program is free software; you can redistribute it and/or modify  "); 
  lst_About.AddItem(" it under the terms of the GNU General Public License version 2 as     ");
  lst_About.AddItem(" published by the Free Software Foundation.                            ");
  lst_About.AddItem("                                                                       ");
  lst_About.AddItem(" This program is distributed in the hope that it will be useful        ");
  lst_About.AddItem(" but WITHOUT ANY WARRANTY; without even the implied warranty of        ");
  lst_About.AddItem(" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         ");
  lst_About.AddItem(" GNU General Public License for more details.                          ");
  lst_About.AddItem("                                                                       ");
  lst_About.AddItem(" You should have received a copy of the GNU General Public License     ");
  lst_About.AddItem(" along with this program; if not, write to the Free Software           ");
  lst_About.AddItem(" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             ");
  lst_About.AddItem("                                                                       ");
  lst_About.AddItem(" If you liked this program (this is not 'a must') send postcard or     ");
  lst_About.AddItem(" or E-mail to author (all bugreports, wishes for ports, whishes for    ");
  lst_About.AddItem(" new features, etc  are welcome). If you know BBS where I am then you  ");
  lst_About.AddItem(" can send mail there.                                                  ");
  lst_About.AddItem("                                                                       ");
  lst_About.AddItem(" Author:             Ville Hallivuori                                  ");
  lst_About.AddItem("                     Seilimki 12 i                                    ");
  lst_About.AddItem("                     02180 ESPOO 18, Finland                           ");
  lst_About.AddItem("                     vph@clinet.fi                                     ");
  lst_About.AddItem("                                                                       ");
  lst_About.AddItem("                     http://www.clinet.fi/~vph/                        ");
  lst_About.AddItem(" Press ENTER to close window (and remember to send mail to author).    ");
  lst_About.Draw();
  lst_About.Handle();
}


/*****************************************************************************
*  Creates index                                                             *
*****************************************************************************/

void Index(void)
{
  Window win_Index(5,5,75,21,"Index");
  win_Index.Draw();
  GotoXY(8,20); cout<<"[ENTER] Jump    [UP/DOWN] Move    [ESC] Cancel"<<flush;
  ListBox lst_Skip(8,7,72,18,CurMsg);
  char buffer[200];
  for (int j=0; j<=MsgInfo->MaxMsg; j++)
    {
      for (int i=0; i<199; i++) buffer[i]=' '; buffer[199]='\0';
      strnadd(buffer,1,MsgInfo->MBase[j].Subject,27);
      strnadd(buffer,30,MsgInfo->MBase[j].From,15);
      strnadd(buffer,45," => ",4);
      strnadd(buffer,49,MsgInfo->MBase[j].To,15);
      buffer[65]='\0';
      lst_Skip.AddItem(buffer);
    }
  lst_Skip.Draw();
  int operation;
  operation=lst_Skip.Handle();
  if (operation!=-1)
    {
      CurMsg=operation;
      Message->msgpos=0;
    }
}


/*****************************************************************************
* Replyes to messa                                                           *
*****************************************************************************/

void RP(void)                           
{
  RPacket Reply;
  Reply.WriteAll();
}


/*****************************************************************************
* This class keeps track on skipped messages                                 *
*****************************************************************************/

SkipList::SkipList(void)
{
}

void SkipList::ReadFiles(void)                //Raeads SKIPNAME.xy and
{                                             //SKIPSUBJ.xy -files
  unsigned char buffer[200];
  int Size;
  int j;
  unsigned char input;
  LastName=-1;                                //Clears skipped writers
  LastSubject=-1;                             //Clears skipped subjects
  strcpy((char *)buffer,(const char *)Settings->LoreHome);//Whole name of SKIPNAME.xy
  strcat((char *)buffer,"SKIPNAME.");
  strcat((char *)buffer,(const char *)SesList->Items[sessionindex].IDc);
  ifstream NameSkip((const char *)buffer);    //Opens SKIPNAME.xy for reading
  if (!NameSkip.fail())                     //If file exists
    {
      while (!NameSkip.eof())               //While not end of file
 	{
          j=0;
	  while(NameSkip.peek()!=0x0a)        //While not end of line
	    {
              if (NameSkip.eof()) break;
	      NameSkip.get(input);
	      buffer[j]=input;
	      j++;
	    }
	  buffer[j]='\0';                     //Adds null
          if (!NameSkip.eof())
	    {
	      LastName++;
	      Names[LastName]=new char[j+1];  //Allocates memory for name
	      strcpy((char *)Names[LastName],(const char *)buffer);
	      if (NameSkip.peek()==0x0a) NameSkip.get(input); //Reads EOL
	    }
	  if (NameSkip.eof()) break;
	}
    }
  NameSkip.close();
  strcpy((char *)buffer,(const char *)Settings->LoreHome); //Whole name of SKIPSUBJ.xy
  strcat((char *)buffer,"SKIPSUBJ.");
  strcat((char *)buffer,(const char *)SesList->Items[sessionindex].IDc);
  ifstream SubjSkip((char *)buffer);          //Opens SKIPSUBJ.xy fo readinf
  while ((!SubjSkip.eof()) && (!SubjSkip.fail()))               
    {
      SubjSkip.get(input);                //Reads subject's size
      if (SubjSkip.eof()) break;
      Size=input;
      for (j=0; j<72; j++)                //Reads subject
	{
	  SubjSkip.get(input);
	  if (j<Size)
	    {
	      buffer[j]=input;
	    }
	  else buffer[j]='\0';            //Put empty character to null
	}
      buffer[72]='\0';                    //Add null (for long subjects
      LastSubject++;
      Subjects[LastSubject]=new char[strlen((const char *)buffer)+1];
      strcpy((char *)Subjects[LastSubject],(const char *)buffer);
    }
SubjSkip.close();
}

int SkipList::IsSkipped(int MsgNro)           //Test, if msg has been skipped
{
  char *Subject;                              //Subject of message
  char *Writer;                               //Writer of message
  int j=0;
  char WriterC='\0'; char SubjectC='\0';
  Subject = new char[strlen(MsgInfo->MBase[MsgNro].Subject)];
  strcpy(Subject,MsgInfo->MBase[MsgNro].Subject);
  Writer = new char[strlen(MsgInfo->MBase[MsgNro].From)+1];
  strcpy(Writer,MsgInfo->MBase[MsgNro].From);
  for (j=0; j<=LastName; j++)                 //Tests if writer  has been skipp
    {
      if (strcmp(Writer,Names[j])==0)
	{
	  WriterC='\1';
	  break;
	}
    }
  for(j=0; j<=LastSubject; j++)
    {
      if (strcmp(Subject, Subjects[j])==0)
	{
	  SubjectC='\1';
	  break;
	}
    }
  if ((WriterC=='\1')&&(SubjectC=='\0')) return(1);
  if ((WriterC=='\0')&&(SubjectC=='\1')) return(2);
  if ((WriterC=='\1')&&(SubjectC=='\1')) return(3);
  return(0);
}
		 
void SkipName(void)                           //List of skipped names
{
  int curitem=0;
  char buffer[200];                           //If name is not skipped
  if ((Skip->IsSkipped(CurMsg)!=1)&&(Skip->IsSkipped(CurMsg)!=3))
    {
      Window win_SkipName(25,10,55,16,"Skip writer");
      win_SkipName.Draw();
      GotoXY(28,15); cout<<"[ENTER] OK"<<flush;
      ListBox lst_Menu(28,12,43,13,0);        //Actual menu
      lst_Menu.AddItem(" Skip writer             ");
      lst_Menu.AddItem(" Do not skip writer      ");
      lst_Menu.Draw();
      curitem=lst_Menu.Handle();              //Userinput
      if (curitem==0)
	{
	  strcpy(buffer,Settings->LoreHome);  //Whole name of SKIPNAME.xy
	  strcat(buffer,"SKIPNAME.");
	  strcat(buffer,SesList->Items[sessionindex].IDc);
	  ofstream NameFile(buffer,ios::app);
	  NameFile<<MsgInfo->MBase[CurMsg].From<<'\n';
	  Skip->LastName++;
	  Skip->Names[Skip->LastName]=new char[strlen(MsgInfo->MBase[CurMsg].From)+1];
	  strcpy(Skip->Names[Skip->LastName],MsgInfo->MBase[CurMsg].From);
	  NameFile.close();
	}
    }
  if (curitem!=-1)                            //If user haven't pressed ESC
    {
      Window win_SWri(5,5,75,21,"Skiped writers");
      win_SWri.Draw();
      GotoXY(8,20); cout<<"[ENTER] Remove    [UP/DOWN] Move    [ESC] Close"
			<<flush;
      ListBox lst_SWri(8,7,72,18,0);
      int j;
      for (j=0; j<199; j++) buffer[j]=' ';
      buffer[199]='\0';
      for (j=0; j<=Skip->LastName; j++)
	{
	  for (int i=0; i<199; i++) buffer[i]=' ';
	  buffer[199]='\0';
          strnadd(buffer,1,Skip->Names[j],58);
	  buffer[65]='\0';
	  lst_SWri.AddItem(buffer);
	}
      lst_SWri.Draw();
      int SItem;
      do
	{
	  SItem=lst_SWri.Handle();
	  if (SItem!=-1)
	    {
	      strcpy(buffer,Settings->LoreHome);  //Whole name of SKIPNAME.xy
	      strcat(buffer,"SKIPNAME.");
	      strcat(buffer,SesList->Items[sessionindex].IDc);
	      ofstream NameFile(buffer,ios::trunc);
	      NameFile.close();
	      NameFile.open(buffer);
	      for (j=0; j<=Skip->LastName; j++)
		{
		  if (j!=SItem)
		    {
		      NameFile<<Skip->Names[j]<<'\n';
		    }
		}
	      NameFile.close();
	      Skip->ReadFiles();
              lst_SWri.LastItem=-1;
	      for (j=0; j<199; j++) buffer[j]=' ';
	      buffer[199]='\0';
	      if (Skip->LastName>MaxNameSkip-1) Skip->LastName=MaxNameSkip-1;
	      for (j=0; j<=Skip->LastName; j++)
		{
		  for (int i=0; i<199; i++) buffer[i]=' ';
		  buffer[199]='\0';
		  strnadd(buffer,1,Skip->Names[j],58);
		  buffer[65]='\0';
		  lst_SWri.AddItem(buffer);
		}
	    }
	  win_SWri.Draw();
          GotoXY(8,20); cout<<"[ENTER] Remove    [UP/DOWN] Move    [ESC] Close"
			    <<flush;
	  lst_SWri.Draw();
	}
      while (SItem!=-1);
    }
}

void SkipSubject(void)                      //List of skipped subjects
{ 
  int curitem=0;
  char buffer[200]; 
  if ((Skip->IsSkipped(CurMsg)!=2)&&(Skip->IsSkipped(CurMsg)!=3)) 
    {
      Window win_SkipSubject(25,10,55,16,"Skip subject");
      win_SkipSubject.Draw();
      GotoXY(28,15); cout<<"[ENTER] OK"<<flush;
      ListBox lst_Menu(28,12,43,13,0);        //Actual menu
      lst_Menu.AddItem(" Skip subject            ");
      lst_Menu.AddItem(" Do not skip subject     ");
      lst_Menu.Draw();
      curitem=lst_Menu.Handle();              //Userinput
      if (curitem==0)
	{
	  strcpy(buffer,Settings->LoreHome);  //Whole name of SKIPSUBJ.xy
	  strcat(buffer,"SKIPSUBJ.");
	  strcat(buffer,SesList->Items[sessionindex].IDc);
	  ofstream SubjFile(buffer,ios::app);
          int iSize;
	  iSize=strlen(MsgInfo->MBase[CurMsg].Subject);
	  unsigned char aSize=iSize;
	  SubjFile<<aSize;
	  for (int j=0; j<72; j++)
	    {
	      if (j<iSize)
		{
		  SubjFile<<MsgInfo->MBase[CurMsg].Subject[j];
		}
	      else SubjFile<<'\0';
	    }
	  Skip->LastSubject++;
	  Skip->Subjects[Skip->LastSubject]=new char[strlen(MsgInfo->MBase[CurMsg].Subject)+1];
	  strcpy(Skip->Subjects[Skip->LastSubject],MsgInfo->MBase[CurMsg].Subject);
	  SubjFile.close();
	}
    }
  if (curitem!=-1)                            //If user haven't pressed ESC
    {
      Window win_SSubj(5,5,75,21,"Skiped subjects");
      win_SSubj.Draw();
      GotoXY(8,20); cout<<"[ENTER] Remove    [UP/DOWN] Move    [ESC] Close"
			<<flush;
      ListBox lst_SSubj(8,7,72,18,0);
      int j;
      for (j=0; j<199; j++) buffer[j]=' ';
      buffer[199]='\0';
      for (j=0; j<=Skip->LastSubject; j++)
	{
	  for (int i=0; i<199; i++) buffer[i]=' ';
	  buffer[199]='\0';
          strnadd(buffer,1,Skip->Subjects[j],58);
	  buffer[65]='\0';
	  lst_SSubj.AddItem(buffer);
	}
      lst_SSubj.Draw(); 
      int SItem; 
      do 
	{ 
	  SItem=lst_SSubj.Handle();
	  if (SItem!=-1) 
	    { 
	      strcpy(buffer,Settings->LoreHome);  //Whole name of SKIPNAME.xy
	      strcat(buffer,"SKIPSUBJ.");
	      strcat(buffer,SesList->Items[sessionindex].IDc); 
	      ofstream SubjFile(buffer,ios::trunc); 
	      SubjFile.close();
	      SubjFile.open(buffer);
	      for (j=0; j<=Skip->LastSubject; j++)
		{
		  if (j!=SItem)
		    { 
                      int iSize=strlen(Skip->Subjects[j]);
		      char aSize=iSize;
		      SubjFile<<aSize;
		      for (int l=0; l<72; l++)
			{
			  if (iSize>l)
			    {
			      SubjFile<<Skip->Subjects[j][l];
			    }
			  else SubjFile<<'\0';
			}
		    }
		}
	      SubjFile.close(); 
	      Skip->ReadFiles(); 
              lst_SSubj.LastItem=-1; 
	      for (j=0; j<199; j++) buffer[j]=' ';
	      buffer[199]='\0';
	      if (Skip->LastSubject>MaxSubjSkip-1) Skip->LastSubject=MaxSubjSkip-1;
	      for (j=0; j<=Skip->LastSubject; j++)
		{
		  for (int i=0; i<199; i++) buffer[i]=' '; 
		  buffer[199]='\0'; 
		  strnadd(buffer,1,Skip->Subjects[j],58); 
		  buffer[65]='\0'; 
		  lst_SSubj.AddItem(buffer);
		}
	    }
	  win_SSubj.Draw();
          GotoXY(8,20); cout<<"[ENTER] Remove    [UP/DOWN] Move    [ESC] Close"
			    <<flush; 
	  lst_SSubj.Draw(); 
	}
      while (SItem!=-1); 
    }
}


/*****************************************************************************
* Saves message to file                                                      *
*****************************************************************************/

void Save2File(void)
{
  char FileName[200];
  strcpy(FileName,getenv("HOME"));
  strcat(FileName,"/smessages.txt");
  Window win_Save(20,8,60,13,"Save to file");
  win_Save.Draw();
  GotoXY(23,10); cout<<"Filename";
  GotoXY(23,12); cout<<"[ENTER] OK     [ESC] Cancel"<<flush;
  TextBox txt_FileName(32,57,10,FileName);
  txt_FileName.Draw();
  int operation;
  do
    {
      operation=txt_FileName.ReadInput(190);
    }
  while ((operation!=99)&&(operation!=0));
  if (operation==0)                         //Writes messages header (filtred)
    {
      ofstream SaveFile(FileName,ios::app);
      SaveFile<<"\n---[BEGIN OF SAVED MESSAGE]---\n";
      SaveFile<<"BBS:       "<<BInfo->SystemName<<'\n';
      SaveFile<<"From:      "<<MsgInfo->MBase[CurMsg].From<<'\n';
      SaveFile<<"To:        "<<MsgInfo->MBase[CurMsg].To<<'\n';
      SaveFile<<"Subject:   "<<MsgInfo->MBase[CurMsg].Subject<<'\n';
      SaveFile<<"Time/Date: "<<MsgInfo->MBase[CurMsg].Time<<'/'
	      <<MsgInfo->MBase[CurMsg].Date<<"\n";
      SaveFile<<"\n---\n";
      int j=0;
      while (MsgInfo->MBase[CurMsg].tpointer[j]!=3) //Writes messages text
	{
          if (MsgInfo->MBase[CurMsg].tpointer[j]!=0x0d)
	    SaveFile<<MsgInfo->MBase[CurMsg].tpointer[j];
          j++;
	}
      SaveFile<<"\n---[END OF SAVED MESSAGE]---\n";
      SaveFile.close();
    }
}

/*****************************************************************************
* Messages to you - find all messges where you are in to-line                *
*****************************************************************************/

void MTY(void)
{
  int LastMsg=-1;                             //Pointer' to last found message
  int Found[1001];
  int j;
  for (j=0; j<=MsgInfo->MaxMsg; j++)
    {
      if ((strcmp(Settings->UName,MsgInfo->MBase[j].To)==0)
	  ||(strcmp(Settings->UAlias,MsgInfo->MBase[j].To)==0))
	{
	  LastMsg++;
	  Found[LastMsg]=j;
	}
    }
  if (LastMsg==-1)
    {
      Window win_NoMessages(28,10,53,16,"ERROR"); //If there is not any 
      win_NoMessages.Draw();
      GotoXY(31,12); cout<<"There is not any mes-";
      GotoXY(31,13); cout<<"sages to you. Sorry.";
      GotoXY(31,15); cout<<"[ENTER] OK";
      int input1;
      do
	{
	  GotoXY (0,0);
	  input1=getch();
	}
      while (input1!=10);
    }
  else
    {
      Window win_MTY(5,5,75,21,"Messages to you");
      win_MTY.Draw();
      GotoXY(8,20); cout<<"[ENTER] Jump    [UP/DOWN] Move    [ESC] Cancel"
			<<flush;
      ListBox lst_MTY(8,7,72,18,0);
      char buffer[100];
      for (j=0; j<99; j++) buffer[j]=' ';
      buffer[74]='\0';
      for (j=0; j<=LastMsg; j++)
	{
	  for (int i=0; i<99; i++) buffer[i]=' ';
	  buffer[99]='\0';
          strnadd(buffer,1,MsgInfo->MBase[Found[j]].BrdName,18);
	  strnadd(buffer,21,MsgInfo->MBase[Found[j]].Subject,29);
	  strnadd(buffer,52,MsgInfo->MBase[Found[j]].From,11);
	  buffer[65]='\0';
	  lst_MTY.AddItem(buffer);
	}
      lst_MTY.Draw();
      int SItem=lst_MTY.Handle();
      if (SItem!=-1)
	{
	  CurMsg=Found[SItem];
	  Message->msgpos=0;
	}
    }
}


/*****************************************************************************
* Bookmarks                                                                  *
*****************************************************************************/

void Markings(void)                           //Modify bookmarks
{
  char MarkFile[200];                         //Name of bookmarkfile
  char buffer[202];
  int Marks[1000];                            //Internal numbers of marked msg
  int LastMark=-1;
  int curitem=1;
  int CurMark=0;
  for (int k=0; k<200; k++) MarkFile[k]='\0';
  strcpy(MarkFile,Settings->LoreHome);
  strcat(MarkFile,"MARKS");
  strcat(MarkFile,SesList->Items[sessionindex].IDc);
  strcat(MarkFile,".");
  strcat(MarkFile,SesList->Items[sessionindex].Index);
  ifstream OldMarks(MarkFile);
  if (OldMarks.fail())
    {
      while(!OldMarks.eof())
	{
	  LastMark++;
	  OldMarks>>Marks[LastMark];
          if ((Marks[LastMark]=='\n')||(OldMarks.fail()!=0)) LastMark--;
	}
    }
  OldMarks.close();
  int j;
  for (j=0; j<=LastMark; j++)
    {
      if (Marks[j]==CurMsg) CurMark=1;
    }
  if (CurMark==0)
    {
      Window win_MarkMsg(25,10,55,16,"Mark message");
      win_MarkMsg.Draw();
      GotoXY(28,15); cout<<"[ENTER] OK"<<flush;
      ListBox lst_Menu(28,12,43,13,0);        //Actual menu
      lst_Menu.AddItem(" Mark this message       ");
      lst_Menu.AddItem(" Don't mark this message ");
      lst_Menu.Draw();
      curitem=lst_Menu.Handle();              //Userinput
      if (curitem==0)
	{
	  ofstream NewMark(MarkFile,ios::app);
	  if (NewMark.fail())
	    {
	      cerr<<"Error: cant open \""<<MarkFile<<"\" for writing.\n";
	      cerr<<"Cant save this bookmark to the disk.";
	      getch();
	    }
	  NewMark<<CurMsg; NewMark<<'\n';
          LastMark++;
          Marks[j]=CurMsg;
	}
    }
  if (curitem!=-1)
    {
      Window win_MarkList(10,6,70,20,"Bookmarks");
      win_MarkList.Draw();
      GotoXY(13,19); cout<<"[ENTER] Menu    [ESC] Close    [UP/DOWN] Move"
			 <<flush;
      int StartItem=-1;
      if (LastMark>=0) StartItem=0;
      ListBox lst_MarkList(13,8,67,17,StartItem); //17  
      //for (j=0; j<199; j++) buffer[j]=' ';
      buffer[199]='\0';
      for (j=0; j<=LastMark; j++)
	{
          for (int i=0; i<199; i++) buffer[i]=' ';
	  strnadd(buffer,1,MsgInfo->MBase[Marks[j]].Subject,23);
	  strnadd(buffer,26,MsgInfo->MBase[Marks[j]].From,12);
          strnadd(buffer,38," => ",4);
	  strnadd(buffer,42,MsgInfo->MBase[Marks[j]].To,12);
	  buffer[55]='\0';
	  lst_MarkList.AddItem(buffer);
	}
      lst_MarkList.Draw();
      int SItem;
      do
	{
	  SItem=lst_MarkList.Handle();
          if (SItem!=-1)
	    {
	      Window win_Menu(24,10,55,15,"Menu");
	      win_Menu.Draw();
	      ListBox lst_Menu(27,12,72,13,0);
              lst_Menu.AddItem(" Jump selected message    ");
	      lst_Menu.AddItem(" Remove selected bookmark ");
	      lst_Menu.Draw();
	      int SSItem=lst_Menu.Handle();
	      win_MarkList.Draw();
	      GotoXY(13,19); cout<<"[ENTER] Menu    [ESC] Close    [UP/DOWN]"
				 <<" Move"<<flush;
	      lst_MarkList.Draw();
              if (SSItem==0)
		{
		  CurMsg=Marks[SItem];
		  Message->msgpos=0;
		  break;
		}
	      if (SSItem==1)
		{
		  ofstream NewMarks(MarkFile,ios::trunc);
		  if (NewMarks.fail())
		    {
		      cerr<<"Error: cant open \""<<MarkFile<<"\" for writing.\n";
		      cerr<<"Bookmarks won't be saved.";
		    }
		  NewMarks.close(); NewMarks.open(MarkFile);
		  for (j=0; j<=LastMark; j++)
		    {
		      if (j!=SItem)
			{
			  NewMarks<<Marks[j];
			  NewMarks<<'\n';
			}
		    }
		  NewMarks.close();
		  break;
		}
	    }
	}
      while (SItem!=-1);
    }
}


/*****************************************************************************
*    Finds text from messages                                                *
*****************************************************************************/

void FindFirst(void)                          //Finds text from messages
{
 
  char STMsg='\001';
  FindText[0]='\0';
  Window win_FindFirst(17,10,63,17,"Find");
  win_FindFirst.Draw();
  GotoXY(20,12); cout<<"Text to find";
  GotoXY(20,16); cout<<"[ENTER] OK    [ESC] Cancel"<<flush;
  TextBox txt_Find(33,60,12,FindText);
  CheckBox chk_STMsg(20,14,"Start from this message",STMsg);
  txt_Find.Draw();
  chk_STMsg.Draw(0);
  int Field=0;
  int operation;                              //1=next -1=prev 0=OK 99=cancel
  do                                          //Handles swinsing between text-
    {                                         //boxes
      switch(Field)
	{
	case 0: operation=txt_Find.ReadInput(26);
	  break;
	case 1: operation=chk_STMsg.Handle();
	  break;
	}
      if (operation==1)                       //Moves to next textbox
       {
	 if (Field<1)
	   {
	     Field++;
	   }
	 else Field=0;
       }
      if (operation==-1)                      //Moves to previous textbox
       {
	 if (Field>0)
	   {
	     Field--;
	   }
	 else Field=1;
       }
    }
  while ((operation!=0)&&(operation!=99));
  if (operation!=99)
    {
      FFDone=1;
      int FirstMsg;
      STMsg=chk_STMsg.Status;
      if (STMsg=='\000')
	{
	  FirstMsg=0;
	}
      else FirstMsg=CurMsg+1;
      int FMessage;
      int FirstChar;
      int FindTextSize=strlen(FindText);
      int exitloop=0;
      char TestText[27];
      for (FMessage=FirstMsg; FMessage<=MsgInfo->MaxMsg; FMessage++)
	{
          int MsgSize=strlen(MsgInfo->MBase[FMessage].tpointer);
	  for(FirstChar=0; FirstChar+FindTextSize<MsgSize; FirstChar++)
	    {
              for(int i=0; i<FindTextSize; i++) TestText[i]='\0';
	      for(int j=0; j<FindTextSize; j++)
		{
		  TestText[j]=MsgInfo->MBase[FMessage].tpointer[j+FirstChar];
		}
	      TestText[FindTextSize]='\0';    
	      if (strcmp(TestText,FindText)==0)
		{
		  CurMsg=FMessage;
                  Message->msgpos=0;
		  exitloop=1;
		  break;
		}
	    }
	  if (exitloop==1) break;
	}
    }
}


/*****************************************************************************
*    Finds text again  from messages                                         *
*****************************************************************************/

void FindNext(void)                           //Finds text again from messages
{
  int FirstMsg=CurMsg+1;
  int FMessage;
  int FirstChar;
  int FindTextSize=strlen(FindText);
  int exitloop=0;
  char TestText[27];
  if (FFDone!=1)
    {
      FindFirst();
    }
  else
    {
      for (FMessage=FirstMsg; FMessage<=MsgInfo->MaxMsg; FMessage++)
	{
          int MsgSize=strlen(MsgInfo->MBase[FMessage].tpointer);
	  for(FirstChar=0; FirstChar<(MsgSize-FindTextSize); FirstChar++)
	    {
	      for(int j=0; j<FindTextSize; j++)
		{
		  TestText[j]=MsgInfo->MBase[FMessage].tpointer[j+FirstChar];
		}
	      TestText[FindTextSize]='\0';
	      if (strcmp(TestText,FindText)==0)
		{
		  CurMsg=FMessage;
		  Message->msgpos=0;
		  exitloop=1;
		  break;
		}
	    }
	  if (exitloop==1) break;
	}
    }
}


/*****************************************************************************
* Reads long boardnames                                                      *
*****************************************************************************/

void ReadBNames(char *FileName)
{
  ifstream BNames(FileName);
  if (!BNames.fail())
    {
      int j;
      unsigned int brdnro;
      int cbndx;
      unsigned char input1;
      unsigned char buffer[200];
      BNames>>brdnro;
      do
	{
	  //if (brdnro == 1309)
	  //  {
	  //    cerr<<"DEBUG\n";
	  //  };	  
	  cbndx=-1;
	  for (j=0; j<1000; j++)
	    {
	      if (BInfo->Boards[j].BrdNro==brdnro)
		{
		  cbndx=j;
		  break;
		}
	    }
	  BNames.get(input1);
	  if (input1 != ':')
	    {
	      cerr<<"\nError reading long boardnames. File \""<<FileName
		  <<"\" is propaply\ncorrupted. Ignorig long boardnames. "
		  <<"hit any key to continue\n";
	      int tmp = getch();
	      cerr<<"Ignoring accepted: "<<tmp<<'\n';
	    }

	  if (cbndx==-1)
	    {
              BInfo->MaxBoard++;
	      cbndx=BInfo->MaxBoard;
              BInfo->Boards[cbndx].BrdNro=brdnro;
	      BInfo->Boards[cbndx].BrdStatus=9;
	    }
	  else if (BInfo->Boards[cbndx].BrdName == NULL)
	    delete BInfo->Boards[cbndx].BrdName;
          j=0;
	  while ((BNames.peek()!=0x0d)&&(BNames.peek()!=0x0a)&&(j<197))
	    {
	      BNames.get(buffer[j]);
              j++;
	    }
	  buffer[j]='\0';
	  strConvert(buffer);
	  if (BNames.peek()==0x0d) BNames.get(input1);
	  if (BNames.peek()==0x0a) BNames.get(input1);
	  BInfo->Boards[cbndx].BrdName = strdup ((const char *)buffer);
	  BNames>>brdnro;
	}
      while ((!BNames.fail())&&(!BNames.eof())&&(cbndx<MaxBoardA));
    }
  BNames.close();
}  


/*****************************************************************************
*  Converts unsigned int to string                                           *
*****************************************************************************/

void uitos(unsigned int INro, char *Out)     //Converts unsigned int to string 
{
  int Digit0, Digit1, Digit2;
  char SNro[4];
  Digit0=INro/100;
  Digit1=(INro-Digit0*100)/10;
  Digit2=INro-Digit0*100-Digit1*10;
  SNro[0]=48+Digit0;
  SNro[1]=48+Digit1;
  SNro[2]=48+Digit2;
  SNro[3]='\0';
  strcpy(Out,SNro);
}


/*****************************************************************************
*  Makes message private (SysOp)                                             *
*****************************************************************************/

void MkPriv(void)
{
  PostMsg Posting;
  Posting.MakePrivate();
}



/*****************************************************************************
*  List of operations                                                        *
*****************************************************************************/

void LOper(void)
{
  OperList LO;
  LO.LisOper();
}


/*****************************************************************************
*  Removes message (SysOp)                                                   *
*****************************************************************************/

void RmMsg(void)
{
  PostMsg Posting;
  Posting.RemoveMsg();
}


/*****************************************************************************
*  Moves message (SysOp)                                                     *
*****************************************************************************/

void MvMsg(void)
{
  PostMsg Posting;
  Posting.MoveMsg();
}


/*****************************************************************************
*  Posts new  message                                                        *
*****************************************************************************/

void PostNewMsg(void)
{
  PostMsg Posting;
  Posting.NewMessage();
}


/*****************************************************************************
*  Replyes to message                                                        *
*****************************************************************************/

void ReplyMsg(void)
{
  PostMsg Posting;
  Posting.ReplyMessage();
}


/*****************************************************************************
*  Very cleaver function for stringhandling                                  *
*****************************************************************************/

void strnadd(char *addto, int addpos, char *addfrom, int addn)
{
  int startpos=0;                  //Position of 1st char to read in addfrom
  int afsize=strlen(addfrom);      //Size of addfrom
  if (afsize>addn) startpos=afsize-addn; 
  for (int j=0; j<addn; j++)
    {
      if (startpos+j<afsize)
	{
	  addto[addpos+j]=addfrom[startpos+j];
	}
      else addto[addpos+j]=' ';
    }
}


/*****************************************************************************
*  Removes session                                                           *
*****************************************************************************/

void RmSessionL(void)
{
  SesList->RmSession();
  if (SManager==1) Message->exit=1;
}


/*****************************************************************************
* Draws background (message or sessionsselection menu)                       *
*****************************************************************************/

void DrawBackGround(int x1=1, int y1=1, int x2=80, int y2=LINES-1)//Draws background
{
  if (SManager==1)                 //If you are readin messages
    {
      //Message->DrawHeader();
      //Message->DrawMessage(13);
      bout_msg->draw(x1,y1,x2,y2);
    }
  else bout_lb->draw(x1,y1,x2,y2);
    //SesList->Draw();           //If you are on sessionselectin menu

}


/*****************************************************************************
* Converts incoming strings to ISO-Latin                                     *
*****************************************************************************/

void strConvert(unsigned char *TTC)
{
  int size=strlen((const char *)TTC);
  for (int j=0; j<size; j++) TTC[j]=Convert(TTC[j]);
}


/*****************************************************************************
* Converts incoming characters to ISO-Latin                                  *
*****************************************************************************/

unsigned char Convert(unsigned char Text)
{
  //IBM to ISO-Latin
  if (Settings->IBMConv==1)
    {
      if (Text==0x84) return('');
      if (Text==0x8E) return('');
      if (Text==0x94) return('');
      if (Text==0x99) return('');
      if (Text==0x86) return('');
      if (Text==0x8F) return('');
    }
  if (Settings->SF7Conv==1)
    {
      if (Text=='{') return('');
      if (Text=='[') return('');
      if (Text=='|') return('');
      if (Text=='\\') return('');
      if (Text=='}') return('');
      if (Text==']') return('');
    }
  return(Text);
}


/*****************************************************************************
* Converts outgoing strings from ISO-Latin                                   *
*****************************************************************************/

void RPacket::OstrConvert(unsigned char *TTC)
{
  int size=strlen((const char *)TTC);
  for (int j=0; j<size; j++) TTC[j]=OConvert(TTC[j]);
}


/*****************************************************************************
* Converts outgoing characters from ISO-Latin                                *
*****************************************************************************/

unsigned char RPacket::OConvert(unsigned char Text)
{
  if (Settings->OutChars==0) return(Text); //ISO-Latin
  if (Settings->OutChars==1) //IBM8
    {
      if (Text==(unsigned char) '') return (0x84);
      if (Text==(unsigned char) '') return (0x8E);
      if (Text==(unsigned char) '') return (0x94);
      if (Text==(unsigned char) '') return (0x99);
      if (Text==(unsigned char) '') return (0x86);
      if (Text==(unsigned char) '') return (0x8F);
    }
  if (Settings->OutChars==2) //SF7
    {
      if (Text==(unsigned char) '') return('{');
      if (Text==(unsigned char) '') return('[');
      if (Text==(unsigned char) '') return('|');
      if (Text==(unsigned char) '') return('\\');
      if (Text==(unsigned char) '') return('}');
      if (Text==(unsigned char) '') return(']');
    }
  return(Text);
}


/*****************************************************************************
* Closes messagereading classes and calls ExitNow()                          *
*****************************************************************************/

void ExitMnu(void)
{
  delete Message;
  delete BInfo;
  delete MsgInfo;
  delete MenuBar;
  ExitNow();
}


/*****************************************************************************
* Closes all remainig classes and exits from program                         *
*****************************************************************************/

void ExitNow(void)
{
  delete Settings;
  ClrAttrib();
  EraseDisplay();
  echo();
  endwin();
  exit(0);
}


/*****************************************************************************
* Return to sessonselection menu from message reading screem                 *
*****************************************************************************/

void ReturnMListBox(void)
{
  Message->exit=1;
}





/*****************************************************************************
* Globas settings -dialog                                                    *
*****************************************************************************/

void setglobal(void)
{
  Settings->SetGlob();
}


/*****************************************************************************
* BBS's settings -dialog                                                     *
*****************************************************************************/

void setbbs(void)
{
  int tmp=Settings->ReadBBS(SesList->CurItem);
  if (tmp!=1)Settings->SetBBS(SesList->CurItem);
}


/*****************************************************************************
* Some useful functions                                                      *
*****************************************************************************/

void oaddstr(char Str[9], int position)     //Add to OutText.
{
  int j=0;
  for (j=position; j<=position+(int)strlen(Str)-1; j++) OutText[j]=Str[j-position];
}
  
void ClrAttrib(void)                        //Clears text attributers.
{
  cout<<(char) AnsiBegin<<"[0m";
}

void BoldText(void)                         //Bolds text
{
  cout<<(char)AnsiBegin<<"[1m";
}

void resetOT(void)                          //Clear OutText -variable.
{
  int j=0;
  for (j=0; j<80; j++) OutText[j]=' ';
  OutText[80]='\0';                         //EOS mark.
}
  
void GotoXY(int x, int y)                   //Moves cursor.
{
  refresh();
  cout<<(char)AnsiBegin<<'['<<y<<';'<<x<<'H';
  //cout<<(int)AnsiBegin<<'['<<y<<';'<<x<<'H';
  cout<<flush;
}

void EraseDisplay(void)                     //Clears screen
{
  GotoXY(0,0);
  ClrAttrib();
  cout<<(char)AnsiBegin<<"[J"<<flush;
}

void TextColor(int tfgcolor)                 //Sets text color.
{
  if (tfgcolor>=1000)
    {
      tfgcolor=tfgcolor-1000;
      //if (has_colors()==0) cout<<AnsiBegin<<"[7m";
    }
  if (tfgcolor>=100)
    {
      BoldText();
      tfgcolor=tfgcolor-100;
    }
  if (HasColors==1) cout<<(char)AnsiBegin<<"["<<tfgcolor<<"m";
}

void TextBackColor(int tbgcolor)            //Sets text backgroundcolor.
{
 if (tbgcolor>=1000)
    {
      tbgcolor=tbgcolor-1000;
      if (HasColors==0) cout<<(char)AnsiBegin<<"[7m";
    }
 if (tbgcolor>=100) tbgcolor=tbgcolor-100; 
 if (HasColors==1)
   {
     tbgcolor=tbgcolor+10;
     cout<<(char)AnsiBegin<<"["<<tbgcolor<<"m";
   }
}


/*****************************************************************************
* Class which contain all information from NEWMSGxy.TXT -file                *
*****************************************************************************/

Messages::Messages(char FileName[100])  //Constructor
{
  MsgFile.open(FileName);          //MsgFile is asigned to NEWMSGxy.TXT -file
  if (MsgFile.fail())
    {
      cerr<<"Critical ERROR: Can't open "<<FileName<<"\n";
      cerr<<"Press any key to kill LORE\n";
      getch();
      ExitNow();
    }
}

Messages::~Messages(void)          //Destructor
{
  MsgFile.close();                 //Cloase NEWMSGxy.TXT -file
  for (int j=0; j<=MaxMsg; j++)
    {
      delete MBase[j].tpointer;
    }
  MaxMsg=0;
}

int Messages::EatWhiteSpace(void)  //Reads extra spaces
{
  char input1;
  while (MsgFile.peek()==' ')
    {
      MsgFile.get(input1);
      if (MsgFile.fail()) return(-1);
    }
  return(0);
}

int Messages::ReadMsgNro(int CurMsg) //Reads messagenumber;
{
  int j;
  char input1;
  j=0;
  do                                 //Reads "#"
    {
      MsgFile.get(input1);
      j++;
    }
  while ((input1!='#')&&(j<3));      //Error chehck.
  if (j==3) return(-1);
  MsgFile>>MBase[CurMsg].MsgNum;     //Read message's number
  return(0);
}

void Messages::ReadBrdName(int CurMsg) //Read board name
{
  int j=0;
  char input1;
  char input2;
  MsgFile.get(input1);
  input2=input1;
  while ((input1!=' ')||(input2!=' ')) //Loop until two space
    {
      input2=input1;
      MBase[CurMsg].BrdName[j]=input1;
      MsgFile.get(input1);
      j++;
      if (j > 80)
	{
	  cerr<<"ERROR: too long BoardName-field. Exiting\n";
	  cerr<<"DEBUG: CurMsg="<<CurMsg<<'\n';
	  ExitNow();
	}
    }
  MBase[CurMsg].BrdName[j-1]='\0';     //Add null.
  strConvert((unsigned char *)MBase[CurMsg].BrdName);
}

void Messages::ReadMsgDate(int CurMsg) //Reads date of message.
{
  MsgFile>>MBase[CurMsg].Date;         //Reads date         
  if (MBase[CurMsg].Date[0]=='D')      //Correction, if nonstandard (Intro BBS)
    {
      int j;
      EatWhiteSpace();                 //Eats whitespace
      for (j=0; j<9; j++)          //Reads nonstandard date
	{
	  MsgFile.get(MBase[CurMsg].Date[j]);
	  if (MBase[CurMsg].Date[j]==' ')
	    {
	      MBase[CurMsg].Date[j]='-'; //Corrects nonstandard date to stan-
	    }                            //dart
	}
      MBase[CurMsg].Date[j]='\0';
    } 
  MBase[CurMsg].Date[10]='\0';           //Add null
}

void Messages::ReadMsgStatus(int CurMsg) //Reads message's status
{
  char Status[5];
  MsgFile>>Status; 
  if (strcmp(Status,"()")==0) MBase[CurMsg].Status=0x00;
  else if (strcmp(Status,"(P)")==0) MBase[CurMsg].Status=0x01;
  else if (strcmp(Status,"(R)")==0) MBase[CurMsg].Status=0x02;
  else if (strcmp(Status,"(PR)")==0) MBase[CurMsg].Status=0x03;
  else if (strcmp(Status,"(RP)")==0) MBase[CurMsg].Status=0x03;
  else
    {
      cerr<<"ERROR: unknown message-status. Exiting\n";
      cerr<<"DEBUG: CurMsg="<<CurMsg<<"  Status:"<<Status<<'\n';
      ExitNow();
    };
}

void Messages::ReadWhoFrom(int CurMsg) //Reads writers name
{
  int j=0;
  char input1;                         //Read ASCII 10 + 13 and 1st char
  MsgFile.get(input1);MsgFile.get(input1);MsgFile.get(input1);
  while ((input1!='=') && (j < 37))                 //Loop untill "="
    {
      MBase[CurMsg].From[j]=input1;
      MsgFile.get(input1);
      j++;
    }
  MBase[CurMsg].From[j-1]='\0';        //Add null
  if (input1 != '=')
    {
      cerr<<"ERROR: too long from-field. Exiting\n";
      cerr<<"DEBUG: CurMsg="<<CurMsg<<'\n';
      ExitNow();
    };
  strConvert((unsigned char *)MBase[CurMsg].From);
}

void Messages::ReadWhoTo(int CurMsg)   //Read receiver's name
{
  int j=0;
  char input1;                         //Read "> " and first char of name.
  MsgFile.get(input1);MsgFile.get(input1);MsgFile.get(input1);
  while ((input1!=0x0d) && (j <35))       //Loop until ASCII 13.
    {
      MBase[CurMsg].To[j]=input1;
      MsgFile.get(input1);
      j++;
    }
  MBase[CurMsg].To[j]='\0';            //Add null
  if (input1 != 0x0d)
    {
      cerr<<"ERROR: too long to-field. Exiting\n";
      cerr<<"DEBUG: CurMsg="<<CurMsg<<'\n';
      ExitNow();
    };
  strConvert((unsigned char *)MBase[CurMsg].To);
}

void Messages::ReadSubject(int CurMsg) //Reads subject
{
  char input1;
  char input2[7];
  MsgFile.get(input1); 
  int j = 0;
  while ((j <6) && (MsgFile.peek() != 0x02))
    {
      MsgFile.get(input1);
      input2[j] = input1;
      j++;
    }
  input2[j] = '\0';
  if (strcmp (input2, "Subj: ") != 0)
    {
      int i = strlen (input2)-1;
      while (i >= 0)
	{
	  MsgFile.putback (input2[i]);
	  i--;
	}
    }
  MsgFile.get(input1);
  j = 0;
  while (input1!=0x02)
    {
      if (j < 72) MBase[CurMsg].Subject[j]=input1;
      else
	{
	  cerr<<"\nToo long subject!\n";
	  cerr<<"CurMsg: "<<CurMsg<<"   j: "<<j<<'\n';
	  ExitNow ();
	}
      MsgFile.get(input1);
      j++;
    }
  MBase[CurMsg].Subject[j]='\0';
  strConvert((unsigned char *)MBase[CurMsg].Subject);
}

void Messages::ReadBodyText(int CurMsg)//Reads message
{
  int j=0;
  char input1;
  char msgtext[80000];
  MsgFile.get(input1);
  while ((input1!=0x03) && (!MsgFile.fail()))  //Loops until EOT mark.
    {
      if (j >79998)
	{
	  cerr<<"ERROR: too long messagebody. Exiting\n";
	  cerr<<"DEBUG: CurMsg="<<CurMsg<<'\n';
	  ExitNow();
	};
      msgtext[j]=input1;
      if (msgtext[j] == 0x00) msgtext[j]='~';   //BBS bug :(
      MsgFile.get(input1);
      j++;
    }
  msgtext[j]=0;                        //Adds null
  MBase[CurMsg].tpointer = new char[j+2]; //Allocate memory for message.
  strncpy(MBase[CurMsg].tpointer,msgtext,j);
  MBase[CurMsg].tpointer[j]=0x03;
  MBase[CurMsg].tpointer[j+1]='\0';
}

void Messages::ReadMessages(void) //Read messages from file.
{
  char input1;
  int CurMsg=0;
  MsgFile.get(input1);            //Reads 'Star Of Header' mark
  while ((input1!=0x1a)&&(CurMsg<MaxMessages)) //Loops until EOF
    {
      int err_c = 0;
      while (input1!=0x01)
	{
	  MsgFile.get(input1); //Checks SOH mark
	  err_c++;
	  if ((err_c > 4) || (MsgFile.fail()))
	    {
	      cerr<<"ERROR: Corrupted messagepacket! Press any key to exit\n";
	      cerr<<"Debug info: CurMsg="<<CurMsg<<"; SOH not found\n";
	      getch();
	      ExitNow();
	    }
	}
      err_c = ReadMsgNro(CurMsg);        //Reads messagenumber;
      if (err_c == -1)
	{
	  cerr<<"ERROR: Corrupted messagepacket! Press any key to exit\n";
	  cerr<<"Debug info: CurMsg="<<CurMsg<<"; Can't read messagenumber\n";
	  getch();
	  ExitNow();
	}
      MsgFile>>MBase[CurMsg].BrdNum; //Reads board's number
      err_c = 0;
      do                         //Reads ":"
	{
	  err_c++;
	  MsgFile.get(input1);
	  if ((err_c > 4) || (MsgFile.fail()))
	    {
	      cerr<<"ERROR: Corrupted messagepacket! Press any key to exit\n";
	      cerr<<"Debug info: CurMsg="<<CurMsg<<"; \':\' not found\n";
	      getch();
	      ExitNow();
	    }
	}
      while (input1!=':');
      ReadBrdName(CurMsg);       //Reads board's name.
      ReadMsgDate(CurMsg);       //Read creation date of message.
      MsgFile>>MBase[CurMsg].Time; //Read creation time of message.
      EatWhiteSpace();           //Eat whitespace
      if (MsgFile.peek()=='(')
	{
	  MsgFile>>MBase[CurMsg].Chain; //ReadChain;
	}
      else
	{
	   MBase[CurMsg].Chain[0]='N'; //If chain is not avaible
           MBase[CurMsg].Chain[1]='A';
           MBase[CurMsg].Chain[2]='\0';
	}
      EatWhiteSpace();           //Eat whitespace
      if (MsgFile.peek()=='(')
	{
	  ReadMsgStatus(CurMsg); //Read message status
	}
      else
	{
	  MBase[CurMsg].Status=0x00; //If status isn't avaible
	}
      ReadWhoFrom(CurMsg);       //Read writer's name
      ReadWhoTo(CurMsg);         //Read receiver's name
      ReadSubject(CurMsg);       //Read subject
      ReadBodyText(CurMsg);      //Read message.
      CurMsg++;                  //Start reading next message.
      MsgFile.get(input1);       //Read SOH/EOF mark
      if (MsgFile.fail()) break;
    }
  MaxMsg=CurMsg-1;
}


/*****************************************************************************
* Class which contain all information from SYSTEMxy.BBS -file                *
*****************************************************************************/

BBSInfo::BBSInfo(char FileName[100]) //Constructor
{
  SystemFile=new ifstream(FileName); //SystemFile is assingned to SYSTEMXY.BBS
  for (int j=0; j < MaxBoardA; j++)
    Boards[j].BrdName = NULL;
}

BBSInfo::~BBSInfo(void)            //Destructor
{
  SystemFile->close();             //Closes SYSTEMXY.BBS -file.
  for (int j=0; j<=MaxBoard; j++)
    {
      delete Boards[j].BrdName;
    }
}

void BBSInfo::ReadFile(void)       //Reads file to memory
{
  unsigned char input1;         
  ReadSysName();                   //Reads systems name. 
  MaxBoard=0;
  SystemFile->get(input1);
  while ((!SystemFile->fail())&&(MaxBoard<MaxBoardA))
  {
      if (ReadBoardInfo(MaxBoard,input1)==-1) break;
      if (SystemFile->fail())
	{
	  delete Boards[MaxBoard].BrdName;
	  break;
	}
      MaxBoard++;
      SystemFile->get(input1);
    } 
  MaxBoard--; 
} 

int BBSInfo::ReadSysName(void)     //Reads neme of BBS-system
{
  int j;
  int Size;                        //Length of System name
  char input1;
  SystemFile->get(input1);         //Read length of System name
  Size=input1;
  for (j=0; j<=39; j++)            //Read name (40 chars)
    {
      SystemFile->get(input1);
      SystemName[j]=input1;
    }
  SystemName[Size]='\0';           //Add null to end of name
  return(0);
}

int BBSInfo::ReadBoardInfo(int Nro, unsigned char linput) //Reads boards
{
  unsigned char input1;
  int j=0;
  int Size;
  char BName[80];
  unsigned char LowNro=linput;        //Board number (in BBS)
  SystemFile->get(input1);          //Status-bits
  if (SystemFile->fail()) return(-1);
  Boards[Nro].BrdStatus=input1;
  if (SystemFile->fail()) return(-1);
  unsigned char HighNro;
  SystemFile->get(HighNro);          //Unused statusbit 
  if (SystemFile->fail()) return(-1);
  Boards[Nro].BrdNro=HighNro;
  Boards[Nro].BrdNro=(Boards[Nro].BrdNro<<8);
  int temp1=LowNro;
  Boards[Nro].BrdNro=(Boards[Nro].BrdNro|temp1);
  SystemFile->get(input1);          //Length of board name
  Size=input1;
  while (j<=15)
    { 
      SystemFile->get(input1); 
      BName[j]=input1; 
      j++;
    } 
  BName[Size]='\0';
  strConvert((unsigned char *)BName);
  Boards[Nro].BrdName = strdup (BName);
  return (0);
}
