/*****************************************************************************
 * *
 * *      MODULE:     misc.hh
 * *                  -------
 * *
 * *
 * * Revision  : $Revision: 1.3 $
 * * Date(UTC) : $Date: 1998/05/25 20:16:58 $
 * * Source    : $Source: /usr/local/cvsroot/misc/utilib/misc.hh,v $
 * * Author    : $Author: jvuokko $
 * *
 * ***************************************************************************
 * *
 * *
 * *  COPYRIGHT (C) 1998 JUKKA VUOKKO <jvuokko@iki.fi>.
 * *  This file is part of utility library of Jukka Vuokko.
 * *  See file COPYING for detailed information about legal stuff.
 * *
 * ***************************************************************************
 * *
 * *      Miscellaneus utility functions.
 * *
 *****************************************************************************/
#ifndef __misc_hh__
#define __misc_hh__

#include "my_types.h"
#include "system.h"
#include "String.hh"

#ifdef DOS_PATH
#   define DIR_SEP '\\'
#else
#   define DIR_SEP '/'
#endif

#ifndef __WATCOMC__
#   define ACCESS access
#else
#   define ACCESS wc_access
#endif

typedef void error_function_t ( const char* );

void set_misc_lib_error_handler( error_function_t *);

/**
 * Change to given directory. This understands drive letters in Os/2.
 *
 * @param dir Directory
 */
int change_dir (const char *dir);

/**
 * Copy file.
 *
 * @param src Source
 * @param dest Destination
 */
bool copy_file (char *src, char *dest);

/**
 * Remove files that matches with given wildcard pattern. Note that this
 * is case sensitive under Os/2.
 *
 * @param expr Experssion (like 'foo[1234].bar')
 *
 * @return true if success.
 */
bool rm_files (String&);

bool check_matches (char*, char*);

/**
 * This function creates a unique name for temprary file. In Os/2 and DOS
 * environment variable TMP or TEMP is required.
 */
char* get_tmpname();

#ifdef __WATCOMC__
/**
 * Better access function for Watcom C/C++
 */
int wc_access (char *path, int mode);
#endif /* WATCOMC */

/**
 *  Converts path to unix- or dos-style and appends trailing
 *  '/' or '\' to end of path.
 *
 * If first character of string is '~', then character will
 * be replaced with contents of environment variable $HOME.
 */
void correct_path (String& str);

/**
 * Expands '~' in start if path if found. Original path will replaced with
 * expanded one. Be CAREFULLY!
 *
 * @return true if tilde expansion was done.
 */
bool expand_path (String&);

/**
 * Checks if given path or filename has full absolute path, i.e. path that
 * starts from root of drive, like '/home/foobar/nnn' or 'C:\foo\bar\nnn'
 *
 * @return true if path is absolute, false if path is relative
 */
bool have_full_path( const String& );

unsigned int get_le_int32 (byte_t *s);
byte_t* put_le_int32 (byte_t *s, unsigned int value);

/**
 * Executes external command using fork() and execvp() in unix systems and
 * system() in others.
 */
int _system( const char* );

/**
 * Reads block of bytes using low level read() function. This handles
 * blocks that are larger than SSIZE_MAX.
 */
int blockread( int fd, void *buf, size_t size );

#ifdef __WATCOMC__
FILE *popen( const char* cmd, const char* mode );
int pclose( FILE *fp );
#endif


#endif
