// $Id: wrapmsg.hh,v 1.1 1997/11/02 17:35:46 jvuokko Exp $

/*****************************************************************************
 * *
 * *      MODULE:     wrapmsg.hh
 * *                  ----------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Definition of class Wrap_msg. Class is used for handling
 * *      article that contains lines that are too long to fit display.
 * *
 *****************************************************************************/

#ifndef __wrapmsg__
#define __wrapmsg__

#include "mail.hh"

//**************************************************************************/
//
// CLASS: Wrap_msg
//
// DERIVED FROM: Message
//
// Message class that can wrap text around given 'bounding box'.
// Object should be use by assign original Message object to it, then
// methods wrap and unwrap can be used for manipulate contents of the
// Object.
//
//**************************************************************************/

class Wrap_msg : public Message {
public:
        Wrap_msg() : is_wrapped( false ) {}
        Wrap_msg( const Message& ); // not implemented
        Wrap_msg( const Wrap_msg&); // not implemented
        ~Wrap_msg() {}
        
        const Wrap_msg& operator = (Message&); // this is the only way to
        // set up Wrap_msg object.
        
        const Wrap_msg& operator = (Wrap_msg&); // not implemented
        
        void wrap( int width ); // wrap contents of article
        void unwrap( void );    // unwrap.
        bool wrapped( void ) { return is_wrapped; }
        
private:
        bool is_wrapped;
        List<String> original_lines;
};

#endif
