// $Id: userselect.cc,v 1.3 1997/11/28 20:26:59 jvuokko Exp $
/*
 * This file is in the public domain.
 * author: krid@comnets.rwth-aachen.de
 * revised by: jvuokko
 */

#include "userselect.hh"
#include "linereader.hh"

extern Terminal_screen Screen;
extern settings_t      Settings;


Userselection::Userselection()
{
        win = Screen.newwin(0, 0, Screen.get_xmax()+1, Screen.get_ymax(),
                            WIN_SLINE | WIN_TITLEBAR);
        win->set_sline_text("* Available addresses *");
        if (Screen.is_color_term() == true ) {
                win->set_border_colors(Settings.sline_color,
                                       Settings.slineback_color);
        } else {
                win->set_border_colors(INVERSE, INVERSE);
        }
        win->disable();
    
        Linereader l( Settings.jmrdir + "mailrc");
        String tmp;
        for (;;) {
                tmp = l.read_line();
                if (tmp.length() > 0 ) {
                        itemlist.add( new String( tmp ) );
                        DEBUG("Added user: " << tmp );
                } else {
                        break;
                }
        }
}


Userselection::~Userselection()
{
    Screen.endwin(win);
}

String Userselection::select()
{
        String result;
        bool quit    = false;
        ymin         = 0;
        ymax         = win->get_ymax();
        current_item = 0;
        pagesize     = ymax - ymin + 1;
        maxitem      = itemlist.count_items();
        pages        = 1+ (maxitem / pagesize);
        --maxitem;
    
        current_page  = current_item / pagesize;
        first_of_page = current_page * pagesize;
        ypos = ymin + (current_item - first_of_page);

        if( itemlist.first() == false) {
                iline.set( "Addressbook is empty or it does not exist!",
                           ERROR_FL );
                iline.show();
                Screen.refresh();
                return result;
        }
        
        win->enable();
        iline.set_default("@ENTER@=select [@n@]ext [@p@]rev [@q@]uit" ); 
        iline.show_default();
    
        win->clear();
        draw_page();
        do {
                int c = Screen.get_ch();
                iline.reset();
                switch( c ) {
                case PAGE_UP_CMD:
                case CODE_PPAGE:
                        if ( false == ppage() ) {
                                iline.set( AT_FIRST_PAGE_MSG );
                        }
                        break;
                case PAGE_DOWN_CMD:
                case CODE_NPAGE:
                        if( false == npage() ) {
                                iline.set( AT_LAST_PAGE_MSG );
                        }
                        break;
                case CODE_HOME:
                        first();
                        break;
                case CODE_END:
                        last();
                        break;
                case NEXT_CMD:
                case CODE_DOWN:
                        if( false == down() ) {
                                iline.set( AT_BOTTOM_MSG );
                        }
                        break;
                case PREV_CMD:
                case CODE_UP:
                        if( false == up() ) {
                                iline.set( AT_TOP_MSG );
                        }
                        break;
                case FORCED_QUIT_CMD:
#ifndef NO_EXCEPTIONS
                        throw quit_exception();
#else
                        Quit_flag = true;
                        // no break here!!!
#endif
                case QUIT_CMD:
                        quit = true;
                        break;
                case SELECT_CMD:
                        result = *(itemlist.get());
                        quit = true;
                        break;
                default:
                        iline.set( INVALID_COMMAND_MSG );
                        break;
                }
                iline.show();
        } while ( quit == false );
    
        win->disable();
        return result;
}

void Userselection::draw_item(int flag)
{
    String tmp;
    String *user = itemlist.get();
    win->reset_attr();
    if (flag & EMPHASIZED_FL) {
	win->inverse();
    }
    
    win->clr_line();
    
    win->goto_x (10);
    if (!(flag & EMPHASIZED_FL)) {
	win->textcolor (Settings.subject_color);
    }
    win->addstr( *user );
    win->reset_attr();
}


