/* $Id: tree.hh,v 1.3 1998/04/30 16:30:09 jvuokko Exp $ */
/*****************************************************************************
 * *
 * *      MODULE:     tree.hh
 * *                  -------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Classes for handling different trees.
 * *
 *****************************************************************************/


#ifndef TREE_HH
#define TREE_HH

#include "../utilib/my_types.h"
#include "constants.h"
#include "../utilib/String.hh"
#include "../utilib/List.hh"

//**************************************************************************/
//
// CLASS: key_tree
//
// Simple 'trie' type tree for checking syntax of resources and stroring
// values of defined resources.
// 
//
//**************************************************************************/
class key_tree {
public:
        key_tree(){};
        ~key_tree() {};
        int init (const char**);
        bool goto_keyword( String& );
        bool set_value( String& );
        String& get_value( const char* );
private:
        struct node {
                List<String> values;
                String key;
                String rc_value;
        };
        List< node > tree;
};


class menu_trie {
public:
        menu_trie(){}
        ~menu_trie(){}
        void destroy();
        void add_menu(const String&, const int);
        void add_item(const String&, const int);
        bool first_menu();
        bool next_menu();
        bool prev_menu();
        bool first_item();
        bool next_item();
        bool prev_item();
        const String& get_menu();
        const String& get_item();
        int get_command();
        int get_maxlen();
private:
        struct node {
                String item;
                int command;
        };
        struct trienode {
                List<node> items;
                String menu;
                int command;
                int maxlen;
        };
        List<trienode> trie;
};
#endif




