// $Id: ring.hh,v 1.3 1998/04/30 16:30:09 jvuokko Exp $

#ifndef __rengas__
#define __rengas__

#include "../utilib/my_types.h"

// Nm eivt vapauta pointteri-muisteja, jos kytetn pointtereiden
// talletukseen!
template < class T >
class Ring {
public:
        Ring() : size(0) {}
        virtual ~Ring();
        virtual bool add( const T& data );
        bool next() { if (!size) return false; ring=ring->next; return true; }
        bool prev() { if (!size) return false; ring=ring->prev; return true; }
        bool operator ++() { return next(); }
        bool operator --() { return prev(); }
        void clear() { this->~Ring(); }
        const T& get() const { return ring->elem; }
        int get_size() const { return size; }
        bool check() const { return size ? true : false; }
protected:
        int size;
        struct ringnode {
                T elem;
                ringnode *next;
                ringnode *prev;
                ringnode ( T data=0 ) : elem( data ) {}
        };
        ringnode *ring;
        ringnode *first;
        ringnode *last;
};


template <class T > class NRing : public Ring<T> {
public:
        NRing( int max=10) : maxsize( max ) {}
        ~NRing() {}
        bool add( const T& data );
private:
        int maxsize;
};

// lis uuden loppuun, ja siirt postion tmn kohdalle.
template <class T> bool
Ring< T >::add( const T& data )
{
        if (!size) {
                ring = new ringnode( data );
                ring->next = ring->prev = ring;
                last = first = ring;
        } else {
                ringnode* tmp = new ringnode( data );
                tmp->next = first;
                tmp->prev = last;
                last->next = tmp;
                first->prev = tmp;
                last = ring = tmp;
        }
        ++size;
        return true;
}

template <class T>
Ring< T >::~Ring()
{
        DEBUG("Removing ring. Size: " << size );
        if (!size) {
                return;
        }
        
        while( size > 1 ) {
                ringnode* tmp = ring->next;
                DEBUG("Removing : " << ring->elem );
                delete ring;
                --size;
                ring = tmp;
        }
        DEBUG("Removing : " << ring->elem );
        delete ring;
        DEBUG("Last removed! -- Ring is empty");
        size = 0;
}

template <class T> bool
NRing< T >::add( const T& data )
{
        if (size < maxsize) {
                return this->Ring<T>::add( data );
        } else {
                ring = ring->next;
                ring->elem = data;
                return true;
        }
}


#endif 
