// $Id: menubar.hh,v 1.2 1998/04/30 16:30:08 jvuokko Exp $
/*****************************************************************************
 * *
 * *      MODULE:     menubar.hh
 * *                  ----------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Class for handling simple pull-down menu.
 * *
 *****************************************************************************/


#ifndef __MENUBAR_HH
#define __MENUBAR_HH

#include "../utilib/my_types.h"
#include "constants.h"
#include "tree.hh"
#include "terminal_io.hh"


struct menuinfo {
        const char* item;
        int cmd;
};

class Menubar {
public:
        Menubar() {};
        ~Menubar(){};
        void init( const menuinfo* );
        void set_text( const char* str) { text = str; }
        void show ();
        int select();
private:
        void set_active_color();
        void set_passive_color();
        void draw_menu_item( int flag = DEFAULT_FL );
        int xmax, ymax;
        int x, y;
        menu_trie menu;
        String text;
        

};

#endif
