// Module id:
// $Id: menubar.cc,v 1.5 1997/07/17 15:30:09 jvuokko Exp $
/*****************************************************************************
 * *
 * *      MODULE:     menubar.cc
 * *                  ----------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Methods for handling simple pull-down menu.
 * *
 *****************************************************************************/



#include "datatypes.hh"
#include "jmr.hh"
#include "menubar.hh"


/************************ GLOBAL VARIABLES ***********************************/

extern Terminal_screen Screen;
extern settings_t Settings;


//**************************************************************************/
// CLASS: Menubar
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Menubar::init( const menuinfo* array )
{
        menu.destroy();

        int i = 0;
        String tmp;
        // loop until item "@END" is reached
        while (strcmp( array[i].item, "@END") != 0) {
                tmp = array[i].item;
                menu.add_menu( tmp, array[i].cmd );
                ++i;
                while (strcmp( array[i].item, "@NEXT" ) != 0) {
                        tmp =  array[i].item ;
                        menu.add_item( tmp, array[i].cmd );
                        ++i;
                }
                ++i;
        }
        text = "";
        xmax = Screen.get_xmax();
        ymax = Screen.get_ymax();
        x = 0;
        y = 0;
}

//**************************************************************************/
// CLASS: Menubar
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Menubar::show ()
{
        Screen.reset_attr();
        if (Screen.is_color_term() == true) {
                Screen.textcolor( Settings.menu_color,
                                  Settings.menuback_color );
        } else {
                Screen.textcolor( INVERSE );
        }
        Screen.gotoxy( 0, 0 );
        Screen.addstr( text );
        Screen.clr_eol();
        Screen.reset_attr();
}


//**************************************************************************/
// CLASS: Menubar
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
int
Menubar::select()
{
        int c;
        int cmd(0);

  refresh_all:
        bool quit = false;
        Screen.gotoxy( 0,0 );
        set_passive_color();

        Screen.empty_line();
        menu.first_menu();
        assert( menu.first_menu() == true );
        do {
                Screen.addstr ( menu.get_menu() );
                Screen.addch (' ');
        } while (menu.next_menu() == true);

        menu.first_menu();
        x = 0;
        if (menu.first_item() == true) {
                y = 1;
        } else {
                y = 0;
        }
        do {
                draw_menu_item( EMPHASIZED_FL );
                c = Screen.get_ch();  
                switch (c) {
                case CODE_CTRL_L:
                        goto refresh_all;
                case QUIT_CMD:
                        cmd = QUIT_CMD;
                        quit = true;
                        break;
                case ESCAPE:
                        cmd = 0;
                        quit = true;
                        break;
                case FORCED_QUIT_CMD:
#ifndef NO_EXCEPTIONS
                        throw quit_exception();
#else
                        cmd = FORCED_QUIT_CMD;
                        quit = true;
                        Quit_flag = true;
                        break;
#endif
                case CODE_RIGHT:
                        draw_menu_item();
                        if (true == menu.next_menu()) {
                                ++x;
                                if (true == menu.first_item()) {
                                        y = 1;
                                } else {
                                        y = 0;
                                }
                        }
                        draw_menu_item( EMPHASIZED_FL );
                        break;
                case CODE_LEFT:
                        draw_menu_item();
                        if (true == menu.prev_menu()) {
                                --x;
                                if (true == menu.first_item()) {
                                        y = 1;
                                } else {
                                        y = 0;
                                }
                        }
                        draw_menu_item( EMPHASIZED_FL );
                        break;
                case CODE_DOWN:
                        draw_menu_item();
                        if (true == menu.next_item()) {
                                ++y;
                        }
                        draw_menu_item( EMPHASIZED_FL );
                        break;
                case CODE_UP:
                        draw_menu_item();
                        if (true == menu.prev_item()) {
                                --y;
                        }
                        draw_menu_item( EMPHASIZED_FL );
                        break;
                case SELECT_CMD:
                        cmd = menu.get_command();
                        quit = true;
                        break;
                           
                };
        } while (false == quit);
                
        Screen.reset_attr();
        return cmd;
}

//**************************************************************************/
// CLASS: Menubar
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Menubar::set_active_color()
{
        Screen.reset_attr();
        if (Screen.is_color_term() == true ) {
                Screen.textcolor (Settings.menuback_color,
                                  Settings.menu_color );
        } else {
                Screen.textcolor (BOLD);
        }
}

//**************************************************************************/
// CLASS: Menubar
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Menubar::set_passive_color()
{
        Screen.reset_attr();
        if (Screen.is_color_term() == true) {
                Screen.textcolor ( Settings.menu_color );
                Screen.back_color( Settings.menuback_color );
        } else {
                Screen.inverse();
        }
}

//**************************************************************************/
// CLASS: Menubar
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Menubar::draw_menu_item( int flag )
{
        Screen.reset_attr();
        int pos;

        if (flag & EMPHASIZED_FL ) {
                set_active_color();
        } else {
                for (pos = 1; pos < 4; pos++) {
                        Screen.gotoxy( 0, pos );
                        Screen.empty_line();
                }
                set_passive_color();
        }
        
        pos = x;
        int xcoord = 0;
        
        menu.first_menu();
        while (pos) {
                xcoord += menu.get_menu().length();
                ++xcoord;
                --pos;
                menu.next_menu();
        }

        Screen.gotoxy( xcoord, 0 );
        Screen.addstr( menu.get_menu() );

        if (flag & EMPHASIZED_FL ) {
                pos = 1;
                if (true == menu.first_item()) {
                        int len;
                        do {
                                Screen.gotoxy( xcoord, pos );
                                len = menu.get_maxlen();
                                if (pos == y) {
                                        set_active_color();
                                        Screen.addch( '>' );
                                } else {
                                        set_passive_color();
                                        Screen.addch( ' ' );
                                }
                                Screen.addstr( menu.get_item() );
                                len -= menu.get_item().length();
                                while (len > 0 ) {
                                        Screen.addch(' ');
                                        --len;
                                }
                                ++pos;
                        } while (menu.next_item() == true );
                }
                menu.first_item();
                for (pos = 1; pos < y; pos++ ) {
                        menu.next_item();
                }
        }
}










