
#include "../utilib/my_types.h"
#include "linereader.hh"
#include "../utilib/String.hh"
#include "../utilib/List.hh"

Linereader::Linereader( const String &fname )
{
        fin.open( fname.c_str(), ios::in );
        failed = false;
        if (fin.fail()) {
                failed = true;
        }
        DEBUG(" ==== Linereader initialized" );
}

Linereader::~Linereader()
{
        fin.close();
        DEBUG(" ==== Linereader destroyed");
}

String
Linereader::read_line()
{
        char tmp[MAX_LINE_LEN];
        String line;
        if (true == failed) {
                DEBUG(" Linereader: read_line failed! ");
                return line;
        }
        DEBUG( "Linereader: Reading one line from file" );
        fin.getline( tmp, MAX_LINE_LEN );
        if ( fin.fail() ) {
                failed = true;
        }
        line = tmp;
        return line;
}

List<String>*
Linereader::read_all_lines()
{
        List<String> *lines = new List<String>;
        
        String tmp;
        DEBUG( "Linereader: Reading contents of file" );
        for (;;) {
                tmp = read_line();
                if ( tmp.length() > 0 ) {
                        lines->add( new String( tmp ) );
                } else {
                        break;
                }
        }
        
        return lines;
}
