// $Id: groupselect.cc,v 1.4 1997/11/17 17:16:59 jvuokko Exp $

/*****************************************************************************
 * *
 * *      MODULE:     groupselect.cc
 * *                  --------------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      This module contains functions for selecting group from
 * *      list of all groups.
 * *
 *****************************************************************************/


#include "groupselect.hh"
#include "mail.hh"

extern Terminal_screen Screen;
extern Mail *mail;
extern settings_t Settings;

Groupselection::Groupselection()
{
        grpnode *gnode;
        int     savegrp;
        win = Screen.newwin( 0, 0, Screen.get_xmax()+1, Screen.get_ymax(),
                             WIN_SLINE | WIN_TITLEBAR);
        win->set_sline_text("* Available groups *");
        if (Screen.is_color_term() == true ) {
                win->set_border_colors( Settings.sline_color,
                                        Settings.slineback_color);
        } else {
                win->set_border_colors( INVERSE, INVERSE );
        }
        win->disable();
        savegrp = mail->get_group_number();
        mail->first_group();

        do {
                if (mail->get_group_number() >= BASEGROUP_NUMBER) {
                        continue;
                }
                gnode = new grpnode;
                gnode->number = mail->get_group_number();
                gnode->name   = mail->get_group_name();
                itemlist.add( gnode );
                DEBUG("Added to grouplist: " << gnode->name );
        } while (mail->next_group() == true );

        mail->go_group_number( savegrp );
}

Groupselection::~Groupselection()
{
        Screen.endwin( win );
}

grpnode
Groupselection::select()
{
        bool quit = false;
        grpnode selected;
        selected.number = mail->get_group_number();
        selected.name   = mail->get_group_name();
        int savedgrp = selected.number;
        ymin = 0;
        ymax = win->get_ymax();
        current_item = 0;
        pagesize = ymax - ymin + 1;
        maxitem = itemlist.count_items();
        pages = 1+ (maxitem / pagesize);
        --maxitem;

        // go to current group
        itemlist.first();
        do {
                if ( itemlist.get()->number == selected.number ) {
                        break;
                }
        } while( itemlist.next() == true && ++current_item );

        current_page = current_item / pagesize;
        first_of_page = current_page * pagesize;
        ypos = ymin + (current_item - first_of_page );

        win->enable();
        iline.set_default("@ENTER@=select [@n@]ext [@p@]rev [@q@]uit" ); 
        iline.show_default();

        win->clear();
        draw_page();
        do {
                int c = Screen.get_ch();
                iline.reset();
                switch( c ) {
                case PAGE_UP_CMD:
                case CODE_PPAGE:
                        if ( false == ppage() ) {
                                iline.set( AT_FIRST_PAGE_MSG );
                        }
                        break;
                case PAGE_DOWN_CMD:
                case CODE_NPAGE:
                        if( false == npage() ) {
                                iline.set( AT_LAST_PAGE_MSG );
                        }
                        break;
                case CODE_HOME:
                        first();
                        break;
                case CODE_END:
                        last();
                        break;
                case NEXT_CMD:
                case CODE_DOWN:
                        if( false == down() ) {
                                iline.set( AT_BOTTOM_MSG );
                        }
                        break;
                case PREV_CMD:
                case CODE_UP:
                        if( false == up() ) {
                                iline.set( AT_TOP_MSG );
                        }
                        break;
                case FORCED_QUIT_CMD:
#ifndef NO_EXCEPTIONS
                        throw quit_exception();
#else
                        Quit_flag = true;
                        // no break here!!!
#endif
                case QUIT_CMD:
                        quit = true;
                        break;
                case SELECT_CMD:
                        selected = *itemlist.get();
                        quit = true;
                        break;
                default:
                        iline.set( INVALID_COMMAND_MSG );
                        break;
                }
                iline.show();
        } while ( quit == false );

        mail->go_group_number( savedgrp );
        win->disable();
        return selected;
}


void
Groupselection::draw_item( int flag )
{
        String tmp;
        grpnode *grp = itemlist.get();
        win->reset_attr();
        if (flag & EMPHASIZED_FL) {
                win->inverse();
        }
        
        win->clr_line();
        
        win->goto_x (1);
        win->print( "%.3d", current_item );
        
        win->goto_x (10);
        win->print( "Group no: %d", grp->number );
        
        win->goto_x (28);
        if (!(flag & EMPHASIZED_FL)) {
                win->textcolor (Settings.subject_color);
        }
        win->addstr( grp->name.c_str() );
        
        win->reset_attr();

}



