/* $Id: filelist.hh,v 1.8 1998/07/18 19:49:18 jvuokko Exp $ */
/****************************************************************************
 * *
 * *  MODULE : filelist.hh
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * *
 * *    Class for handling mail files.
 * *
 * *
 * *
 * *
 ***************************************************************************/

#ifndef __FILELIST_HPP__
#define __FILELIST_HPP__
#include "../utilib/List.hh"
#include "../utilib/String.hh"
#include "terminal_io.hh"
#include "mail.hh"
#include "menubar.hh"

class Filelist {
public:
        Filelist();
        ~Filelist() {open_new = false; pattern = 0;};
        Mail* open_file(const String& bbsid = "");
        
private:
        void read_files (const String& path);
        bool search_matches();
        int select();
        void display();
        void draw_current();
        void next();
        void prev();
        void page_down();
        void page_up();
        void display_header();

        Infoline iline;
        Sline sline;
        Menubar menubar;
        List<String> filelist;
        int ymin;
        int ymax;
        int ypos;
        int first;
        int current;
        int lines;
        bool open_new;
        String pattern;
        String dashline;

};









#endif
