/* $Id: datatypes.hh,v 1.12 1998/07/18 19:48:00 jvuokko Exp $ */

/*****************************************************************************
 * *
 * *      MODULE:     datatypes.hh
 * *                  ------------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      This module defines some common datatypes of jmr.
 * *
 *****************************************************************************/

#ifndef __DATATYPES_HH__
#define __DATATYPES_HH__

#include "../utilib/String.hh"
#include "../utilib/my_types.h"
#include "constants.h"

//-------------------------------------------------------------------------
// Struct for store settings readed from rc-file.
typedef struct _settings_t {
        String system;        // [Linux] or [i586/Linux] ...
        String tag;           // tag "* jmr x.x.x.x [foo/bar] *"
        String version_str;   // jmr x.x.x.x [foo/bar]  
        String username;      // name of the user (from QWK-packet)
        String ptagline;      // permanent tagline from rc-file
        String tagline;       // tagline from rc-file.
        String full_sysname;  
        String editor;        // editor
        String unzipcmd;      // command for unpack QWK-packet
        String zipcmd;        // command for pack replies
        String replypath;     // path to replypacket
        String qwkpath;       // path to qwk-packets
        String datadir;       // directory where jmr stores logs etc.
        String workdir;       // directory for working files
        String jmrdir;        // root-directry of jmr.
        String extractdir;    // direcotry, where saved articles goes
        String quoteprefix;   // prefix inserted quoted article
        String searchpattern; // use this pattern for getting list of qwk-files
        String followup;      // format string for followup
        String reply;         // format string for reply
        String date_fmt;      // format string for date
        String default_receiver; // Default value for receiver of message
        String default_folder;   // Default name for folder to save articles
        String tagliner;      // command for external tagliner (like fortune)
        String signaturefile; // path to signaturefile
        bool   rmoldpacket;   // Should jmr remove qwk packet when done ?
        int    bbscharset;    // character set of bbs
        int    syscharset;    // character set of system
        int    replylogsize;  // maximum size of replylog
        int    databasesize;  // maximum size of message database
        int    max_bbs_subject_len;  // max. length of subject in bbs
        int    max_subject_len;      // max. lenght of subject in jmr
        int    quote_color;    // color used for highlighting quotes
        int    article_color;     // color for normal text
        int    menu_color;
        int    menuback_color;
        int    sline_color;
        int    slineback_color;
        int    dash_color;
        int    dashback_color;
        int    subject_color;
        int    author_color;
        int    iline_color;
        int    iline_err_color;
        int    basegroup_color;
        int    header_subject_color;
        int    header_author_color;
        int    personal_color;
        bool   confirm_return; // true if question is asked when return to db
        bool   is_pcboard;    // true if QWK-packet is from pcboard
        bool   is_wrapmode;   // true if wrap mode is set on
        char   currentdir[MAXPATH+1]; // current directory
        char   wrap_indicator; // character that is used for indicate that
#ifdef F_TO_ALL
        String   followupto;	// "all", "writer", "Jukka Vuokko", "Yrj Hatakka", etc ...
#endif
           // line is wrapped.
} settings_t;


#ifndef NO_EXCEPTIONS
class quit_exception { };
#endif

#endif /* __DATATYPES_HH__ */
