#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "doorutil.h"

struct question {
	char *question;
	int numanswers;
	char **answers;
};

struct _vote_rec {
	char name[uidlen];
	int vote;
};

struct question **question_list;
int numquestions=0;

char dpath[64];

int main(int argc, char *argv[]);
void read_questions(void);
void main_loop(void);
void vote_question(int qnum);
void view_results(void);

int main(int argc, char *argv[])
{
	FILE *f;
	int ctr, flag=0;
	struct _vote_rec vote_rec;
	char fname[64];
	char voteyn[3];

	init();
	strcpy(user[who].doors_id, "Falken Voting Booth");
	strcpy(dpath, argv[1]);
	read_questions();
	if (argc == 3) 
	{
		qprintf("\rChecking for new questions in the voting booth...");
		for (ctr=0; ctr < numquestions; ctr++)
		{
			sprintf(fname, "%s/q%d.dat", dpath, ctr);
			if ((f = fopen(fname, "r")) != 0)
			{
				flag=0;
				while (fread(&vote_rec, sizeof(vote_rec), 1, f))
				{
					if (strcasecmp(vote_rec.name, acnt[who].acctname) == 0)
					{
						flag=1;
						break;
					}
				}
				if (flag==0)
				{
					flag=2;
					fclose(f);
					break;
				}
				fclose(f);
			} else {
				flag = 2;
				break;
			}
		}
		if (flag==2)
		{
			qprintf("\rThere are new questions in the voting booth.\rWould you like to vote (y/N):");
			qgets(voteyn, 2);
			if (toupper(voteyn[0]) == 'Y')
			{
				main_loop();
			}
		} else {
			qprintf("none\r");
		}
	} else {
		main_loop();
	}
	return(0);
}

void read_questions(void)
{
	FILE *f;
	char fname[64];
	char buffer[10240];
	int ctr, ctr2;
	int qb;
	
	sprintf(fname, "%s/vbooth.cfg", dpath);
	if ((f = fopen(fname, "r")) == 0)
	{
		send_lprintf("Couldn't open the voting booth Config");
		exit(0);
	} else {
		while (!feof(f))
		{
			fgets(buffer, 10239, f);
			if (buffer[0] == '-')
				numquestions++;
		}
		numquestions--;
		fseek(f, 0, SEEK_SET);
		if ((question_list = malloc(numquestions * sizeof(int))) == NULL)
			qprintf("Error Allocating question_list\r");
		for (ctr = 0; ctr < numquestions; ctr++)
			if ((question_list[ctr] = malloc(sizeof(struct question))) == NULL)
				qprintf("Error Allocating memory for question %d\r", ctr);
		for (ctr = 0; ctr < numquestions; ctr++)
		{
			fgets(buffer, 10239, f);
			question_list[ctr]->question = malloc(strlen(buffer)+1);
			strcpy(question_list[ctr]->question, buffer);
			qb = ftell(f);
			question_list[ctr]->numanswers=0;
			while (buffer[0] != '-')
			{
				fgets(buffer, 10239, f);
				if (buffer[0] != '-')
					question_list[ctr]->numanswers++;
			}
			question_list[ctr]->answers = malloc((size_t)(question_list[ctr]->numanswers * sizeof(int)));
			fseek(f, qb, SEEK_SET);
			for (ctr2=0; ctr2 < question_list[ctr]->numanswers; ctr2++)
			{
				fgets(buffer, 10239, f);
				question_list[ctr]->answers[ctr2] = malloc(strlen(buffer)+1);
				strcpy(question_list[ctr]->answers[ctr2], buffer);
			}
			fgets(buffer, 10239, f);
		}
	}
}

void main_loop(void)
{
	char qnum[4];
	int ctr;

	while (1)
	{
		qprintf("[1;1H[2JFalken Voting Booth version 1.0\r\r");
		qprintf("[1;31mQuestions available to be voted on:\r");
		for (ctr = 0; ctr < numquestions; ctr++)
			qprintf(" [1;33m%d[0m: [0m%s[0m\r", ctr+1, question_list[ctr]->question);
		qprintf("\r [1;33mV[0m: View Results\r");
		qprintf(" [1;33mQ[0m: Quit\r\r");
		qprintf("[1;31mChoose a question to vote on: [0m");
		qgets(qnum, 3);
		if (toupper(qnum[0]) == 'Q')
		 return;	
		if (toupper(qnum[0]) == 'V')
			view_results();
		else
			vote_question(atoi(qnum)-1);
	}
}

void vote_question(int qnum)
{
	int ctr, numvotes; 
	struct _vote_rec vote_rec;
	int position=0, ans, flag;
	char answer[4];
	char fname[64];
	FILE *f;

	if ((qnum >= 0) && (qnum < numquestions))
	{
		sprintf(fname, "%s/q%d.dat", dpath, qnum);
		if ((f = fopen(fname, "r")) == 0)
		{
			if ((f = fopen(fname, "w+")) == 0)
			{
				qprintf("Error opening Question Datafile\r");
				exit(0);
			} else {
				qprintf("Created Question Datafile\r");
				flag=0;
			}
		} else {
			numvotes = file_size(fname) / sizeof(vote_rec);
			flag=0;
			while (fread(&vote_rec, sizeof(vote_rec), 1, f))
			{
				position = ftell(f) - sizeof(vote_rec);
				if (strcasecmp(vote_rec.name, acnt[who].acctname) == 0)
				{
					flag=1;
					break;
				}
			}
			fclose(f);
		}
		if (flag == 0)
		{
			position=file_size(fname);
			strcpy(vote_rec.name, acnt[who].acctname);
			vote_rec.vote = 0;
		}
		qprintf("[1;1H[2J Question #%d\r\r", qnum+1);
		qprintf(" [1;31m%s\r", question_list[qnum]->question);
		for (ctr=0; ctr < question_list[qnum]->numanswers; ctr++)
			qprintf(" [1;35m%c[1;33m%d[0m: %s\r", (vote_rec.vote == ctr+1) ? '*' : ' ', ctr+1, question_list[qnum]->answers[ctr]);
		if (vote_rec.vote == 0)
			qprintf("\rYou haven't voted on this question yet.");
		else
			qprintf("\r [1;35m* [1;31m= Current Vote");
		qprintf("\rYour Vote: [0m");
		qgets(answer, 3);
		ans = atoi(answer);
		if ((ans > 0) && (ans <= question_list[qnum]->numanswers))
		{
			vote_rec.vote = ans;
			if ((f = fopen(fname, "r+")) != 0)
			{
				fseek(f, position, SEEK_SET);
				ans = fwrite(&vote_rec, sizeof(vote_rec), 1, f);
				fclose(f);
			} else {
				qprintf("Couldn't open datafile\r");
				sleep(2);
			}
		} else {
			qprintf("That is not a valid answer\r");
			sleep(2);
		}
		return;
	} else {
		qprintf("That is not a valid question number\r");
		qprintf("Please enter a number between 1 and %d\r", numquestions);
		sleep(3);
		return;
	}
}

void view_results(void)
{
	FILE *f;
	char fname[64];
	int numvotes;
	int ctr, loop;
	int tally[400];
	struct _vote_rec vote_rec;
	
	for (ctr=0; ctr < numquestions; ctr++)
	{
		sprintf(fname, "%s/q%d.dat", dpath, ctr);
		numvotes = file_size(fname) / sizeof(vote_rec);
		if ((f = fopen(fname, "r")) == 0)
			qprintf("[1;1H[2J[1;31mQuestion #%d:  [0m%s\rNo one has voted :(\r", ctr+1, question_list[ctr]->question);
		else {
			for (loop = 0; loop < question_list[ctr]->numanswers; loop++)
				tally[loop] = 0;
			while (fread(&vote_rec, sizeof(vote_rec), 1, f))
				tally[vote_rec.vote-1]++;
			fclose(f);
			qprintf("[1;1H[2J[1;31mQuestion #%d:  [0m%s\r\r%d votes[0m\r\r", ctr+1, question_list[ctr]->question, numvotes);
			for (loop = 0; loop < question_list[ctr]->numanswers; loop++)
				if (tally[loop] == numvotes)
					qprintf(" [1;33m100.00%%[0m - %s\r", loop+1, question_list[ctr]->answers[loop]);
				else 
					qprintf("   [1;33m%-2.2f%%[0m - %s\r", (float)tally[loop] / (float)numvotes * 100.0, question_list[ctr]->answers[loop]);
		}
		qprintf("\rPress [ENTER] to continue");
		qgets(fname, 1);
	}
}
