#ifndef DOORUTIL_H
#define DOORUTIL_H

#include <stdio.h>

#define ECHO_ON 1
#define ECHO_OFF 2
#define ECHO_DOTS 3

#include "falken.h"

extern struct shared_mem_structure *shm;
extern int doorutil_debug;
extern int semid;
extern int inq, outq, who, numlines;
extern struct acct_rec *acnt;
extern struct user_rec *user;
extern struct cfg_rec *cfg;
extern struct acct_rec *myacct;
extern struct user_rec *myuser;
extern void delay(int);
extern void relinq(void);
extern int init(void);
extern void logoff(int);
extern void setbinarymode(int);
extern void settextmode(int);
extern void clear_input_buffer(int);
extern void clear_output_buffer(int);
extern void get_port(int port);
extern void return_port(int port);
extern int get_oba(void);
extern int get_in_cnt(void);
extern int bbslog(char *fs);
extern int qprintf(char *fs,...);
extern int qnprintf(int n,char *fs,...);
extern void broadcast(char *fs, int *linenums);
extern void sendmsg(int who, char *);
extern void getmsg(int ansiflag, char *, char *fs);
extern int qgets(char *s, int len);
extern int tqgets(char *s, int len, int timeout);
extern int getserialnum(char *s);
extern int getversion(char *s);
extern void btupag(int lines);
extern void setwatchdog(int line, int value);
extern void btuech(int echoval);
extern int find_account(char *s1, void *mem);
extern int start_a_door(char *);
extern void wait_for_door();
extern int load_a_door(char *);
extern void save_acct(void);
extern int sendtoq(char *, int);
extern void sendraw(int, unsigned char *, int);
extern FILE *f_open(char *, char *, int, int *);
extern unsigned long file_size(char *);
extern void send_lprintf(char *, ...);
extern char one_key(char *keys, char *prompt, char *);
extern int send_email(struct email_record *, char *);
#endif

