
#define CTRL(x)   ((x) & 0x1f)
#define TICKER_DELAY 2
#define dialog_yn(nlines, ncols, beginy, beginx, title, text) dialog_yesno(nlines, ncols, beginy, beginx, title, text, 1)
#define dialog_ny(nlines, ncols, beginy, beginx, title, text) dialog_yesno(nlines, ncols, beginy, beginx, title, text, 0)

struct proc_s {
	char
		user[10],								/* user name corresponding to owner of process */
		cmd[40],								/* basename of executable file in call to exec(2) */
		state,									/* single-char code for process state (S=sleeping) */
		ttyc[5],								/* string representation of controlling tty device */
		**environ,							/* environment string vector (/proc/#/environ) */
		**cmdline;							/* command line string vector (/proc/#/cmdline) */
	int
		uid,										/* user id */
		euid,										/* user id */
		pid,										/* process id */
		ppid,										/* pid of parent process */
		pgrp,										/* process group id */
		session,								/* session id */
		tty,										/* full device number of controlling terminal */
		tpgid,									/* terminal process group id */
		priority,								/* kernel scheduling priority */
		nice,										/* standard unix nice level of process */
		signal,									/* mask of pending signals */
		blocked,								/* mask of blocked signals */
		sigignore,							/* mask of ignored signals */
		sigcatch;								/* mask of caught  signals */
	long
		start_time,							/* start time of process -- seconds since 1-1-70 */
		utime,									/* user-mode CPU time accumulated by process */
		stime,									/* kernel-mode CPU time accumulated by process */
		cutime,									/* cumulative utime of process and reaped children */
		cstime,									/* cumulative stime of process and reaped children */
														/* the next 7 members come from /proc/#/statm */
		size,										/* total # of pages of memory */
		resident,								/* number of resident set (non-swapped) pages (4k) */
		share,									/* number of pages of shared (mmap'd) memory */
		trs,										/* text resident set size */
		lrs,										/* shared-lib resident set size */
		drs,										/* data resident set size */
		dt;											/* dirty pages */
	unsigned
		pcpu;           				/* %CPU usage (is not filled in by readproc!!!) */
	unsigned long
		vsize,									/* number of pages of virtual memory ... */
		rss,										/* resident set size from /proc/#/stat */
		rss_rlim,								/* resident set size ... ? */
		timeout,								/* ? */
		it_real_value,					/* ? */
		flags,									/* kernel flags for the process */
		min_flt,								/* number of minor page faults since process start */
		maj_flt,								/* number of major page faults since process start */
		cmin_flt,								/* cumulative min_flt of process and child processes */
		cmaj_flt,								/* cumulative maj_flt of process and child processes */
		start_code,							/* address of beginning of code segment */
		end_code,								/* address of end of code segment */
		start_stack,						/* address of the bottom of stack for the process */
		kstk_esp,								/* kernel stack pointer */
		kstk_eip,								/* kernel stack pointer */
		wchan;									/* address of kernel wait channel proc is sleeping in */
	struct proc_s 
		*next,									/* ptrs for building arbitrary linked structs */
		*prev;									/* (i.e. singly/doubly-linked lists and trees */
} *first_proc;

struct _tabs {
	void (*func)(WINDOW *win, PANEL *pan, int key);
} tabs[8];

struct _mem_info {
	int total;
	int used;
	int free;
	int shared;
	int buffers;
	int swaptotal;
	int swapused;
	int swapfree;
} mem_info;

struct _acct {
	int cur_acct_num;
	struct acct_rec cur_acct;
} account;
	
int cur_user=0;
int graphics_on=1;
int bbs_uid=0;
int screenlocked=0;

struct _max_info {
	int users;
	int memory;
} max_info;

const int num_opts = 102;

struct _acct_opts {
	int type;
	char name[30];
	void *value;
	int len;
};

struct _cfg_opts {
	int type;
	char name[30];
	void *value;
	int len;
};

#define HEADER   0       // As it says
#define E_STRING 1       // Editable String
#define INT      2       // Standard Integer
#define SEX      3       // Male/Female
#define DATE     4       // ASCII Date (ctime)
#define BDAY     5       // BirthDate
#define C_STRING 6       // Constant String
#define CHAR     7       // Character
#define PASSWORD 8       // Password *'s
#define BOOL_1   9       // ON/OFF
#define BOOL_2  10       // TRUE/FALSE
#define BOOL_3  11       // 'y'/'n'
#define A_FLAG  12       // Access Flags
#define M_FLAG  13       // Menu Flags
#define B_FLAG  14       // Menu Flags
#define UNKNOWN  -1      // Not Implemented

struct _acct_opts acct_opts[] = {
	{ HEADER, 	".Personal Information", 			NULL,																	0	},
	{ C_STRING, "Account #", 									&account.cur_acct.acctnum,						12		},
	{ E_STRING, "Account Name", 							&account.cur_acct.acctname,						32		},
	{ E_STRING, "Real Name", 									&account.cur_acct.realname,						32		},
	{ E_STRING, "Street/Email", 							&account.cur_acct.street,							32		},
	{ E_STRING, "City", 											&account.cur_acct.city,								24		},
	{ E_STRING, "State", 											&account.cur_acct.state,							16		},
	{ E_STRING, "ZIP", 												&account.cur_acct.zip,								12		},
	{ E_STRING, "Home Phone", 								&account.cur_acct.phone,							16		},
	{ E_STRING, "Work Phone", 								&account.cur_acct.wphone,							16		},
	{ SEX, 			"Sex", 												&account.cur_acct.sex,								0			},
	{ BDAY,			"Birthday", 									&account.cur_acct.birthday,						0			},
	{ HEADER,		".Account Information",				NULL,																	0			},
	{ E_STRING,	"Comment", 										&account.cur_acct.comment,						0			},
	{ PASSWORD,	"Password", 									&account.cur_acct.pword,							0			},
	{ BOOL_3,		"Line Feeds", 								&account.cur_acct.linfed,							0			},
	{ CHAR,			"Page Length", 								&account.cur_acct.lines_per_page,			0			},
	{ INT,			"Line Length", 								&account.cur_acct.linlen,							0			},
	{ BOOL_1,		"Hotkeys", 										&account.cur_acct.hotkeys,						0			},
	{ UNKNOWN,	"Setup Answers", 							&account.cur_acct.setupques,					0			},
	{ INT,			"Credits", 										&account.cur_acct.credits,						0			},
	{ HEADER,		".Access Settings", 					NULL,																	0			},
	{ INT,			"D/L Access", 								&account.cur_acct.dlseclev,						0			},
	{ INT,			"U/L Access", 								&account.cur_acct.ulseclev,						0			},
	{ INT,			"Read Access", 								&account.cur_acct.readseclev,					0			},
	{ INT,			"Post Access", 								&account.cur_acct.postseclev,					0			},
	{ A_FLAG,		"User Bios ",									(void *)1L,														0			},
	{ A_FLAG,		"Teleconference",							(void *)2L,														0			},
	{ A_FLAG,		"Send Email",									(void *)4L,														0			},
	{ A_FLAG,		"Stealth",										(void *)8L,														0			},
	{ A_FLAG,		"Sub-Op Access",							(void *)16L,													0			},
	{ A_FLAG,		"Sysop Access",								(void *)32L,													0			},
	{ A_FLAG,		"Send to Group 1",						(void *)64L,													0			},
	{ A_FLAG,		"Send to Group 2",						(void *)128L,													0			},
	{ A_FLAG,		"Send to Group 3",						(void *)256L,													0			},
	{ A_FLAG,		"Send to Group 4",						(void *)512L,													0			},
	{ A_FLAG,		"Can See Group 1",						(void *)1024L,												0			},
	{ A_FLAG,		"Can See Group 2",						(void *)2048L,												0			},
	{ A_FLAG,		"Can See Group 3",						(void *)4096L,												0			},
	{ A_FLAG,		"Can See Group 4",						(void *)8192L,												0			},
	{ A_FLAG,		"Download",										(void *)16384L,												0			},
	{ A_FLAG,		"Message Base",								(void *)32768L,												0			},
	{ A_FLAG,		"Net Mail",										(void *)65536L,												0			},
	{ A_FLAG,		"Echo Mail",									(void *)131072L,											0			},
	{ M_FLAG,		"Menu 1",											(void *)(1L << 0),										0			},
	{ M_FLAG,		"Menu 2",											(void *)(1L << 1),										0			},
	{ M_FLAG,		"Menu 3",											(void *)(1L << 2),										0			},
	{ M_FLAG,		"Menu 4",											(void *)(1L << 3),										0			},
	{ M_FLAG,		"Menu 5",											(void *)(1L << 4),										0			},
	{ M_FLAG,		"Menu 6",											(void *)(1L << 5),										0			},
	{ M_FLAG,		"Menu 7",											(void *)(1L << 6),										0			},
	{ M_FLAG,		"Menu 8",											(void *)(1L << 7),										0			},
	{ M_FLAG,		"Menu 9",											(void *)(1L << 8),										0			},
	{ M_FLAG,		"Menu 10",										(void *)(1L << 9),										0			},
	{ M_FLAG,		"Menu 11",										(void *)(1L << 10),										0			},
	{ M_FLAG,		"Menu 12",										(void *)(1L << 11),										0			},
	{ M_FLAG,		"Menu 13",										(void *)(1L << 12),										0			},
	{ M_FLAG,		"Menu 14",										(void *)(1L << 13),										0			},
	{ M_FLAG,		"Menu 15",										(void *)(1L << 14),										0			},
	{ M_FLAG,		"Menu 16",										(void *)(1L << 15),										0			},
	{ M_FLAG,		"Menu 17",										(void *)(1L << 16),										0			},
	{ M_FLAG,		"Menu 18",										(void *)(1L << 17),										0			},
	{ M_FLAG,		"Menu 19",										(void *)(1L << 18),										0			},
	{ M_FLAG,		"Menu 20",										(void *)(1L << 19),										0			},
	{ M_FLAG,		"Menu 21",										(void *)(1L << 20),										0			},
	{ M_FLAG,		"Menu 22",										(void *)(1L << 21),										0			},
	{ M_FLAG,		"Menu 23",										(void *)(1L << 22),										0			},
	{ M_FLAG,		"Menu 24",										(void *)(1L << 23),										0			},
	{ M_FLAG,		"Menu 25",										(void *)(1L << 24),										0			},
	{ M_FLAG,		"Menu 26",										(void *)(1L << 25),										0			},
	{ M_FLAG,		"Menu 27",										(void *)(1L << 26),										0			},
	{ M_FLAG,		"Menu 28",										(void *)(1L << 27),										0			},
	{ M_FLAG,		"Menu 29",										(void *)(1L << 28),										0			},
	{ M_FLAG,		"Menu 30",										(void *)(1L << 29),										0			},
	{ M_FLAG,		"Menu 31",										(void *)(1L << 30),										0			},
	{ M_FLAG,		"Menu 32",										(void *)(1L << 31),										0			},
	{ HEADER,		".Sysop Settings",						NULL,																	0			},
	{ INT,			"Account Type", 							&account.cur_acct.account_type,				0			},
	{ INT,			"Account Group", 							&account.cur_acct.acct_group,					0			},
	{ BOOL_1,		"Recording", 									&account.cur_acct.recording,					0			},
	{ BOOL_1,		"Uses Credits", 							&account.cur_acct.use_credits,				0			},
	{ INT,			"Status", 										&account.cur_acct.acct_status,				0			},
	{ INT,			"Start Menu", 								&account.cur_acct.default_menu,				0			},
	{ DATE,			"Expiration", 								&account.cur_acct.expire_date,				0			},
	{ HEADER,		".Statistics",								NULL,																	0			},
	{ INT,			"Downloads", 									&account.cur_acct.dloads,							0			},
	{ INT,			"Uploads", 										&account.cur_acct.uploads,						0			},
	{ INT,			"# of Logons", 								&account.cur_acct.totlogons,					0			},
	{ INT,			"Total Time Online", 					&account.cur_acct.totacctime,					0			},
	{ INT,			"Time in Teleconf", 					&account.cur_acct.tlcf_time,					0			},
	{ INT,			"Logons Since Billed", 				&account.cur_acct.logons,							0			},
	{ INT,			"Time On Since Billed", 			&account.cur_acct.acctime,						0			},
	{ INT,			"Upload K", 									&account.cur_acct.upload_k,						0			},
	{ INT,			"Download K", 								&account.cur_acct.download_k,					0			},
	{ DATE,			"Last Logon", 								&account.cur_acct.log_time,						0			},
	{ DATE,			"Last Logoff", 								&account.cur_acct.logoff_time,				0			},
	{ DATE,			"2nd to last Logon", 					&account.cur_acct.prev_logtime,				0			},
	{ DATE,			"2nd to last Logout", 				&account.cur_acct.prev_logoff_time,		0			},
	{ HEADER,		".Misc",											NULL,																	0			},
	{ DATE,			"Read Bulletins", 						&account.cur_acct.bulreadtime,				0			},
	{ DATE,			"Date Created", 							&account.cur_acct.creat_date,					0			},
	{ INT,			"Time On Today", 							&account.cur_acct.dayacctime,					0			},
	{ INT,			"Timer Level", 								&account.cur_acct.priv_level,					0			},
	{ BOOL_1,		"Long Menus", 								&account.cur_acct.verbose,						0			}

//  Not going to put this in.. maybe later?
// --------------------------------------------------------
//	{ UNKNOWN, "msgbase_scan_flags", &account.cur_acct.msgbase_scan_flags	},
//	{ UNKNOWN, "lastmsgscan", &account.cur_acct.lastmsgscan	},
//	{ UNKNOWN, "lastfilescan", &account.cur_acct.lastfilescan	}

};

struct _cfg_opts cfg_opts[] = {
	{ HEADER, 	".General Setup", 						NULL,																	0	},
	{ C_STRING, "Sysop Account", 							&account.cur_acct.acctnum,						12		},
	{ PASSWORD, "System Password", 						&account.cur_acct.acctname,						32		},
	{ BOOL_1,		"Allow New Users", 						&account.cur_acct.realname,						32		},
	{ INT,			"Max Visitors Online", 				&account.cur_acct.street,							32		},
	{ INT, 			"Minimum Age", 								&account.cur_acct.city,								24		},
	{ BOOL_1, 	"Chat Call Active", 					&account.cur_acct.state,							16		},
	{ BOOL_1, 	"Log File Active", 						&account.cur_acct.zip,								12		},
	{ INT, 			"Up:Download Ratio", 					&account.cur_acct.phone,							16		},
	{ INT, 			"Main Menu Cost", 						&account.cur_acct.wphone,							16		},
	{ E_STRING,	"BBS Owner", 									&account.cur_acct.birthday,						0			},
	{ E_STRING, "BBS Group", 									&account.cur_acct.sex,								0			},
	{ HEADER,		".Timer Levels",				NULL,																	0			},
	{ INT,			"Time Per Call - 1", 					&account.cur_acct.comment,						0			},
	{ INT,			"Time Per Day  - 1", 					&account.cur_acct.comment,						0			},
	{ INT,			"Time Per Call - 2", 					&account.cur_acct.pword,							0			},
	{ INT,			"Time Per Day  - 2", 					&account.cur_acct.pword,							0			},
	{ INT,			"Time Per Call - 3", 					&account.cur_acct.linfed,							0			},
	{ INT,			"Time Per Day  - 3", 					&account.cur_acct.linfed,							0			},
	{ INT,			"Time Per Call - 4", 					&account.cur_acct.lines_per_page,			0			},
	{ INT,			"Time Per Day  - 4", 					&account.cur_acct.lines_per_page,			0			},
	{ INT,			"Time Per Call - 5", 					&account.cur_acct.linlen,							0			},
	{ INT,			"Time Per Day  - 5", 					&account.cur_acct.linlen,							0			},
	{ HEADER,		".Force Read of Bulletins", 	&account.cur_acct.linlen,							0			},
	{ B_FLAG,		"Force Bulletin 1",						(void *)(1L << 0),										0			},
	{ B_FLAG,		"Force Bulletin 2",						(void *)(1L << 1),										0			},
	{ B_FLAG,		"Force Bulletin 3",						(void *)(1L << 2),										0			},
	{ B_FLAG,		"Force Bulletin 4",						(void *)(1L << 3),										0			},
	{ B_FLAG,		"Force Bulletin 5",						(void *)(1L << 4),										0			},
	{ B_FLAG,		"Force Bulletin 6",						(void *)(1L << 5),										0			},
	{ B_FLAG,		"Force Bulletin 7",						(void *)(1L << 6),										0			},
	{ B_FLAG,		"Force Bulletin 8",						(void *)(1L << 7),										0			},
	{ B_FLAG,		"Force Bulletin 9",						(void *)(1L << 8),										0			},
	{ B_FLAG,		"Force Bulletin 10",					(void *)(1L << 9),										0			},
	{ B_FLAG,		"Force Bulletin 11",					(void *)(1L << 10),										0			},
	{ B_FLAG,		"Force Bulletin 12",					(void *)(1L << 11),										0			},
	{ B_FLAG,		"Force Bulletin 13",					(void *)(1L << 12),										0			},
	{ B_FLAG,		"Force Bulletin 14",					(void *)(1L << 13),										0			},
	{ B_FLAG,		"Force Bulletin 15",					(void *)(1L << 14),										0			},
	{ B_FLAG,		"Force Bulletin 16",					(void *)(1L << 15),										0			},
	{ B_FLAG,		"Force Bulletin 17",					(void *)(1L << 16),										0			},
	{ B_FLAG,		"Force Bulletin 18",					(void *)(1L << 17),										0			},
	{ B_FLAG,		"Force Bulletin 19",					(void *)(1L << 18),										0			},
	{ B_FLAG,		"Force Bulletin 20",					(void *)(1L << 19),										0			},
	{ B_FLAG,		"Force Bulletin 21",					(void *)(1L << 20),										0			},
	{ B_FLAG,		"Force Bulletin 22",					(void *)(1L << 21),										0			},
	{ B_FLAG,		"Force Bulletin 23",					(void *)(1L << 22),										0			},
	{ B_FLAG,		"Force Bulletin 24",					(void *)(1L << 23),										0			},
	{ B_FLAG,		"Force Bulletin 25",					(void *)(1L << 24),										0			},
	{ B_FLAG,		"Force Bulletin 26",					(void *)(1L << 25),										0			},
	{ B_FLAG,		"Force Bulletin 27",					(void *)(1L << 26),										0			},
	{ B_FLAG,		"Force Bulletin 28",					(void *)(1L << 27),										0			},
	{ B_FLAG,		"Force Bulletin 29",					(void *)(1L << 28),										0			},
	{ B_FLAG,		"Force Bulletin 30",					(void *)(1L << 29),										0			},
	{ B_FLAG,		"Force Bulletin 31",					(void *)(1L << 30),										0			},
	{ B_FLAG,		"Force Bulletin 32",					(void *)(1L << 31),										0			},
	{ HEADER,		".New Caller Setup", 								&account.cur_acct.linlen,							0			},
	{ INT,			"Message Read Level", 										&account.cur_acct.hotkeys,						0			},
	{ INT,			"Message Post Level", 										&account.cur_acct.hotkeys,						0			},
	{ INT,			"DL Access Level", 							&account.cur_acct.setupques,					0			},
	{ INT,			"UL Access Level", 										&account.cur_acct.credits,						0			},
	{ HEADER,		".Access Settings", 					NULL,																	0			},
	{ INT,			"D/L Access", 								&account.cur_acct.dlseclev,						0			},
	{ INT,			"U/L Access", 								&account.cur_acct.ulseclev,						0			},
	{ INT,			"Read Access", 								&account.cur_acct.readseclev,					0			},
	{ INT,			"Post Access", 								&account.cur_acct.postseclev,					0			},
	{ HEADER,		".New User Access Flags", 		NULL,																	0			},
	{ A_FLAG,		"User Bios ",									(void *)1L,														0			},
	{ A_FLAG,		"Teleconference",							(void *)2L,														0			},
	{ A_FLAG,		"Send Email",									(void *)4L,														0			},
	{ A_FLAG,		"Stealth",										(void *)8L,														0			},
	{ A_FLAG,		"Send to Group 1",						(void *)16L,													0			},
	{ A_FLAG,		"Send to Group 2",						(void *)32L,													0			},
	{ A_FLAG,		"Send to Group 3",						(void *)64L,													0			},
	{ A_FLAG,		"Send to Group 4",						(void *)128L,													0			},
	{ A_FLAG,		"Can See Group 1",						(void *)1024L,												0			},
	{ A_FLAG,		"Can See Group 2",						(void *)2048L,												0			},
	{ A_FLAG,		"Can See Group 3",						(void *)4096L,												0			},
	{ A_FLAG,		"Can See Group 4",						(void *)8192L,												0			},
	{ A_FLAG,		"Download",										(void *)16384L,												0			},
	{ A_FLAG,		"Message Base",								(void *)32768L,												0			},
	{ A_FLAG,		"Net Mail",										(void *)65536L,												0			},
	{ A_FLAG,		"Echo Mail",									(void *)131072L,											0			},
	{ HEADER,		".New User Menu Flags", 			NULL,																	0			},
	{ M_FLAG,		"Menu 1",											(void *)(1L << 0),										0			},
	{ M_FLAG,		"Menu 2",											(void *)(1L << 1),										0			},
	{ M_FLAG,		"Menu 3",											(void *)(1L << 2),										0			},
	{ M_FLAG,		"Menu 4",											(void *)(1L << 3),										0			},
	{ M_FLAG,		"Menu 5",											(void *)(1L << 4),										0			},
	{ M_FLAG,		"Menu 6",											(void *)(1L << 5),										0			},
	{ M_FLAG,		"Menu 7",											(void *)(1L << 6),										0			},
	{ M_FLAG,		"Menu 8",											(void *)(1L << 7),										0			},
	{ M_FLAG,		"Menu 9",											(void *)(1L << 8),										0			},
	{ M_FLAG,		"Menu 10",										(void *)(1L << 9),										0			},
	{ M_FLAG,		"Menu 11",										(void *)(1L << 10),										0			},
	{ M_FLAG,		"Menu 12",										(void *)(1L << 11),										0			},
	{ M_FLAG,		"Menu 13",										(void *)(1L << 12),										0			},
	{ M_FLAG,		"Menu 14",										(void *)(1L << 13),										0			},
	{ M_FLAG,		"Menu 15",										(void *)(1L << 14),										0			},
	{ M_FLAG,		"Menu 16",										(void *)(1L << 15),										0			},
	{ M_FLAG,		"Menu 17",										(void *)(1L << 16),										0			},
	{ M_FLAG,		"Menu 18",										(void *)(1L << 17),										0			},
	{ M_FLAG,		"Menu 19",										(void *)(1L << 18),										0			},
	{ M_FLAG,		"Menu 20",										(void *)(1L << 19),										0			},
	{ M_FLAG,		"Menu 21",										(void *)(1L << 20),										0			},
	{ M_FLAG,		"Menu 22",										(void *)(1L << 21),										0			},
	{ M_FLAG,		"Menu 23",										(void *)(1L << 22),										0			},
	{ M_FLAG,		"Menu 24",										(void *)(1L << 23),										0			},
	{ M_FLAG,		"Menu 25",										(void *)(1L << 24),										0			},
	{ M_FLAG,		"Menu 26",										(void *)(1L << 25),										0			},
	{ M_FLAG,		"Menu 27",										(void *)(1L << 26),										0			},
	{ M_FLAG,		"Menu 28",										(void *)(1L << 27),										0			},
	{ M_FLAG,		"Menu 29",										(void *)(1L << 28),										0			},
	{ M_FLAG,		"Menu 30",										(void *)(1L << 29),										0			},
	{ M_FLAG,		"Menu 31",										(void *)(1L << 30),										0			},
	{ M_FLAG,		"Menu 32",										(void *)(1L << 31),										0			},
	{ HEADER,		".Sysop Settings",						NULL,																	0			},
	{ INT,			"Account Type", 							&account.cur_acct.account_type,				0			},
	{ INT,			"Account Group", 							&account.cur_acct.acct_group,					0			},
	{ BOOL_1,		"Recording", 									&account.cur_acct.recording,					0			},
	{ BOOL_1,		"Uses Credits", 							&account.cur_acct.use_credits,				0			},
	{ INT,			"Status", 										&account.cur_acct.acct_status,				0			},
	{ INT,			"Start Menu", 								&account.cur_acct.default_menu,				0			},
	{ DATE,			"Expiration", 								&account.cur_acct.expire_date,				0			},
	{ HEADER,		".Statistics",								NULL,																	0			},
	{ INT,			"Downloads", 									&account.cur_acct.dloads,							0			},
	{ INT,			"Uploads", 										&account.cur_acct.uploads,						0			},
	{ INT,			"# of Logons", 								&account.cur_acct.totlogons,					0			},
	{ INT,			"Total Time Online", 					&account.cur_acct.totacctime,					0			},
	{ INT,			"Time in Teleconf", 					&account.cur_acct.tlcf_time,					0			},
	{ INT,			"Logons Since Billed", 				&account.cur_acct.logons,							0			},
	{ INT,			"Time On Since Billed", 			&account.cur_acct.acctime,						0			},
	{ INT,			"Upload K", 									&account.cur_acct.upload_k,						0			},
	{ INT,			"Download K", 								&account.cur_acct.download_k,					0			},
	{ DATE,			"Last Logon", 								&account.cur_acct.log_time,						0			},
	{ DATE,			"Last Logoff", 								&account.cur_acct.logoff_time,				0			},
	{ DATE,			"2nd to last Logon", 					&account.cur_acct.prev_logtime,				0			},
	{ DATE,			"2nd to last Logout", 				&account.cur_acct.prev_logoff_time,		0			},
	{ HEADER,		".Misc",											NULL,																	0			},
	{ DATE,			"Read Bulletins", 						&account.cur_acct.bulreadtime,				0			},
	{ DATE,			"Date Created", 							&account.cur_acct.creat_date,					0			},
	{ INT,			"Time On Today", 							&account.cur_acct.dayacctime,					0			},
	{ INT,			"Timer Level", 								&account.cur_acct.priv_level,					0			},
	{ BOOL_1,		"Long Menus", 								&account.cur_acct.verbose,						0			}

//  Not going to put this in.. maybe later?
// --------------------------------------------------------
//	{ UNKNOWN, "msgbase_scan_flags", &account.cur_acct.msgbase_scan_flags	},
//	{ UNKNOWN, "lastmsgscan", &account.cur_acct.lastmsgscan	},
//	{ UNKNOWN, "lastfilescan", &account.cur_acct.lastfilescan	}

};


char *tab_opt[] = { 
	"1. Users", 
	"2. AcctEdit",
	"3. Stats", 
	"4. YourMama", 
	"5. Unused", 
	"6. Unused", 
	"7. Unused", 
	"8. Unused" 
};

