#ifndef STRUCTS_DEF
#define STRUCTS_DEF

#define IDLETIME 20

#include <time.h>

#define uidlen 			32
#define outbufsiz 		OUT_DATA_SIZE
#define ibufsz 			IN_DATA_SIZE
#define MAXBASES		250
#define MAXAREAS		100

#ifndef TRUE
#define TRUE 			1
#endif

#ifndef FALSE
#define FALSE 			0
#endif

#define EMBUFSIZE 		8192

#define priv_system     	5
#define priv_sysop      	4
#define priv_unrestricted 	3
#define priv_demo       	2
#define non_paying      	1
#define priv_restricted 	0

#define userbioaccess   	1L
#define tlcf_access     	2L
#define postemailaccess 	4L
#define stealthallowed  	8L
#define subopaccess     	16L
#define sysopaccess     	32L
#define send_group1    	 	64L
#define send_group2    		128L
#define send_group3    		256L
#define send_group4    		512L
#define who_group1    		1024L
#define who_group2    		2048L
#define who_group3    		4096L
#define who_group4    		8192L
#define downloadaccess		16384L
#define msgbaseaccess		32768L
#define netmailaccess		65536L
#define echomailaccess		131072L
#define inetemailaccess		262144L
#define num_access_flags 	19

#define vbsmsg 			1
#define shortmsg 		0

#define xascii 			0
#define xmodem 			1
#define ACK 			06
#define EOT 			04
#define NAK 			21
#define SOH 			01
#define CAN 			24
#define STX 			02
#define eot_sent 		1
#define crcflag  		2
#define file_open 		4
#define sendcflag 		8
#define ymodemflag 		16
#define no_save 		-1

#define st_idle           	0
#define st_logon          	1	
#define st_newacct        	2
#define st_main           	3
#define st_tlcf           	4
#define st_userlist       	5
#define st_extern         	6
#define st_logoff         	7
#define st_exitting       	8
#define st_system         	9
#define st_system_disp   	10
#define st_system_edit  	11
#define st_oocredits     	12
#define st_network       	26

/*
** Operator (system console) state definitions
*/

#define opr_st_idle    		0
#define opr_st_quit    		1
#define opr_st_sendmenu 	2
#define opr_st_send    		3
#define opr_st_brcast  		4
#define opr_st_monitor 		5
#define opr_st_lockon    	6
#define opr_st_lockon2   	7
#define opr_st_hangup  		8
#define opr_st_tlcf    		9
#define opr_st_send2   		10
#define opr_st_tlcf2   		11
#define opr_st_record    	18
#define opr_st_utility		19

struct short_email_record		/* Tiny Record 			*/ 
{ int  status;				/* 0 = Read, 1 = New, 2 = NRRR	*/
					/* 3 = Deleted 4 = NETMAIL	*/
					/* 5 = internet mail		*/
  char to[32],  			/* To whom the letter is to	*/
       from[32];			/* To whom it came from		*/
  long location;			/* Where the letter is at	*/
};

struct node_record { int zone, net, node, point;};

struct email_record			/* Large Record			*/
{ int  status;				/* 0 = Read, 1 = New, 2 = NRRR	*/
					/* 3 = Deleted 4 = NETMAIL	*/
					/* 5 = Internet Mail		*/
  char to[32],  			/* To whom the letter is to	*/
       from[32];			/* To whom it came from		*/
  long location;			/* Where the letter is at	*/
  char subject[42];			/* Subject line 41 chars max	*/
  char filename[30];			/* Realtime filename		*/
  char stored_as[15];			/* Filename stored as timestamp	*/
  int length;				/* Length of letter text	*/
  time_t timesent;			/* Timestamp of the letter	*/
  long  offset;				/* Location of text of letter	*/
  struct node_record node;		/* Fido Net Mail Node Record	*/
  char inet_address[128];		/* Internet return address	*/
};

struct letter_record
{ time_t time_posted;			/* Time message was posted	*/
  unsigned long idx_offset;		/* Offset into idx file		*/
  unsigned long dat_offset;		/* Offset into dat file 	*/
  int length;				/* Length of the message text	*/
  char to[uidlen];			/* Who the message is to	*/
  char from[uidlen];			/* Who the letter is from	*/
  char subject[72];			/* Subject of the letter	*/
  int flags;				/* deleted, imported, ect	*/
  struct node_record node;		/* System it came from		*/
  long msgnumber;			/* msgnumber			*/  
};    
  
struct bday_rec
{ int month:5;				/* Month user was born			*/
  int day:7;				/* Day user was born			*/
  int year:18;				/* Year user was born			*/
};

struct mail_list_record
{ int status;				/* 0 = Inactive 1 = Active	*/
  int entries;				/* Number of entries in list	*/
  char owner[32];			/* Owner of the list		*/
  char name[32];			/* Name of the list		*/
  char user[64][32];			/* Upto 64 people on the list	*/
};

struct last20_str
{ long int l2_num;			/* Caller number		*/
  char l2_name[32], 			/* User Name			*/
       l2_time[18], 			/* Time Called			*/
       l2_from[41];			/* Where called from		*/
};

struct msgbase_ptr_record
{ char name[32];
  unsigned long last_read;
  int scanned;
};
   
struct biography_record
{ int status;				/* Status of this record	*/
					/* -1 = Deleted 1 = Active	*/
  char name[32], 			/* Username of this record	*/
       answer[5][60], 			/* Definable Questions		*/
       text[15 * 81];			/* Biography Text		*/
};

struct acct_rec
{   char acctname[uidlen], 		/* Account handle		*/
         acctnum[12], 			/* Account number		*/
         pword[12], 			/* User Password		*/
         realname[uidlen], 		/* Users Real Name		*/
         street[32],			/* Street Address		*/
         city[24], 			/* City				*/
         state[16], 			/* State			*/
         zip[12], 			/* Zipcode			*/
         phone[16], 			/* Home Phone Number		*/
         wphone[16], 			/* Work Phone Number		*/
         comment[32], 			/* User comment			*/
         linfed,			/* Do they require linefeeds	*/
         setupques[6][41];           	/* Answers to Setup Questions	*/
     int sex, 				/* 1 = Male, 0 = Female		*/
         default_menu, 			/* Users Default Menu		*/
         lines_per_page, 		/* Screen Lines per page	*/
         acct_status, 			/* Account Status		*/
         dayacctime, 
         use_credits,
         priv_level, 
         verbose, 
         recording, 
         account_type, 
         acct_group;  
  struct bday_rec birthday;      
    long msgbase_scan_flags[10], 
         accessflags, 
         credits;
long int menu_flags;
unsigned linlen, 
         dloads, 
         uploads;
  time_t creat_date, 
         expire_date, 
         log_time, 
         prev_logtime, 
         logoff_time,
         prev_logoff_time, 
         acmsgtime, 
         bulreadtime, 
         lastmsgscan[MAXBASES], 
         lastfilescan[MAXAREAS];
unsigned long logons, 
         totlogons, 
         acctime, 
         totacctime, 
         tlcf_time, 
         upload_k,
         download_k;
     int dlseclev, 
         ulseclev, 
         readseclev, 
         postseclev;
    char hotkeys,	// Added version 10.7
         fse_flag,      // added version 10.74
         unused_space_2[49];
    char em_fw[81];	// Added Version 10.75
    char inet_name[uidlen];	// Added Version 10.75
};

/* Hotkeys was bgrdflag */

struct user_rec
{        char doors_id[21], 
              u_tempbuf[16];  
          int u_stat, 
              u_stat2, 
              u_eltime, 
              u_btusts, 
              u_paged, 
              u_prflvl, 
              visitor, 
              u_ansi,
              u_idletime, 
              door_inq, 
              door_outq, 
              u_doortcb, 
              u_privateflag, 
              u_timeroff,
              u_work3, 
              u_curmenu, 
              connecttimer, 
              idletimer, 
              hotkeys, 
              current_cost,
              time_left_today, 
              time_on_thiscall, 
              stealth, 
              busyflag, 
              u_daemon_pid,
              u_pagelen, 
              dataoutputq, 
              bytes_in_from_user;      
 unsigned int u_work1, 
              u_work2, 
              u_ticker, 
              insysopchat, 
              chatwith;  
     unsigned baudrate;  
unsigned char ignore[16], 
              gag;
         char baud_rate[10],
              process_global_comands,
              u_update_screen_flag,
              unused_u_space[80];
};


#ifdef using_timestamp
struct timestamp
{ unsigned ts_date;		/* bit fields for date */
  unsigned ts_time;		/* bit fields for time */
  int ts_year;
  int ts_month;
  int ts_day;
  int ts_hour;
  int ts_minute;
  char ts_str[15];
};
#endif

struct windows
{ char w_name[20];
   int x_max,
       y_max,
       last_x,
       x_pos,
       y_pos;
};

typedef int (*faddr) ();	/* function address */

struct index_rec
{ time_t upload_time;
    char filename[81], 
         title[15 * 81], 
         owner[21], 
         group[21], 
         path[81],
         validated;
     int size, 
         times_sent;
};

struct batch_rec
{     char filename[81], 
           title[15 * 81];
  unsigned int filesize, 
           area;
};

#endif