/*
** Shared memory constructs and core values for talking to Falken.
*/

#ifndef FALKEN_H
#define FALKEN_H

/*
** universal size for handling text coming in from user
*/

#define IN_DATA_SIZE  2048

/*
** universal size for handling text going out to user
** make it big enough to please most folks...
*/

#define OUT_DATA_SIZE 40000
#define MON_BUFFER_SIZE 10000
#define LOG_BUFFER_SIZE 4000

#include "structs.h"
#include "bbscfg.h"

#ifndef MIN
#define MIN(a, b) ((a < b)? a: b)
#endif

#define SECS_PER_DAY (60L * 60L * 24L)

#define MAXCMDS 16

#define SHMEMID 0x1956
#define FALKEN_SEMID 0x1957

/*
** These are defines to identify the various semaphores in the Falken set.
** The LOGMEMSEM is actually an array of 16 semaphores, used
** to access the command bytes of the bbslogin commands.
** We use 16 semaphores to reduce the time spent waiting for
** the semaphores.
*/

#define BBS_ACTIVE 0
#define STRUCTS_LOCK 1
#define MDBSEM 2
#define BUFSEM 3
#define NUM_SEMS 4
#define MAXLINES 64
#define FALKENQID (MAXLINES * 2)

struct line_def_struct
{ int pid;
  int output_pending;
  int active;
  char ttyname[16];
  char loginname[20];
  short int cmdbyte[MAXCMDS];
  short int cmdhead;
  short int cmdtail;
  short int incmdbyte;
};

#define BUFFER_SIZE 64
#define NUM_BUFFERS 512
#define NUM_MDBS 512

struct buffer
{ struct buffer *fptr;
  int count;
  char text[BUFFER_SIZE];
};

struct mdbrec
{ short int command;
  short int line;
  short int length;
  short int flag;
  struct buffer *bufptr;
  struct mdbrec *fptr;
};

struct mdbrec *a_mdb();
struct mdbrec *dequeue_mdb();
struct buffer *a_buf();

struct shared_mem_structure
{ struct acct_rec acct[MAXLINES];
  struct user_rec user[MAXLINES];
  struct cfg_rec cfg;
  struct line_def_struct linctrl[MAXLINES];
  unsigned char xlate_table[256];
  int monitor_line;
  int monitor_tail;
  int nchans;
  char monitor_buf[MON_BUFFER_SIZE];
  char log_buf[LOG_BUFFER_SIZE];
  int log_tail;
  struct buffer buflist[NUM_BUFFERS];
  struct buffer *freebuf;
  int free_b_cnt;
  struct mdbrec mdblist[NUM_MDBS];
  struct mdbrec *freemdb;
  int free_m_cnt;
  struct mdbrec *mdb[(MAXLINES * 2) + 10];	// was 1, increased for Net_Teleconf
  char serialnum[20];
  char version[20];
  char owner[40];
  char laststartup[41];
  int console_page;
  struct menu_rec menudef[32];
};

/*
** Commands passed to and from the Falken task.
*/

#define NO_COMMAND		0	/* a dummy value */

/*
** Next, from doors to Falken
*/

#define F_CMD_TEXTOUT		201
#define F_CMD_TEXTIN		202
#define F_CMD_LOGOFF		205
#define F_CMD_BINOUT		206
#define F_CMD_TEXTMODE    	207
#define F_CMD_BINARYMODE  	208
#define F_CMD_OESON   		210
#define F_CMD_OESOFF  		211
#define F_CMD_CLEARINBUF  	213
#define F_CMD_CLEAROUTBUF 	214
#define F_CMD_BBSLOG 	 	218
#define F_CMD_SAVEACCT    	222
#define F_CMD_PRIVATEON   	223
#define F_CMD_PRIVATEOFF   	224
#define F_CMD_SENDMSG 		229
#define F_CMD_SETPAGE		231
#define F_CMD_DOWNLOG 		234
#define F_CMD_GOTMSG  		237
#define F_CMD_WATCH   		238
#define F_CMD_WAKEUP  		239
#define F_CMD_ECHO_ON     	240
#define F_CMD_ECHO_OFF    	241
#define F_CMD_ECHO_DOTS   	242
#define F_CMD_KILLTASK    	243
#define F_CMD_OUT_MT    	244

/*
** These are commands to and from the bbsmonitor task.
*/

#define M_CMD_BBSMONITOR	300	/* announce a new monitor task */
#define M_CMD_BBSMONEND		301	/* monitor is detaching */
#define M_CMD_CHATTOGGLE	302	/* toggle opr chat indicator */
#define M_CMD_MONITOR		303	/* change line being monitored */
#define M_CMD_RECORD		304	/* record from a line */
#define M_CMD_TIMELIST		305	/* show timer list */
#define M_CMD_HALTBBS		306	/* halt the bbs */
#define M_CMD_INSERTKEY		307	/* insert a key */
#define M_CMD_RECORDOFF		308	/* stop recording */
#define M_CMD_UPDATE_WIN	309
#define M_CMD_LOGTOGGLE		310	/* Toggle LOG file	*/


#define FIRST_DOOR_CMD 		200
#define LAST_DOOR_CMD 		399

/*
** Constants for passing commands to and from bbslogin tasks...
*/

#define B_CMD_ECHO_ON     	501
#define B_CMD_ECHO_OFF    	502
#define B_CMD_ECHO_DOTS   	503
#define B_CMD_CLEAR_OUTPUT    	504
#define B_CMD_CLEAR_INPUT    	505
#define B_CMD_DISCARD_INPUT   	506
#define B_CMD_ACCEPT_INPUT    	507
#define B_CMD_PAUSE           	508
#define B_CMD_RESTART         	509
#define B_CMD_TEXTMODE        	510
#define B_CMD_RAWMODE         	511
#define B_CMD_TERMINATE		512
#define B_CMD_LOGGING_IN	513
#define B_CMD_INSERTKEY		514
#define B_CMD_TTY_INPUT 	515
#define B_CMD_OUT_MT 		517
#define B_CMD_ADD_LF		525
#define B_CMD_NO_ADD_LF		526
#define B_CMD_LOGIN_DONE	528
#define B_CMD_SET_OUTMT		529
#define B_CMD_CLEAR_OUTMT	530
#define B_CMD_WAKEUP_CHILD	531
#define B_CMD_STARTPRG 		540
#define B_CMD_TEXTIN		541
#define B_CMD_TEXTOUT		542

/*
** the timeout is sent by mainbbs to itself, when an internal timer has
** occurred
*/

#define B_CMD_TIMEOUT		600

#define MONITOR_WINDOW		1
#define BBSLOG_WINDOW		2
#define COMMAND_WINDOW		3
#define STATUS_WINDOW		4

#ifndef NULL
#include <stddef.h>
#endif /*  */

#ifndef EOF
#define EOF     (-1)
#endif /*  */

#endif /*  */
