#ifndef BBSCFG_DEF
#define BBSCFG_DEF

#define ASK_HANDLE      	0
#define ASK_ADDRESS     	1
#define ASK_CITY	      	2
#define ASK_STATE		3
#define ASK_ZIP         	4
#define ASK_HOMEPHONE   	5
#define ASK_WORKPHONE   	6
#define ASK_SEX         	7
#define ASK_BIRTHDAY    	8
#define ASK_NAME		9

#define CHANGE_HANDLE    	0
#define CHANGE_REALNAME  	1
#define CHANGE_ADDRESS   	2
#define CHANGE_CITY	    	3
#define CHANGE_STATE		4
#define CHANGE_ZIP       	5
#define CHANGE_HOMEPHONE 	6
#define CHANGE_WORKPHONE 	7
#define CHANGE_SEX	 	8
#define CHANGE_COMMENT   	9

#define MAXBASES		250

struct killtime 
{ int khour, 			/* Hour to start program	 */
      kminute, 			/* Minute to start program	 */
      kday; 			/* Days of week to start program */
};

struct menu_rec
{ char select_char[40][6], 	/* Command keys			*/
       action[40][50];		/* Function/Program to run	*/
   int cost[40];		/* Menu cost per minute		*/
  char menu_name[21],		/* Menu Name			*/
       menu_location[40][15];	/* Placed into doors ID tab	*/
};

struct protocol_record 
{ char key[5],			/* Command Keys			*/ 
       name[15], 		/* Protocol Name		*/
       action[41];		/* Program to run		*/
   int batch;			/* Support for BATCH X-Fers	*/
};

struct cfg_rec
{          char sysop[uidlen],		/* Name of SYSOP account	*/ 
                attach_path[30], 	/* Where file attachments go	*/
                sysop_password[12], 	/* System Password		*/
                work_file_path[30],	/* Where work files go		*/
                logon_doors[8][40], 	/* Doors to start at login	*/
                timed_doors[4][40], 	/* Doors to be started		*/
                front_door[30], 	/* Not used for Linux		*/
                bbs_path[30],		/* Where mainbbs files are	*/
                data_path[30], 		/* Where data files are		*/
                email_path[30], 	/* Not used for Linux		*/
                bio_path[30], 		/* Not used for Linux		*/
                log_path[30];		/* Where recordings go		*/
            int visitors_allowed, 	/* number of visitors online	*/
                makenewaccts, 		/* Allow new callers		*/
                newacctpriv, 		/* Newuser privilege levels	*/
                onlinetimer[6],		/* Time online per call		*/
                daylimit[6], 		/* Time online per day		*/
                sysop_chat, 		/* Chat page active if set to 1	*/
                logactive, 		/* Log BBSLOG if set to 1	*/
                minage, 		/* Minimum age to logon		*/
                main_menu_cost, 	/* Cost per minute at main menu	*/
                idleminutes,		/* Not used for Linux		*/
                initial_account_type, 	/* Newuser account type setting	*/
                initial_account_group, 	/* Newuser group type setting	*/
                uplratio, 		/* UL/DL Ratio required to DL	*/
                setup_query[10],	/* Ask which newuser questions	*/
                change_allowed[10], 	/* Change account settings	*/
                num_accts, 		/* Not used for Linux		*/
                default_menu;		/* Where to start newusers	*/
           long bul_must_read_flags, 	/* Required Bulletin numbers	*/
                cfgaccessflags, 	/* BIT based access flags	*/
                cfgmenuflags, 		/* BIT based menu flags		*/
                cfgdloadflags[2],	/* Not used anymore		*/
                cfguploadflags[2], 	/* Not used anymore		*/
                cfgmsgpostflags[2], 	/* Not used anymore		*/
                cfgmsgreadflags[2];	/* Not used anymore		*/
struct killtime kt[4], 			/* Time to run specific door	*/
                kt_d[4];		/* Date to run specific door	*/
  unsigned long newacctcredits, 	/* Newuser credits		*/
                newuplcredits;		/* Newuser upload credits	*/
            int postseclev, 		/* Newuser posting level	*/
                readseclev, 		/* Newuser reading level	*/
                dlseclev, 		/* Newuser download level	*/
                ulseclev, 		/* Newuser upload level		*/
                logon_doors_paused[8];	/* Pause after login doors	*/
           char bbs_group_name[15], 	/* Not used anymore		*/
                bbs_owner_name[15],	/* Not used anymore		*/
                unused_char[200];	/* For Future additions		*/
};

struct filebase_entry
{         char name[32], 		/* Filebase area name		*/
               moderator[32], 		/* Area moderator		*/
               directory[32], 		/* Location of files		*/
               filename[32], 		/* Name of index 		*/
               group[21], 		/* Group name for area		*/
               event[100];		/* Upload event			*/
  unsigned int size, 			/* Max files in area		*/
               validate, 		/* AutoValidate files		*/
               age, 			/* Age limit to access area	*/
               payback, 		/* Credits to pay uploader	*/
               cost, 			/* Cost to download		*/
               dlseclev, 		/* Download access level	*/
               ulseclev;		/* Upload access level		*/
};

struct filebase_record			/* See filebase_entry for desc	*/ 
{ int areas;
  struct filebase_entry filebase[MAXAREAS];
};

struct msgbase_entry		
{ char subject[36],		// Subject of current msgbase area
       moderator[uidlen],	// Who's running the show
       filename[15],		// Filename of data and idx files
       address[21],		// Node address for FIDO
       echo_tag[41],		// Echo Tag for FBBSECHO
       origin_line[61];		// Origin line for this area if used         	
  long flags;			// BITWISE status flags 
   int post_seclev,		// SecLev required to post
       read_seclev,		// SecLev required to read
       max_messages,		// Maximum Messages       
       msg_life;		// days to keep messages  
};      

struct msgbase_record		/* New message base format	*/
{ int areas;
  struct msgbase_entry msgbase[MAXBASES];
};
        
#endif