/*
 * Citadel/UX message support routines
 * see copyright.doc for copyright information
 */

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include "citadel.h"

#define MAXWORDBUF 256
#define MAXMSGS 512

struct cittext {
	struct cittext *next;
	char text[MAXWORDBUF];
	};

long finduser();
char inkey();
void sttybbs();
int struncmp();
int fmout();
int haschar();
int checkpagin();
void getline();
void formout();
int yesno();
void newprompt();
int file_checksum();
void color();

char reply_to[512];
long msg_arr[MAXMSGS];
int num_msgs;
extern char room_name[];
extern unsigned room_flags;
extern long highest_msg_read;
extern struct serv_info serv_info;
extern char temp[];
extern char temp2[];
extern int screenwidth;
extern int screenheight;
extern long maxmsgnum;
extern char is_mail;
extern char is_aide;
extern char is_room_aide;
extern char fullname[];
extern char axlevel;
extern unsigned userflags;
extern char sigcaught;
extern char editor_path[];
extern char printcmd[];

extern int editor_pid;

int lines_printed;

void ka_sigcatch() {
	char buf[256];
	alarm(S_KEEPALIVE);
	signal(SIGALRM,ka_sigcatch);
	serv_puts("NOOP");
	serv_gets(buf);
	}


/*
 * server keep-alive version of wait() (needed for external editor)
 */
pid_t ka_wait(kstatus)
pid_t *kstatus; {
	pid_t p;

	alarm(S_KEEPALIVE);
	signal(SIGALRM,ka_sigcatch);
	do {
		errno = 0;
		p = wait(kstatus);
		} while (errno==EINTR);
	signal(SIGALRM,SIG_IGN);
	alarm(0);
	return(p);
	}


/*
 * version of system() that uses ka_wait()
 */
int ka_system(shc)
char *shc; {
	pid_t childpid;
	pid_t waitpid;
	int retcode;

	childpid = fork();
	if (childpid < 0) {
		color(1);
		perror("Cannot fork");
		color(7);
		return((pid_t)childpid);
		}

	if (childpid == 0) {
		execlp("/bin/sh","sh","-c",shc,NULL);
		exit(127);
		}

	if (childpid > 0) {
		do {
			waitpid = ka_wait(&retcode);
			} while (waitpid != childpid);
		return(retcode);
		}

	return(-1);
	}



/*
 * add a newline to the buffer...
 */
void add_newline(textlist)
struct cittext *textlist; {
	struct cittext *ptr;

	ptr=textlist;
	while (ptr->next != NULL) ptr = ptr->next;

	while (ptr->text[strlen(ptr->text)-1]==32)
		ptr->text[strlen(ptr->text)-1] = 0;
	/* strcat(ptr->text,"\n"); */

	ptr->next = (struct cittext *)
		malloc(sizeof(struct cittext));
	ptr = ptr->next;
	ptr->next = NULL;
	strcpy(ptr->text,"");
	}


/*
 * add a word to the buffer...
 */
void add_word(textlist,wordbuf)
struct cittext *textlist;
char wordbuf[]; {
	struct cittext *ptr;


	ptr=textlist;
	while (ptr->next != NULL) ptr = ptr->next;
	
	if (3+strlen(ptr->text)+strlen(wordbuf) > screenwidth) {
		ptr->next = (struct cittext *)
			malloc(sizeof(struct cittext));
		ptr = ptr->next;
		ptr->next = NULL;
		strcpy(ptr->text,"");
		}
	
	strcat(ptr->text,wordbuf);
	strcat(ptr->text," ");
	}


/*
 * begin editing of an opened file pointed to by fp, beginning at position pos.
 */
void citedit(fp,base_pos)
FILE *fp;
long base_pos; {
	int a,prev,finished,b,last_space;
	int appending = 0;
	struct cittext *textlist = NULL;
	struct cittext *ptr;
	char wordbuf[MAXWORDBUF];
	char buf[256];
	long last_server_msg,now;

	/*
	 * we're going to keep track of the last time we talked to
	 * the server, so we can periodically send keep-alive messages
	 * out so it doesn't time out.
	 */
	time(&last_server_msg);

	/* first, load the text into the buffer */
	fseek(fp,base_pos,0);
	textlist = (struct cittext *)malloc(sizeof(struct cittext));
	textlist->next = NULL;
	strcpy(textlist->text,"");

	strcpy(wordbuf,"");
	prev = (-1);
	while (a=getc(fp), a>=0) {
		appending = 1;
		if ((a==32)||(a==9)||(a==13)||(a==10)) {
			add_word(textlist,wordbuf);
			strcpy(wordbuf,"");
			if ((prev==13)||(prev==10)) {
				add_word(textlist,"\n");
				add_newline(textlist);
				add_word(textlist,"");
				}
			}
		else {
			wordbuf[strlen(wordbuf)+1] = 0;
			wordbuf[strlen(wordbuf)] = a;
			}
		if (strlen(wordbuf)+3 > screenwidth) {
			add_word(textlist,wordbuf);
			strcpy(wordbuf,"");
			}
		prev = a;
		}

	/* get text */
	finished = 0;
	prev = (appending ? 13 : (-1));
	strcpy(wordbuf,"");
	do {
		a=inkey();
		if (a==10) a=13;
		if (a==9) a=32;
		if (a==127) a=8;
		if ((a==32)&&(prev==13)) {
			add_word(textlist,"\n");
			add_newline(textlist);
			}
		if (a==8) {
			if (strlen(wordbuf)>0) {
				wordbuf[strlen(wordbuf)-1] = 0;
				putc(8,stdout);
				putc(32,stdout);
				putc(8,stdout);
				}
			}
		else if (a==13) {
			printf("\n");
			if (strlen(wordbuf)==0) finished = 1;
			else {
				for (b=0; b<strlen(wordbuf); ++b)
				   if (wordbuf[b]==32) {
					wordbuf[b]=0;
					add_word(textlist,wordbuf);
					strcpy(wordbuf,&wordbuf[b+1]);
					b=0;
					}
				add_word(textlist,wordbuf);
				strcpy(wordbuf,"");
				}
			}
		else {
			putc(a,stdout);
			wordbuf[strlen(wordbuf)+1] = 0;
			wordbuf[strlen(wordbuf)] = a;
			}
		if ((strlen(wordbuf)+3) > screenwidth) {
			last_space = (-1);
			for (b=0; b<strlen(wordbuf); ++b)
				if (wordbuf[b]==32) last_space = b;
			if (last_space>=0) {
				for (b=0; b<strlen(wordbuf); ++b)
				   if (wordbuf[b]==32) {
					wordbuf[b]=0;
					add_word(textlist,wordbuf);
					strcpy(wordbuf,&wordbuf[b+1]);
					b=0;
					}
				for (b=0; b<strlen(wordbuf); ++b) {
					putc(8,stdout);
					putc(32,stdout);
					putc(8,stdout);
					}
				printf("\n%s",wordbuf);
				}
			else {
				add_word(textlist,wordbuf);
				strcpy(wordbuf,"");
				printf("\n");
				}
			}
		prev = a;

		/* this check implements the server keep-alive */
		time(&now);
		if ( (now - last_server_msg) > S_KEEPALIVE ) {
			serv_puts("NOOP");
			serv_gets(buf);
			last_server_msg = now;
			}

		} while (finished==0);

	/* write the buffer back to disk */
	fseek(fp,base_pos,0);
	for (ptr=textlist; ptr!=NULL; ptr=ptr->next) {
		fprintf(fp,"%s",ptr->text);
		}
	putc(10,fp);
	putc(0,fp);

	/* and deallocate the memory we used */
	while (textlist!=NULL) {
		ptr=textlist->next;
		free(textlist);
		textlist=ptr;
		}
	}


int read_message(num,pagin)	/* Read a message from the server */
long num;			/* message number */
char pagin;	/* 0 = normal read, 1 = read with pagination, 2 = header */
{
	char buf[256];
	char m_subject[256];
	char from[256];
	long now;
	struct tm *tm;
	int format_type = 0;
	int fr = 0;
	int nhdr = 0;

	sigcaught = 0;
	sttybbs(1);

	sprintf(buf,"MSG0 %ld|%d",num,(pagin==READ_HEADER ? 1 : 0));
	serv_puts(buf);
	serv_gets(buf);
	if (buf[0]!='1') {
		printf("*** msg #%ld: %s\n",num,buf);
		++lines_printed;
		lines_printed = checkpagin(lines_printed,pagin,screenheight);
		sttybbs(0);
		return(0);
		}

	strcpy(m_subject,"");
	printf("\n");
	++lines_printed;
	lines_printed = checkpagin(lines_printed,pagin,screenheight);
	printf(" ");
	if (pagin == 1) color(3);

	if (pagin==2) {
		while(serv_gets(buf), strcmp(buf,"000")) {
			if (buf[4]=='=') {
				printf("%s\n",buf);
				++lines_printed;
				lines_printed = 
					checkpagin(lines_printed,
						pagin,screenheight);
				}
			}
		sttybbs(0);
		return(0);
		}

	strcpy(reply_to,"nobody...xxxxx");
	while(serv_gets(buf), struncmp(buf,"text",4)) {
		if (!struncmp(buf,"nhdr=yes",8)) nhdr=1;
		if (!struncmp(buf,"from=",5)) {
			strcpy(from,&buf[5]);
			}
		if (nhdr==1) buf[0]='_';
		if (!struncmp(buf,"type=",5))
			format_type=atoi(&buf[5]);
		if (!struncmp(buf,"from=",5)) {
			printf("from %s ",&buf[5]);
			}
		if (!struncmp(buf,"path=",5))
			strcpy(reply_to,&buf[5]);
		if (!struncmp(buf,"subj=",5))
			strcpy(m_subject,&buf[5]);
		if ((!struncmp(buf,"hnod=",5)) 
		   && (strucmp(&buf[5],serv_info.serv_humannode)))
			printf("(%s) ",&buf[5]);
		if ((!struncmp(buf,"room=",5))
		   && (strucmp(&buf[5],room_name)))
			printf("in %s> ",&buf[5]);

		if (!struncmp(buf,"node=",5)) {
			if ( (room_flags&QR_NETWORK)
			   || ((strucmp(&buf[5],serv_info.serv_nodename)
   			   &&(strucmp(&buf[5],serv_info.serv_fqdn)))))
				{
				printf("@%s ",&buf[5]);
				}
			if ((!strucmp(&buf[5],serv_info.serv_nodename))
   			   ||(!strucmp(&buf[5],serv_info.serv_fqdn)))
				{
				strcpy(reply_to,from);
				}
			else if (haschar(&buf[5],'.')==0) {
				sprintf(reply_to,"%s @ %s",from,&buf[5]);
				}
			}

		if (!struncmp(buf,"rcpt=",5))
			printf("to %s ",&buf[5]);
		if (!struncmp(buf,"time=",5)) {
			now=atol(&buf[5]);
			tm=(struct tm *)localtime(&now);
			strcpy(buf,asctime(tm)); buf[strlen(buf)-1]=0;
			strcpy(&buf[16],&buf[19]);
			printf("%s ",&buf[4]);
			}
		}

	if (nhdr==1) {
		if (!is_room_aide) {
			printf(" ****");
			}
		else {
			printf(" %s",from);
			}
		}
	printf("\n");
	if (pagin == 1 ) color(2);
	++lines_printed;
	lines_printed = checkpagin(lines_printed,pagin,screenheight);

	if (strlen(m_subject)>0) {
		printf("Subject: %s\n",m_subject);
		++lines_printed;
		lines_printed = checkpagin(lines_printed,pagin,screenheight);
		}

	if (format_type == 0) {
		fr=fmout(screenwidth,NULL,
			((pagin==1) ? 1 : 0),
			screenheight,(-1),1);
		}
	else {
		while(serv_gets(buf), strcmp(buf,"000")) {
			if (sigcaught==0) {
				printf("%s\n",buf);
				lines_printed = lines_printed + 1 +
					(strlen(buf)/screenwidth);
				lines_printed =
					checkpagin(lines_printed,pagin,screenheight);
				}
			}
		fr = sigcaught;
		}
	printf("\n");
	++lines_printed;
	lines_printed = checkpagin(lines_printed,pagin,screenheight);

	if (pagin == 1) color(7);
	sttybbs(0);
	return(fr);
	}

/*
 * replace string function for the built-in editor
 */
void replace_string(filename,startpos)
char *filename;
long startpos; {
	char buf[512];
	char srch_str[128];
	char rplc_str[128];
	FILE *fp;
	int a;
	long rpos,wpos;
	char *ptr;
	int substitutions = 0;
	long msglen = 0L;

	printf("Enter text to be replaced:\n: ");
	getline(srch_str,128);
	if (strlen(srch_str)==0) return;
	
	printf("Enter text to replace it with:\n: ");
	getline(rplc_str,128);

	fp=fopen(filename,"r+");
	if (fp==NULL) return;

	wpos=startpos;
	fseek(fp,startpos,0);
	strcpy(buf,"");
	while (a=getc(fp), a>0) {
		++msglen;
		buf[strlen(buf)+1] = 0;
		buf[strlen(buf)] = a;
		ptr=&buf[strlen(buf)-strlen(srch_str)];
		if (!struncmp(ptr,srch_str,strlen(srch_str))) {
			strcpy(ptr,rplc_str);
			++substitutions;
			}
		if (strlen(buf)>384) {
			rpos=ftell(fp);
			fseek(fp,wpos,0);
			fwrite((char *)buf,128,1,fp);
			strcpy(buf,&buf[128]);
			wpos = ftell(fp);
			fseek(fp,rpos,0);
			}
		}
	fseek(fp,wpos,0);
	if (strlen(buf)>0) fwrite((char *)buf,strlen(buf),1,fp);
	putc(0,fp);
	fclose(fp);
	printf("<R>eplace made %d substitution(s).\n\n",substitutions);
	}


int make_message(filename,recipient,anon_type,format_type,mode)
char filename[];	/* temporary file name */
char recipient[];	/* NULL if it's not mail */
int anon_type;		/* see MES_ types in header file */
int format_type;
int mode;
{ 
	FILE *fp;
	int a,b,e_ex_code;
	long now,beg;
	char datestr[64];
	int cksum = 0;

	if (mode==2) if (strlen(editor_path)==0) {
		printf("*** No editor available, using built-in editor\n");
		mode=0;
		}

	time(&now);
	strcpy(datestr,asctime(localtime(&now)));
	datestr[strlen(datestr)-1] = 0;

	if (room_flags & QR_ANONONLY) {
		printf(" ****");
		}
	else {
		printf(" %s from %s",datestr,fullname);
		if (strlen(recipient)>0) printf(" to %s",recipient);
		}
	printf("\n");

	beg = 0L;

	if (mode==1) printf("(Press ctrl-d when finished)\n");
	if (mode==0) {
		fp=fopen(filename,"r");
		if (fp!=NULL) {
			fmout(screenwidth,fp,0,screenheight,0,0);
			beg = ftell(fp);
			fclose(fp);
			}
		else {
			fp=fopen(filename,"w");
			fclose(fp);
			}
		}

ME1:	switch(mode) {

	   case 0:
		fp=fopen(filename,"r+");
		citedit(fp,beg);
		fclose(fp);
		goto MECR;
		break;

	   case 1:
		fp=fopen(filename,"w");
		do {
			a=inkey(); if (a==255) a=32;
			if (a==13) a=10;
			if (a!=4) {
				putc(a,fp);
				putc(a,stdout);
				}
			if (a==10) putc(13,stdout);
			} while(a!=4);
		fclose(fp);
		break;

	   case 2:
		e_ex_code = 1;	/* start with a failed exit code */
		editor_pid=fork();
		cksum = file_checksum(filename);
		if (editor_pid==0) {
			chmod(filename,0600);
			sttybbs(SB_RESTORE);
			execlp(editor_path,editor_path,filename,NULL);
			exit(1);
			}
		if (editor_pid>0) do {
			e_ex_code = 0;
			b=ka_wait(&e_ex_code);
			} while((b!=editor_pid)&&(b>=0));
		editor_pid = (-1);
		sttybbs(0);
		break;
		}

MECR:	if (mode==2) {
		if (file_checksum(filename) == cksum) {
			printf("*** Aborted message.\n");
			e_ex_code = 1;
			}
		if (e_ex_code==0) goto MEFIN;
		goto MEABT2;
		}
MECR1:	printf("Entry cmd (? for options) -> ");
MECR2:	b=inkey();
	if (b==NEXT_KEY) b='n';
	if (b==STOP_KEY) b='s';
	b=(b&127); b=tolower(b);
	if (b=='?') {
		printf("Help\n");
		formout("saveopt");
		goto MECR1;
		}
	if (b=='a') { printf("Abort\n");	goto MEABT;	}
	if (b=='c') { printf("Continue\n");	goto ME1;	}
	if (b=='s') { printf("Save message\n");	goto MEFIN;	} 
	if (b=='p') {
		printf("Print formatted\n");
		printf(" %s from %s",datestr,fullname);
		if (strlen(recipient)>0) printf(" to %s",recipient);
		printf("\n");
		fp=fopen(filename,"r");
		if (fp!=NULL) {
			fmout(screenwidth,fp,
				((userflags & US_PAGINATOR) ? 1 : 0),
				screenheight,0,0);
			beg = ftell(fp);
			fclose(fp);
			}
		goto MECR;
		}
	if (b=='r') {
		printf("Replace string\n");
		replace_string(filename,0L);
		goto MECR;
		}
	if (b=='h') {
		printf("Hold message\n");
		return(2);
		}
	goto MECR2;

MEFIN:	return(0);

MEABT:	printf("Are you sure? ");
	if (yesno()==0) goto ME1;
MEABT2:	unlink(filename);
	return(2);
	}

/*
 * transmit message text to the server
 */
void transmit_message(fp)
FILE *fp; {
	char buf[256];
	int ch,a;
	
	strcpy(buf,"");
	while (ch=getc(fp), (ch>=0)) {
		if (ch==10) {
			if (!strcmp(buf,"000")) strcpy(buf,">000");
			serv_puts(buf);
			strcpy(buf,"");
			}
		else {
			a = strlen(buf);
			buf[a+1] = 0;
			buf[a] = ch;
			if ((ch==32)&&(strlen(buf)>200)) {
				buf[a]=0;
				if (!strcmp(buf,"000")) strcpy(buf,">000");
				serv_puts(buf);
				strcpy(buf,"");
				}
			if (strlen(buf)>250) {
				if (!strcmp(buf,"000")) strcpy(buf,">000");
				serv_puts(buf);
				strcpy(buf,"");
				}
			}
		}
	serv_puts(buf);
	}



/*
 * entmsg()  -  edit and create a message
 *              returns 0 if message was saved
 */
int entmsg(is_reply,c)
int is_reply;		/* nonzero if this was a <R>eply command */
int c; {		/* */
	char buf[300];
	char cmd[256];
	int a,b;
	int need_recp = 0;
	int mode;
	long highmsg;
	FILE *fp;

	if (c>0) mode=1;
	else mode=0;

	sprintf(cmd,"ENT0 0||0|%d",mode);
	serv_puts(cmd);
	serv_gets(cmd);

	if ((strncmp(cmd,"570",3)) && (strncmp(cmd,"200",3))) {
		printf("%s\n",&cmd[4]);
		return(1);
		}
	need_recp = 0;
	if (!strncmp(cmd,"570",3)) need_recp = 1;

	if ((userflags & US_EXPERT) == 0) formout("entermsg");
		
	strcpy(buf,"");
	if (need_recp==1) {
		if (axlevel>=2) {
			if (is_reply) {
				strcpy(buf,reply_to);
				}
			else {
				printf("Enter recipient: ");
				getline(buf,299);
				if (strlen(buf)==0) return(1);
				}
			}
		else strcpy(buf,"sysop");
		}

	b=0;
	if (room_flags&QR_ANON2) {
		printf("Anonymous (Y/N)? ");
		if (yesno()==1) b=1;
		}

/* if it's mail, we've got to check the validity of the recipient... */
	if (strlen(buf)>0) {
		sprintf(cmd,"ENT0 0|%s|%d|%d",buf,b,mode);
		serv_puts(cmd);
		serv_gets(cmd);
		if (cmd[0]!='2') {
			printf("%s\n",&cmd[4]);
			return(1);
			}
		}

/* learn the number of the newest message in in the room, so we can tell
 * upon saving whether someone else has posted too
 */
	num_msgs = 0;
	serv_puts("MSGS LAST|1");
	serv_gets(cmd);
	if (cmd[0]!='1') {
		printf("%s\n",&cmd[5]);
		}
	else {
		while (serv_gets(cmd), strcmp(cmd,"000")) {
			msg_arr[num_msgs++] = atol(cmd);
			}
		}

/* now put together the message */
	a=make_message(temp,buf,b,0,c);
	if (a!=0) return(2);

/* and send it to the server */
	sprintf(cmd,"ENT0 1|%s|%d|%d",buf,b,mode);
	serv_puts(cmd);
	serv_gets(cmd);
	if (cmd[0]!='4') {
		printf("%s\n",&cmd[4]);
		return(1);
		}
	fp=fopen(temp,"r");
	if (fp!=NULL) {
		transmit_message(fp);
		fclose(fp);
		}
	serv_puts("000");
	unlink(temp);

	highmsg = msg_arr[num_msgs - 1];
	num_msgs = 0;
	serv_puts("MSGS NEW");
	serv_gets(cmd);
	if (cmd[0]!='1') {
		printf("%s\n",&cmd[5]);
		}
	else {
		while (serv_gets(cmd), strcmp(cmd,"000")) {
			msg_arr[num_msgs++] = atol(cmd);
			}
		}

	/* get new highest message number in room to set lrp for goto... */
	maxmsgnum = msg_arr[num_msgs - 1];

	/* now see if anyone else has posted in here */
	b=(-1);
	for (a=0; a<num_msgs; ++a) if (msg_arr[a]>highmsg) ++b;

	/* in the Mail> room, this algorithm always counts one message
	 * higher than in public rooms, so we decrement it by one */
	if (need_recp) --b;

	if (b==1) printf(
"*** 1 additional message has been entered in this room by another user.\n");
	if (b>1) printf(
"*** %d additional messages have been entered in this room by other users.\n",b);

	return(0);
	}

void process_quote() {	/* do editing on quoted file */
FILE *qfile,*tfile;
char buf[128];
int line,qstart,qend;

	qfile = fopen(temp2,"r");
	line = 0;
	fgets(buf,128,qfile);
	while (fgets(buf,128,qfile)!=NULL) {
		printf("%2d %s",++line,buf);
		}
	printf("Begin quoting at [ 1] : ");
	getline(buf,3);
	qstart = (buf[0]==0) ? (1) : atoi(buf);
	printf("  End quoting at [%d] : ",line);
	getline(buf,3);
	qend = (buf[0]==0) ? (line) : atoi(buf);
	rewind(qfile);
	line=0;
	fgets(buf,128,qfile);
	tfile=fopen(temp,"w");
	while(fgets(buf,128,qfile)!=NULL) {
		if ((++line>=qstart)&&(line<=qend)) fprintf(tfile," >%s",buf);
		}
	fprintf(tfile," \n");
	fclose(qfile);
	fclose(tfile);
	unlink(temp2);
	chmod(temp,0666);
	}


void readmsgs(c,rdir)	/* read contents of a room */
int c;		/* 0=Read all  1=Read new  2=Read old 3=Read last5 */
int rdir;	/* 1=Forward (-1)=Reverse */
	{
	int a,b,e,f,g,start;
	int hold_sw = 0;
	char arcflag = 0;
	char quotflag = 0;
	char prtfile[16];
	char pagin;
	char cmd[256];
	char targ[20];

	signal(SIGINT,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);

	if (c<0) b=(MSGSPERRM-1);
	else b=0;

	sprintf(prtfile,"/tmp/CPrt%d",getpid());

	num_msgs = 0;
	strcpy(cmd,"MSGS ");
	switch(c) {
		case 0:	strcat(cmd,"ALL");
			break;
		case 1:	strcat(cmd,"NEW");
			break;
		case 2:	strcat(cmd,"OLD");
			break;
		case 3:	strcat(cmd,"LAST|5");
			break;
		}
	serv_puts(cmd);
	serv_gets(cmd);
	if (cmd[0]!='1') {
		printf("%s\n",&cmd[5]);
		}
	else {
		while (serv_gets(cmd), strcmp(cmd,"000")) {
			msg_arr[num_msgs++] = atol(cmd);
			}
		}

	lines_printed = 0;

	/* this loop cycles through each message... */
	start = ( (rdir==1) ? 0 : (num_msgs-1) );
	for (a=start; ((a<num_msgs)&&(a>=0)); a=a+rdir) {
		while (msg_arr[a]==0L) {
			a=a+rdir; if ((a==MSGSPERRM)||(a==(-1))) return;
			}

RAGAIN:		pagin=((arcflag==0)&&(quotflag==0)&&
			(userflags & US_PAGINATOR)) ? 1 : 0;

	/* if we're doing a quote, set the screenwidth to 72 temporarily */
		if (quotflag) {
			hold_sw = screenwidth;
			screenwidth = 72;
			}

	/* now read the message... */
		e=read_message(msg_arr[a],pagin);

	/* ...and set the screenwidth back if we have to */
		if (quotflag) {
			screenwidth = hold_sw;
			}
RMSGREAD:	fflush(stdout);
		highest_msg_read = msg_arr[a];
		if (quotflag) {
			freopen("/dev/tty","r+",stdout);
			quotflag=0;
			process_quote();
			}
		if (arcflag) {
			freopen("/dev/tty","r+",stdout);
			arcflag=0;
			f=fork();
			if (f==0) {
				freopen(prtfile,"r",stdin);
				sttybbs(SB_RESTORE);
				ka_system(printcmd);
				sttybbs(SB_NO_INTR);
				unlink(prtfile);
				exit(0);
				}
			if (f>0) do {
				g=wait(NULL);
				} while((g!=f)&&(g>=0));
			printf("Message printed.\n");
			}
		if (e==3) return;
		if ((userflags&US_NOPROMPT)||(e==2)) e='n';
		else {
			printf("(%d) ",num_msgs-a-1);
			if (is_mail==1) printf("<R>eply ");
			if (strlen(printcmd)>0) printf("<P>rint ");
		printf("<B>ack <A>gain <Q>uote <H>eader <N>ext <S>top -> ");
			do {
				lines_printed = 2;
				e=(inkey()&127); e=tolower(e);
/* return key same as <N> */ 	if (e==13) e='n';
/* del/move for aides only */	if (!is_room_aide) if ((e=='d')||(e=='m')) e=0;
/* print only if available */	if ((e=='p')&&(strlen(printcmd)==0)) e=0;
/* can't move from Mail> */	if ((e=='m')&&(is_mail==1)) e=0;
/* can't reply in public rms */	if ((e=='r')&&(is_mail!=1)) e=0;
				} while((e!='a')&&(e!='n')&&(e!='s')
					&&(e!='d')&&(e!='m')&&(e!='p')
					&&(e!='q')&&(e!='b')&&(e!='h')
					&&(e!='r'));
			switch(e) {
				case 's':	printf("Stop\r");	break;
				case 'a':	printf("Again\r");	break;
				case 'd':	printf("Delete\r");	break;
				case 'm':	printf("Move\r");	break;
				case 'n':	printf("Next\r");	break;
				case 'p':	printf("Print\r");	break;
				case 'q':	printf("Quote\r");	break;
				case 'b':	printf("Back\r");	break;
				case 'h':	printf("Header\r");	break;
				case 'r':	printf("Reply\r");	break;
				}
			if (userflags & US_DISAPPEAR)
				printf("%75s\r","");
			else
				printf("\n");
			fflush(stdout);
			}
		switch(e) {
		   case 'p':	fflush(stdout);
				freopen(prtfile,"w",stdout);
				arcflag = 1;
				goto RAGAIN;
		   case 'q':	fflush(stdout);
				freopen(temp2,"w",stdout);
				quotflag = 1;
				goto RAGAIN;
		   case 's':	return;
		   case 'a':	goto RAGAIN;
		   case 'b':	a=a-(rdir*2);
				break;
		   case 'm':	newprompt("Enter target room: ",targ,19);
				if (strlen(targ)>0) {
					sprintf(cmd,"MOVE %ld|%s",
						msg_arr[a],targ);
					serv_puts(cmd);
					serv_gets(cmd);
					printf("%s\n",&cmd[4]);
					if (cmd[0]=='2') msg_arr[a]=0L;
					}
				else {
					goto RMSGREAD;
					}
				if (cmd[0]!='2') goto RMSGREAD;
				break;
		   case 'd':	printf("*** Delete this message? ");
				if (yesno()==1) {
					sprintf(cmd,"DELE %ld",msg_arr[a]);
					serv_puts(cmd);
					serv_gets(cmd);
					printf("%s\n",&cmd[4]);
					if (cmd[0]=='2') msg_arr[a]=0L;
					}
				else {
					goto RMSGREAD;
					}
				break;
		   case 'h':	read_message(msg_arr[a],READ_HEADER);
				goto RMSGREAD;
		   case 'r':	entmsg(1,(DEFAULT_ENTRY==46 ? 2 : 0));
				goto RMSGREAD;
			}
		} /* end for loop */
	} /* end read routine */
