#! /bin/sh

# This is the configuration script for the Citadel/UX Makefile.  Do not attempt
# to edit any of this stuff yourself unless you really know what you are doing!

CC=$1
UNAME=`uname`

echo -------- Now generating the sysdep.h header for your system. --------

cat >sysdep.h <<!
/*
 * sysdep.h - system dependent definitions
 *
 * THIS FILE IS GENERATED BY configure.sh WHEN THE MAKEFILE IS RUN.
 * DO NOT EDIT THIS FILE BY HAND!!
 *
 */

!



##############################################################################
#                                                                            #
#                  Test to see if we have the syslog facility                #
#                                                                            #
##############################################################################

echo
echo Testing to see if you have the syslog facility available...
cat >testing.c <<!

#include <syslog.h>

main() {
	openlog("logtester",0,LOG_USER);
	syslog(LOG_NOTICE,"hi there!");
	closelog();
	}
!

if $CC testing.c -o testing 2>/dev/null; then
	echo ...syslog available.
	echo "#define USE_SYSLOG" >>sysdep.h
else
	echo ...not available.
fi
rm -f testing testing.o testing.c >/dev/null 2>&1



##############################################################################
#                                                                            #
#                  Test to see if we have the flock() system call            #
#                                                                            #
##############################################################################

echo
echo Testing for flock system call...
cat >testing.c <<!


#include <stdio.h>
#include <fcntl.h>
#include <sys/file.h>

main() {
	int mms_fd;
	int a;

	a=flock(mms_fd,LOCK_EX);
	a=flock(mms_fd,LOCK_UN);
	exit(0);
	}


!

if $CC testing.c -o testing 2>/dev/null; then
	echo ...flock available.
	echo "#define HAVE_FLOCK" >>sysdep.h
else
	echo ...not available.
fi
rm -f testing testing.o testing.c >/dev/null 2>&1



##############################################################################
#                                                                            #
#                  Test for SystemV-like curses features                     #
#                                                                            #
##############################################################################

echo
echo Testing for SystemV-like curses features...
cat >testing.c <<!



#include <stdio.h>
#include <ctype.h>
#include <curses.h>

main() {
	int key;
	WINDOW *selwin;

	initscr();
	raw();
	noecho();
	intrflush(stdscr,FALSE);
	keypad(stdscr,TRUE);
	idlok(stdscr,FALSE);

	clear();
	selwin = newwin(4,0,13,80);
	box(selwin,0,0);
	refresh();
	move(4,0);	addch(ACS_ULCORNER);
	move(4,79);	addch(ACS_URCORNER);
	move(17,0);	addch(ACS_LLCORNER);
	move(17,79);	addch(ACS_LRCORNER);
	move(4,1);	addch(ACS_HLINE);
	move(17,1);	addch(ACS_HLINE);
	move(1,0);	addch(ACS_VLINE);
	move(1,79);	addch(ACS_VLINE);
	refresh();

	standout();
	standend();

	key = wgetch(stdscr);
	if (key=='-')	key = KEY_UP;
	if (key=='+')	key = KEY_DOWN;
	if (key==1)	key = KEY_F(1);
	if (key==2)	key = KEY_PPAGE;
	if (key==6)	key = KEY_NPAGE;

	clearok(stdscr,TRUE);
	clearok(stdscr,FALSE);
	clear();
	refresh();
	endwin();
	exit(0);
	}


!

if $CC testing.c -o testing 2>/dev/null; then
	echo ...advanced features are available.
	echo "#define ADVANCED_CURSES" >>sysdep.h
else
	echo ...not available.
fi
rm -f testing testing.o testing.c >/dev/null 2>&1



##############################################################################
#                                                                            #
#              Test to see if we have the /proc filesystem                   #
#                                                                            #
##############################################################################

echo
echo Testing for /proc filesystem...
cat >testing.c <<!

#include <stdio.h>

main(argc,argv)
int argc;
char *argv[]; {
	FILE *pr;
	char buf[256];

	sprintf(buf,"/proc/%d/cmdline",getpid());
	pr = fopen(buf,"r");
	if (pr==NULL) exit(1);
	if (fgets(buf,256,pr)==NULL) exit(2);
	fclose(pr);
	if (strcmp(buf,argv[0])) exit(3);
	exit(0);
	}

!

$CC testing.c -o testing 2>/dev/null
if ./testing; then
	echo ...this system has it.
	echo "#define HAVE_PROC_FS" >>sysdep.h
else
	echo ...not available.
fi
rm -f testing testing.o testing.c >/dev/null 2>&1

##############################################################################
#                                                                            #
#              Test to see if we have strerror                               #
#                                                                            #
##############################################################################

echo
echo Checking for strerror function
cat >testing.c <<!

#include <string.h>
#include <errno.h>

main() {
	printf("%s\n",strerror(1));
	}

!

$CC testing.c -o testing 2>/dev/null
if $CC testing.c -o testing 2>/dev/null; then
	echo This system has it.
else
	echo This system does not have it - using a substitute
	echo "#define NO_STRERROR" >>sysdep.h
fi
rm -f testing testing.o testing.c >/dev/null 2>&1



##############################################################################
#                                                                            #
#              Test to see if we have gethostbyaddr()                        #
#                                                                            #
##############################################################################

echo
echo Checking for gethostbyaddr etc.
cat >testing.c <<!

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>

void main() {
	struct sockaddr_in      cs;     
	struct hostent      *   ch;        
	int                     len;     
	int			a;
	char *i;
    len = sizeof(cs);   
    if (getpeername(0,(struct sockaddr *)&cs,&len) < 0) {   
	return;
	}
    if((ch = gethostbyaddr((char *) &cs.sin_addr, sizeof(cs.sin_addr),  
	  AF_INET)) == NULL) { 
		return;
		}
	}

!

$CC testing.c -o testing 2>/dev/null
if $CC testing.c -o testing 2>/dev/null; then
	echo This system has these functions available.
	echo "#define HOST_OK" >>sysdep.h
else
	echo Not available ... assuming all connections are local.
fi
rm -f testing testing.o testing.c >/dev/null 2>&1



##############################################################################
#                                                                            #
#              Test to see if we have POSIX termio                           #
#                                                                            #
##############################################################################

echo
echo Checking for POSIX or BSD termio...
cat >testing.c <<!

#include <termios.h>

main() {
	exit(0);
	}

!

$CC testing.c -o testing 2>/dev/null
if $CC testing.c -o testing 2>/dev/null; then
	[ $UNAME != "SunOS" ] && {
		echo This system has POSIX termio.
		echo "#define POSIX_TERMIO" >>sysdep.h
		}
else
	echo This system has BSD style sgtty.h
fi
rm -f testing testing.o testing.c >/dev/null 2>&1


##############################################################################
#                                                                            #
#              Test to see if we need select.h                               #
#                                                                            #
##############################################################################

echo
echo Checking to see whether select requires select.h
cat >testing.c <<!

#include <sys/select.h>

main() {
	exit(0);
	}

!

$CC testing.c -o testing 2>/dev/null
if $CC testing.c -o testing 2>/dev/null; then
	echo This system has select.h
	echo "#define NEED_SELECT_H" >>sysdep.h
else
	echo Not required on this system.
fi
rm -f testing testing.o testing.c >/dev/null 2>&1


##############################################################################
#                                                                            #
#           Generate an internal program password for this system            #
#                                                                            #
##############################################################################

echo
echo Generating an internal program password for this system
echo

cat >testing.c <<!
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>

void main() {
	long now;

	time(&now);

	printf("#define SYSPGMPW %c%ld%d%c\n", 34, now, getpid(), 34);
	exit(0);
	}
!

$CC testing.c -o testing 2>/dev/null
./testing >>sysdep.h
rm -f testing testing.o testing.c >/dev/null 2>&1


##############################################################################
#                                                                            #
#           Do we create named pipes with mknod or mkfifo?                   #
#                                                                            #
##############################################################################

echo
echo Checking whether this system has named pipes and how to make them...
echo
if mkfifo /tmp/citconf$$ 2>/dev/null; then
	echo This system has a mkfifo command.
	echo "#define USE_MKFIFO" >>sysdep.h
else
	echo This system does not have mkfifo, trying mknod...

	if mknod /tmp/citconf$$ p 2>/dev/null; then
		echo This system supports creating pipes with mknod.
		echo "#define USE_MKNOD" >>sysdep.h
		else
			echo This system does not have named pipes.
		fi
	fi
rm -f /tmp/citconf$$ 2>/dev/null
