/* citadel.h
 * main Citadel/UX header file
 * see copyright.doc for copyright information
 */

/* system customizations are in sysconfig.h */
#include "sysdep.h"
#include "sysconfig.h"
#include "ipcdef.h"
#define CITADEL	"Text client 4.11.3"
#define REV_LEVEL 411
#define SERVER_TYPE 0	/* zero for stock Citadel/UX; other developers please
			   obtain SERVER_TYPE codes for your implementations */

#undef	tolower
#define tolower(x)	( ((x>='A')&&(x<='Z')) ? (x+'a'-'A') : x )
#define strucmp(lstr,rstr) struncmp(lstr,rstr,32767)
#define NEW_CONFIG

/* 
 * The only typedef we do is an 8-bit unsigned, for screen dimensions.
 * All other defs are done using standard C types.  The code assumes that
 * 'int' 'unsigned' and 'short' are at least 16 bits, and that 'long' is at
 * least 32 bits.  There are no endian dependencies in any of the Citadel
 * programs.
 */
typedef unsigned char CIT_UBYTE;

struct config {
	char c_nodename[16];		/* UUCP and Citadel nodename        */
	char c_fqdn[64];		/* Fully Qualified Domain Name      */
	char c_humannode[21];		/* Long name of system              */
	char c_phonenum[16];		/* Dialup number of system          */
	int c_bbsuid;			/* UID of the bbs-only user         */
	int c_pwcrypt;			/* password encryption seed         */
	char c_creataide;		/* room creator = room aide  flag   */
	int c_sleeping;			/* watchdog timer setting           */
	char c_initax;			/* initial access level             */
	char c_regiscall;		/* call number to register on       */
	char c_twitdetect;		/* twit detect flag                 */
	char c_twitroom[20];		/* twit detect msg move to room     */
	int c_defent;			/* command generated by <E> key     */
	char c_moreprompt[80];		/* paginator prompt                 */
	char c_restrict;		/* restrict Internet mail flag      */
	long c_msgbase;			/* size of message base             */
	char c_bbs_city[32];		/* city and state you are located in*/
	char c_sysadm[26];		/* name of system administrator     */
	char c_bucket_dir[15];		/* bit bucket for files...	    */
	int c_setup_level;		/* what rev level we've setup to    */
	int c_maxsessions;		/* maximum concurrent sessions      */
	char c_net_password[20];	/* system net password */
	};

#define NODENAME		config.c_nodename
#define FQDN			config.c_fqdn
#define HUMANNODE		config.c_humannode
#define PHONENUM		config.c_phonenum
#define BBSUID			config.c_bbsuid
#define PWCRYPT			config.c_pwcrypt
#define CREATAIDE		config.c_creataide
#define INITAX			config.c_initax
#define REGISCALL		config.c_regiscall
#define TWITDETECT		config.c_twitdetect
#define TWITROOM		config.c_twitroom
#define MORE_PROMPT		config.c_moreprompt
#define RESTRICT_INTERNET	config.c_restrict
#define MM_FILELEN		config.c_msgbase

struct citsession {
	int cs_pid;			/* process ID of citserver */
	char cs_name[26];		/* name of user */
	char cs_room[20];		/* current room */
	long cs_lastupdt;		/* time of last update */
	int cs_clientdev;		/* client developer ID */
	int cs_clienttyp;		/* client type code */
	int cs_clientver;		/* client version number */
	char cs_clientname[32];		/* name of client software */
	char cs_host[25];		/* host logged in from */
	unsigned cs_flags;		/* flags */
	};

#define CS_STEALTH	1		/* stealth mode */
#define CS_CHAT		2		/* chat mode */

struct usersupp {			/* User record                      */
	int USuid;			/* userid (==BBSUID for bbs only)   */
	char password[20];		/* password (for BBS-only users)    */
	long lastseen[MAXROOMS];	/* Last message seen in each room   */
	char generation[MAXROOMS];	/* Generation # (for private rooms) */
	char forget[MAXROOMS];		/* Forgotten generation number      */
	long mailnum[MAILSLOTS];	/* Message #'s of each mail message */
	long mailpos[MAILSLOTS];	/* Disk positions of each mail      */
	unsigned flags;			/* See US_ flags below              */
	int timescalled;		/* Total number of logins           */
	int posted;			/* Number of messages posted (ever) */
	char fullname[26];		/* Name for Citadel messages & mail */
	char axlevel;			/* Access level                     */
	CIT_UBYTE USscreenwidth;	/* Screen width                     */
	CIT_UBYTE USscreenheight;	/* Screen height                    */
	char spare[1];			/* spare bytes in the user account  */
	long eternal;			/* Eternal (non-recycled) user num  */
	long lastcall;			/* Last time the user called        */
	char USname[30];		/* Real name (i.e. not a handle)    */
	char USaddr[25];		/* Street address                   */
	char UScity[15];		/* Municipality                     */
	char USstate[3];		/* State or province                */
	char USzip[10];			/* ZIP code                         */
	char USphone[11];		/* Voice telephone number           */
	char USemail[32];		/* E-mail address (elsewhere)       */
	int logged_time;		/* (Not yet implemented)            */
	int time_limit;			/* (Not yet implemented)            */
	};


/* this is a mask for all of the bits the user is allowed to change */
#define US_USER_SET	(US_LASTOLD | US_EXPERT | US_UNLISTED | \
			US_NOPROMPT | US_DISAPPEAR | US_PAGINATOR | US_FLOORS)
/****************************************************************************/

struct msgmain {
	long MMlowest;			/* lowest message number in file    */
	long MMhighest;			/* highest message number in file   */
	long MMcurpos;			/* Current position in file         */
	unsigned MMflags;		/* Global system flags              */
	};

#define MM_BUSY		1		/* Another process is using file    */
#define MM_VALID	4		/* New users need validating        */

/****************************************************************************/

struct smreturn {			/* Return from the send_message()   */
	long smnumber;			/* Message number (if sent)	    */
	long smpos;			/* Position in file (if sent)       */
	int smerror;			/* Error code                       */
	};

/****************************************************************************/

struct quickroom {
	char QRname[20];		/* Max. len is 19, plus null term   */
	char QRpasswd[10];		/* Only valid if it's a private rm  */
	long QRroomaide;		/* User number of room aide         */
	long QRhighest;			/* Highest message NUMBER in room   */
	char QRgen;			/* Generation number of room        */
	unsigned QRflags;		/* See flag values below            */
	char QRdirname[15];		/* Directory name, if applicable    */
	long QRinfo;			/* Info file update relative to msgs*/
	char QRfloor;			/* Which floor this room is on      */
	};


/* Private rooms are always flagged with QR_PRIVATE. If neither QR_PASSWORDED
 * or QR_GUESSNAME is set, then it is invitation-only. Passworded rooms are
 * flagged with both QR_PRIVATE and QR_PASSWORDED while guess-name rooms are
 * flagged with both QR_PRIVATE and QR_GUESSNAME. DO NOT set all three flags.
 */
/****************************************************************************/

struct fullroom {
	long FRnum[MSGSPERRM];		/* Message NUMBERS		    */
	long FRpos[MSGSPERRM];		/* Message POSITIONS in master file */
		};

/* This structure is not 'circular'. When scrolling, each message moves
 * down a slot, and the oldest one falls off the bottom. A null message is 
 * represented by the value 0L in both fields.
 */

struct calllog {
	char CLfullname[30];		/* Name of user                     */
	long CLtime;			/* Date/time of record              */
	unsigned CLflags;		/* Info on record		    */
	};

#define CL_INOTHER	8		/* Connect to server                */
#define CL_LOGIN	16		/* CLfullname logged in		    */
#define CL_NEWUSER	32		/* CLfullname is a new user	    */
#define CL_BADPW	64		/* Bad attempt at CLfullname's pw   */
#define CL_TERMINATE	128		/* Logout - proper termination	    */
#define CL_DROPCARR	256		/* Logout - dropped carrier	    */
#define CL_SLEEPING	512		/* Logout - sleeping		    */
#define CL_PWCHANGE	1024		/* CLfullname changed passwords     */

/* Miscellaneous                                                            */

#define MES_NORMAL	65		/* Normal message                   */
#define MES_ANON	66		/* "****" header                    */
#define MES_AN2		67		/* "Anonymous" header               */

#define M_ERROR		(-1)	/* Can't send message due to bad address   */
#define M_LOCAL		0	/* Local message, do no network processing */
#define M_UUCP		1	/* Convert msg and send as Internet mail   */
#define M_BINARY	2	/* Process recipient and send via C/UX net */

/****************************************************************************/

struct recentmsg {
	char RMnodename[10];
	long RMnum;			/* Number or time of message        */
	};

/*
 * Floor record.  The floor number is implicit in its location in the file.
 */
struct floor {
	unsigned short f_flags;		/* flags */
	char f_name[256];		/* name of floor */
	int f_ref_count;		/* reference count */
	int f_reserved;			/* for future use */
	};

#define F_INUSE		1		/* floor is in use */


#define NEWREGISTER	0		/* new user to register */
#define REREGISTER	1		/* existing user reregistering */

#define READ_HEADER	2
#define READ_MSGBODY	3

/* commands we can send to the sttybbs() routine */
#define SB_NO_INTR	0		/* set to bbs mode, i/q disabled */
#define SB_YES_INTR	1		/* set to bbs mode, i/q enabled */
#define SB_SAVE		2		/* save settings */
#define SB_RESTORE	3		/* restore settings */

#define	NEXT_KEY	15
#define STOP_KEY	3

/* server exit codes */
#define EXIT_NORMAL	0		/* server terminated normally */
					/* 1 through 63 reserved for signals */
#define EXIT_NULL	64		/* EOF on server command input */

/* citadel.rc stuff */
#define RC_NO		0		/* always no */
#define RC_YES		1		/* always yes */
#define RC_DEFAULT	2		/* setting depends on user config */

/* keepalives */
#define KA_NO		0		/* no keepalives */
#define KA_YES		1		/* full keepalives */
#define KA_CHAT		2		/* half keepalives (for chat mode) */

/* for <;G>oto and <;S>kip commands */
#define GF_GOTO		0		/* <;G>oto floor mode */
#define GF_SKIP		1		/* <;S>kip floor mode */
#define GF_ZAP		2		/* <;Z>ap floor mode */

/* message transfer formats */
#define MT_CITADEL	0		/* Citadel proprietary */
#define MT_RFC822	2		/* RFC822 */
