/*
version: $Id: get_comm.c,v 5.123 1995/01/18 01:24:58 hitman Exp $
purpose: Get the commands needed from the user.
updates: All updates are handled by RCS
*/

#include <stdio.h>

#ifndef __MSDOS__
#	include "hsh_glob.h"
#	include "hshgen_s.h"
#else				/* not_MSDOS */
#	include "..\src\hsh_glob.h"
#	include "..\src\hshgen_s.h"
#endif				/* MSDOS */

/********************************************************************/
/* Define functions and procedures.                                 */
int             get_command(_character * Character);

int
get_command(_character * Character)
{
#ifdef DEBUG
	fprintf(stderr, "** %s(%d): **\n", __FILE__, __LINE__);
#endif				/* DEBUG */
	/* Get some input from the user. */
	if ((gets(Character->input_string)) == NULL)
	{
#ifdef DEBUG
		fprintf(stderr, "** %s(%d): Found a null returning. **\n", __FILE__, __LINE__);
		fprintf(stderr, "** %s(%d): Character->input_string = %s **\n", __FILE__, __LINE__, Character->input_string);
#endif				/* DEBUG */
		return (RET_ERROR1);
	}			/* if_NULL_command */
	/* check for no input at all, just a carriage return */
	if (strcmp(Character->input_string, "") == 0)
	{
#ifdef DEBUG
		fprintf(stderr, "** %s(%d): Found just a carriage return. **\n", __FILE__, __LINE__);
		fprintf(stderr, "** %s(%d): Character->input_string = %s **\n", __FILE__, __LINE__, Character->input_string);
#endif				/* DEBUG */
		return (RET_ERROR1);
	}			/* if_return_command */
	/* do some checking for NULL commands */
#ifdef DEBUG
	fprintf(stderr, "** %s: Character->input_string = %s **\n",
		__FILE__, Character->input_string);
#endif				/* DEBUG */
	return (RET_NORMAL);
}				/* get_command */
