// xfiles - synchronize and cross-validate directory trees across a network
// Copyright (C) 1999  j.p.lewis  
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Primary author contact info: www.idiom.com/~zilla  zilla@computer.org

import XfilesClient.*;

import org.python.util.PythonInterpreter; 
import org.python.core.*; 


final class XfilesScript
{

  static PythonInterpreter gInterp	= null;
  static PyObject	gPathFilter	= null;
  static PyObject	gPreCopy	= null;
  static PyObject	gPostCopy	= null;

  //----------------------------------------------------------------

  static void scriptSetup() 
  {
    String configFile = "xfiles";   /* .py */

    // try to load python.jar
    try {
      Class c = Class.forName("org.python.util.PythonInterpreter");
      gInterp = (PythonInterpreter)c.newInstance();
      System.err.println("found python, scripting available.");
    }
    catch (Exception ex) {
      System.err.println(ex);
      System.out.println("did not find python, scripting not available.");
      gInterp = null;
      return;
    }

    // try to load xfiles.py
    try {
      System.err.println("ginterp = " + gInterp);
      gInterp.exec("import sys");
      gInterp.exec("import " + configFile);
    }
    catch (Exception ex) {
      System.err.println("xfiles.py does not exist or contains error.");
      System.err.println(ex);
    }

    // try to bind pathFilter
    try {
      gPathFilter = gInterp.eval("xfiles.pathFilter");
    }
    catch (Exception ex) {
      System.err.println("xfiles.py does not define pathFilter()");
      System.err.println(ex);
      gPathFilter = null;
    }

    // try to bind preCopy
    try {
      gPreCopy = gInterp.eval("xfiles.preCopy");
    }
    catch (Exception ex) {
      System.err.println("xfiles.py does not define preCopy()");
      gPreCopy = null;
    }

    // try to bind postCopy
    try {
      gPostCopy = gInterp.eval("xfiles.postCopy");
    }
    catch (Exception ex) {
      System.err.println("xfiles.py does not define postCopy()");
      gPostCopy = null;
    }
  } //scriptSetup

  //----------------------------------------------------------------

  /**
   * Filter out some files based on their extension (e.g. .o files).
   * Returns false if the file should be skipped.
   */
  public static final boolean pathFilter(Cfile cfile)
  {
    if (gPathFilter == null)
      return true;
    else {
      try {
        PyObject x = gPathFilter.__call__(Py.newString(cfile.lpath));
	PyInteger i = x.__int__();
	if (i.getValue() == 1)
	  return true;
	else
	  return false;
      }
      // syntax error, exit now 
      catch(Exception ex) {
	XfilesGui.showAlert("call of xfiles.py: pathFiler failed:\n" +
			    ex.getMessage());
	System.exit(1);
      }
    }

    return false;	// satisfy compiler
  } //pathFilter

  //----------------------------------------------------------------


  static void preCopyScript(String path)
  {
    if (gPreCopy != null) {
      try {
	gPreCopy.__call__(Py.newString(path));
      }
      catch(Exception ex) {
	XfilesGui.showAlert("call of xfiles.py: preCopy failed:\n" +
			    ex.getMessage());
	System.exit(1);
      }
    }
  } //preCopyScript

  //----------------------------------------------------------------

  static void postCopyScript(String path)
  {
    if (gPostCopy != null) {
      try {
	gPostCopy.__call__(Py.newString(path));
      }
      catch(Exception ex) {
	XfilesGui.showAlert("call of xfiles.py: postCopy failed:\n" +
			    ex.getMessage());
	System.exit(1);
      }
    }
  }

} //XfilesScript
