# xfiles.py can define the following functions:
#
# - pathFilter(path) 
#   should return 1 if Xfiles should process path, 0 if Xfiles should
#   ignore it
# - preCopy(path)
#   this function is called before Xfiles writes this file.
#   it can be used to check out the file from RCS
# - postCopy(path)
#   this function is called after Xfiles writes the file.
#   it can be used to check the file into RCS.
#
# It is not necessary to define all of these functions.
# If a function is defined and generates an error when
# called the error will be reported and Xfiles will quit.

import java
from java.io import File
import java.lang.Runtime
runtime = java.lang.Runtime.getRuntime()

# ignore files with these extensions
skipextensions = ['RCS', ',v', '.o', '.so', '.a', '.class', '.jar']

# return 1 if xfiles should visit this path, else 0
#
def pathFilter(path):
  print 'pathFilter(%s)' % path
  if path[len(path)-1] == '~':		# emacs backup file
    return 0			
  if path == 'so_locations':
    return 0
  spath = java.lang.String(path)
  for ext in skipextensions:
    if spath.endsWith(ext):
      return 0
  return 1

# called before copying over a file
# (check out from RCS if appropriate)
#
def preCopy(path):
  name = filename(path)
  spath = filedir(path)
  spath = spath + '/RCS/'
  print 'name = %s' % name
  if exists(spath):			# RCS/ exists
    spath = spath + name + ',v'
    print 'spath = %s' % spath
    if exists(spath):			# RCS/file,v exists
      docmd('co -l -f %s' % path)


# called after copying over a file
# (check in to RCS if appropriate)
#
def postCopy(path):
  name = filename(path)
  spath = filedir(path)
  spath = spath + '/RCS/'
  print 'name = %s' % name
  if exists(spath):			# RCS/ exists
    spath = spath + name + ',v'
    print 'spath = %s' % spath
    if exists(spath):			# RCS/file,v exists
      docmd('ci -u -f -mXfiles_copy_checkin %s' % path)


# after checking out we will immediately try to write,
# so must wait for the checkout to complete
def docmd(cmd):
  if 1:
    print cmd
  pid = runtime.exec_(cmd)
  pid.waitFor()

def filedir(path):
    result = File(path).getParent()
    if not result:
        if isabs(path):
            result = path # Must be root
        else:
            result = ""
    return result

def filename(path):
    return File(path).getName()

def exists(path):
    return File(path).exists()

def isabs(path):
    return File(path).isAbsolute()
