/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

class Xfiletree
extends DefaultMutableTreeNode {
    static final boolean gDebug = false;
    Xfiletree parent;
    File file;
    boolean isDir;
    Xfiletree[] children;
    boolean isLink;
    Object userObject;
    static boolean nativeLoaded;
    static boolean haveNative;
    static nativeFileInterface nativeFile;

    private static void loadNative() {
        nativeLoaded = true;
        try {
            Class<?> clazz = Class.forName("nativeFile");
            nativeFileInterface cfr_ignored_0 = (nativeFileInterface)clazz.newInstance();
            haveNative = true;
            System.out.println("using nativeFile");
            return;
        }
        catch (Exception exception) {
            System.out.println("using portable link detection");
            return;
        }
    }

    private boolean computeIsLink() {
        try {
            if (haveNative && nativeFile != null) {
                return nativeFile.isLink(this.file.getPath());
            }
            return XfilesCommon.isLink(this.file);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            return false;
        }
    }

    public Xfiletree(Xfiletree xfiletree, String string, boolean bl, boolean bl2) throws IOException {
        System.out.println("new Xfiletree: " + string + " " + bl);
        if (!nativeLoaded) {
            Xfiletree.loadNative();
        }
        this.userObject = null;
        this.parent = xfiletree;
        this.file = new File(string);
        XfilesCommon.assert(this.file != null);
        this.isLink = this.computeIsLink();
        boolean bl3 = this.isDir = this.file.isDirectory() && !this.isLink;
        if (bl2) {
            guiCB guiCB2 = new guiCB(xfiletree, this);
            SwingUtilities.invokeLater(guiCB2);
        }
        if (bl && this.isDir) {
            this.createChildren(bl, bl2);
        }
    }

    public String toString() {
        if (this.file != null) {
            String string = this.file.getName();
            if (this.isLink) {
                if (this.isDir) {
                    string = String.valueOf(string) + "/";
                }
                string = String.valueOf(string) + "@";
            }
            return string;
        }
        return "---";
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public boolean getAllowsChildren() {
        return this.isDir;
    }

    Xfiletree[] createChildren(boolean bl, boolean bl2) {
        try {
            String[] stringArray = this.file.list();
            if (stringArray != null) {
                this.children = new Xfiletree[stringArray.length];
                String string = this.file.getPath();
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = String.valueOf(string) + "/" + stringArray[n];
                    this.children[n] = new Xfiletree(this, string2, bl, bl2);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
        return this.children;
    }

    public void deleteChild(Xfiletree xfiletree) {
        if (this.children != null) {
            int n = this.children.length;
            if (n == 0) {
                this.children = null;
                return;
            }
            int n2 = n - 1;
            Xfiletree[] xfiletreeArray = new Xfiletree[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (this.children[n4] != xfiletree) {
                    xfiletreeArray[n3++] = this.children[n4];
                }
                ++n4;
            }
            this.children = xfiletreeArray;
        }
    }

    public void traverse(traverseCB traverseCB2) throws Exception {
        if (this.isLink) {
            return;
        }
        if (traverseCB2.cb(this) && this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].traverse(traverseCB2);
                ++n;
            }
        }
    }

    static {
        nativeFile = null;
    }

    static class guiCB
    implements Runnable {
        Xfiletree parent;
        Xfiletree child;

        guiCB(Xfiletree xfiletree, Xfiletree xfiletree2) {
            this.parent = xfiletree;
            this.child = xfiletree2;
        }

        public void run() {
            if (this.parent != null) {
                this.parent.add(this.child);
            }
        }
    }

    public interface traverseCB {
        public boolean cb(Xfiletree var1) throws Exception;
    }
}

