/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Hashtable;

class XfilesServer
extends UnicastRemoteObject
implements XfilesClient.XfilesInterface {
    static final boolean gDebug = false;
    Xfiletree tree;
    Hashtable htab;
    BufferedInputStream gFin;
    BufferedOutputStream gFout;
    String gFoutpath;

    XfilesServer() throws RemoteException {
    }

    void buildHashtable() {
        this.htab = new Hashtable();
        try {
            this.tree.traverse(new hashCB());
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void setRootPath(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        if (!file.exists()) {
            throw new XfilesClient.XFExServerRootIsBad(string);
        }
        if (XfilesCommon.isLink(file)) {
            throw new XfilesClient.XFExServerRootIsLink(string);
        }
        this.tree = null;
    }

    public boolean fileExists(File file) throws RemoteException {
        System.err.println("exists? " + file.getPath());
        if (this.tree == null) {
            return file.exists();
        }
        Xfiletree xfiletree = (Xfiletree)this.htab.get(file.getPath());
        System.err.println("exists -> " + (xfiletree != null));
        return xfiletree != null;
    }

    public void readTree(File file) throws RemoteException, XfilesClient.XFException {
        try {
            String string = file.getPath();
            System.out.println("server starting on " + string);
            this.tree = new Xfiletree(null, string, true, false);
            this.buildHashtable();
            return;
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public String lookup(String string) throws RemoteException, XfilesClient.XFException {
        System.out.println("remote.lookup " + string);
        return XfilesCommon.htabLookup(this.htab, string);
    }

    public boolean isDir(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        Xfiletree xfiletree = (Xfiletree)this.htab.get(string);
        if (xfiletree == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        XfilesCommon.assert(xfiletree.file != null);
        return xfiletree.file.isDirectory() && !xfiletree.isLink;
    }

    public boolean isLink(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        Xfiletree xfiletree = (Xfiletree)this.htab.get(string);
        if (xfiletree == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        return xfiletree.isLink;
    }

    public String[] readDir(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        System.out.println("server readdir " + string);
        Xfiletree xfiletree = (Xfiletree)this.htab.get(string);
        if (xfiletree == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        int n = xfiletree.children.length;
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (!xfiletree.children[n3].isLink) {
                    ++n2;
                }
                ++n3;
            }
            String[] stringArray = new String[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (!xfiletree.children[n5].isLink) {
                    stringArray[n4] = xfiletree.children[n5].file.getName();
                    ++n4;
                }
                ++n5;
            }
            return stringArray;
        }
        return null;
    }

    public XfilesClient.checksum checksumFile(File file) throws RemoteException, XfilesClient.XFException {
        XfilesCommon.assert(this.htab != null);
        String string = file.getPath();
        if (this.htab.get(string) == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        try {
            XfilesClient.checksum checksum2 = XfilesCommon.checksum(string);
            return checksum2;
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public void readFile(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        System.out.println("server examining " + string);
        XfilesCommon.assert(this.htab != null);
        if (this.htab.get(string) == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        try {
            this.gFin = XfilesCommon.readFile(string);
            return;
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public XfilesClient.bytebuf readbuf(int n) throws RemoteException, XfilesClient.XFException {
        try {
            XfilesCommon.assert(this.gFin != null);
            XfilesClient.bytebuf bytebuf2 = new XfilesClient.bytebuf(n);
            bytebuf2.len = XfilesCommon.readbuf(this.gFin, bytebuf2.buf);
            return bytebuf2;
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public long getLength(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        Xfiletree xfiletree = (Xfiletree)this.htab.get(string);
        if (xfiletree == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        XfilesCommon.assert(xfiletree.file != null);
        return xfiletree.file.length();
    }

    public long lastModified(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        XfilesCommon.assert(string != null);
        XfilesCommon.assert(this.htab != null);
        Xfiletree xfiletree = (Xfiletree)this.htab.get(string);
        if (xfiletree == null) {
            throw new XfilesClient.XFExnoremote(string);
        }
        XfilesCommon.assert(xfiletree.file != null);
        long l = xfiletree.file.lastModified();
        System.out.println("remote.lastModified " + string + " " + l + " " + new Date(l));
        return l;
    }

    public void mkDir(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        System.out.println("mkDir " + string);
        try {
            XfilesCommon.mkDir(string);
            return;
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public void writeFile(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        System.out.println("writeFile " + string);
        XfilesScript.preCopyScript(string);
        try {
            this.gFoutpath = string;
            this.gFout = XfilesCommon.writeFile(string);
            return;
        }
        catch (IOException iOException) {
            System.err.println("writefile i/o error " + iOException.getMessage());
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public void writebuf(byte[] byArray, int n) throws RemoteException, XfilesClient.XFException {
        try {
            this.gFout.write(byArray, 0, n);
            return;
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
    }

    public void writeClose() throws RemoteException, XfilesClient.XFException {
        try {
            this.gFout.close();
        }
        catch (IOException iOException) {
            throw new XfilesClient.XFException(iOException.getMessage());
        }
        XfilesScript.postCopyScript(this.gFoutpath);
        this.gFoutpath = null;
    }

    public void delete(File file) throws RemoteException, XfilesClient.XFException {
        String string = file.getPath();
        System.out.println("delete " + string);
        try {
            XfilesCommon.delete(string, this.htab);
            return;
        }
        catch (Exception exception) {
            throw new XfilesClient.XFException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            XfilesScript.scriptSetup();
            LocateRegistry.createRegistry(9753);
            XfilesServer xfilesServer = new XfilesServer();
            String string = System.getProperty("XFILES", "XF");
            Naming.rebind(string, xfilesServer);
            System.out.println("XfilesServer is running.");
            return;
        }
        catch (ConnectIOException connectIOException) {
            System.err.println("could not setup server socket - ");
            System.err.println("tcp networking probably needs to be turned on.");
            System.exit(1);
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR");
            System.err.println(exception);
            exception.printStackTrace();
            System.err.println("Usage: java [-DXFILES=<name>] XfilesServer");
            System.exit(1);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("ERROR: uncaught exception: " + throwable);
            throwable.printStackTrace();
            return;
        }
    }

    class hashCB
    implements Xfiletree.traverseCB {
        public boolean cb(Xfiletree xfiletree) {
            XfilesServer.this.htab.put(xfiletree.file.getPath(), xfiletree);
            return true;
        }

        hashCB() {
            XfilesServer.this = XfilesServer.this;
        }
    }
}

