/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class XfilesGui {
    public static int CMD;
    public static final int CMDnone = 200;
    public static final int CMDcompare = 201;
    public static final int CMDcopytoserver = 202;
    public static final int CMDcopytoclient = 203;
    public static final int CMDclientdelete = 204;
    public static final int CMDserverdelete = 205;
    public static final int CMDskip = 206;
    public static final int CMDdone = 207;
    public static final int CMDstop = 208;
    static final int XSIZE = 800;
    static final int YSIZE = 600;
    static JFrame frame;
    static JTree clientTree;
    static JTextArea compareArea;
    static JTextArea clientArea;
    static JTextArea serverArea;
    static JTextArea statusArea;
    static JButton startButton;
    static Xfiletree root;
    static final Color highlightColor;
    static String GPLmessage;

    public static void showAlert(String string) {
        System.err.println(string);
        JOptionPane.showMessageDialog(frame, string, string, 0);
    }

    public static void showCondition(String string) {
        System.err.println(string);
        XfilesGui.setStatus(string);
    }

    public static void showError(Exception exception) {
        System.err.println(exception.getMessage());
        exception.printStackTrace();
    }

    public static void deleteTreeFile(Xfiletree xfiletree) {
        SwingUtilities.invokeLater(new 1(xfiletree));
    }

    public static void selectTreeFile(Xfiletree xfiletree) {
        SwingUtilities.invokeLater(new 2(xfiletree));
    }

    public static void clearCompareText() {
        SwingUtilities.invokeLater(new 3());
    }

    public static void addCompareText(String string) {
        SwingUtilities.invokeLater(new 4(string));
    }

    public static void setClientHighlight(boolean bl) {
        clientArea.setForeground(bl ? highlightColor : Color.black);
    }

    public static void setClientText(String string) {
        XfilesGui.setClientText(string, false);
    }

    public static void addClientText(String string) {
        XfilesGui.setClientText(string, true);
    }

    public static void setClientText(String string, boolean bl) {
        SwingUtilities.invokeLater(new 5(bl, string));
    }

    public static void setServerHighlight(boolean bl) {
        serverArea.setForeground(bl ? highlightColor : Color.black);
    }

    public static void setServerText(String string) {
        XfilesGui.setServerText(string, false);
    }

    public static void addServerText(String string) {
        XfilesGui.setServerText(string, true);
    }

    public static void setServerText(String string, boolean bl) {
        SwingUtilities.invokeLater(new 6(bl, string));
    }

    public static void setStatus(String string) {
        SwingUtilities.invokeLater(new 7(string));
    }

    static void setupForEditing() {
        clientTree.setEditable(true);
        TreeModel treeModel = clientTree.getModel();
        treeModel.addTreeModelListener(new 8());
    }

    public static void main(String[] stringArray) {
        System.err.println(GPLmessage);
        if (stringArray.length != 2) {
            System.err.println("Usage:");
            System.err.println("java -DXFILES=rmi://hostname:9753/XF XfilesGui clientroot serverroot");
            System.exit(1);
        }
        XfilesScript.scriptSetup();
        String string = XfilesCommon.stripTrailingSlash(stringArray[0]);
        String string2 = XfilesCommon.stripTrailingSlash(stringArray[1]);
        frame = new JFrame("Xfiles");
        frame.addWindowListener(new 9());
        Container container = frame.getContentPane();
        clientTree = new JTree();
        compareArea = new JTextArea();
        clientArea = new JTextArea();
        serverArea = new JTextArea();
        statusArea = new JTextArea();
        JPanel jPanel = new JPanel();
        startButton = new JButton("start");
        JButton jButton = new JButton("stop");
        JButton jButton2 = new JButton("diff");
        JButton jButton3 = new JButton("<copy");
        JButton jButton4 = new JButton("copy>");
        JButton jButton5 = new JButton("skip");
        JButton jButton6 = new JButton("<delete");
        JButton jButton7 = new JButton("delete>");
        Font font = new Font("SanSerif", 1, 12);
        startButton.setFont(font);
        jButton.setFont(font);
        jButton2.setFont(font);
        jButton3.setFont(font);
        jButton4.setFont(font);
        jButton5.setFont(font);
        jButton6.setFont(font);
        jButton7.setFont(font);
        clientTree.setBorder(new TitledBorder("client tree"));
        compareArea.setBorder(new TitledBorder("diff"));
        clientArea.setBorder(new TitledBorder("client"));
        serverArea.setBorder(new TitledBorder("server"));
        statusArea.setBorder(new LineBorder(UIManager.getColor("control")));
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)new JScrollPane(clientTree), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 0.7;
        container.add((Component)new JScrollPane(compareArea), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        container.add((Component)new JScrollPane(clientArea), gridBagConstraints);
        gridBagConstraints.gridx = 5;
        container.add((Component)new JScrollPane(serverArea), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        container.add((Component)statusArea, gridBagConstraints);
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add(startButton);
        jPanel.add(jButton6);
        jPanel.add(jButton3);
        jPanel.add(jButton5);
        jPanel.add(jButton4);
        jPanel.add(jButton7);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        container.add((Component)jPanel, gridBagConstraints);
        startButton.addActionListener(new 10(string, string2));
        jButton.addActionListener(new 12());
        jButton2.addActionListener(new 13());
        jButton3.addActionListener(new 14());
        jButton4.addActionListener(new 15());
        jButton5.addActionListener(new 16());
        jButton6.addActionListener(new 17());
        jButton7.addActionListener(new 18());
        clientArea.setText("client");
        serverArea.setText("server");
        statusArea.setText("");
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("client " + string + " does not exist.");
            System.exit(1);
        }
        if (XfilesCommon.isLink(file)) {
            System.err.println("The client side path has a link in it.");
            System.err.println("Use the path that the link refers to instead.");
            System.exit(1);
        }
        try {
            root = new Xfiletree(null, string, false, false);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        clientTree.setModel(new DefaultTreeModel(root));
        frame.pack();
        ((Component)frame).setSize(800, 600);
        ((Component)frame).setVisible(true);
        XfilesGui.setStatus("graphing file tree");
        root.createChildren(true, true);
        XfilesGui.selectTreeFile(root);
        frame.repaint();
        XfilesGui.setStatus("");
    }

    static {
        highlightColor = new Color(0.0f, 0.0f, 1.0f);
        GPLmessage = "\nXfiles version 1.3.1 23apr99, Copyright (C) 1999 j.p.lewis\nXfiles comes with ABSOLUTELY NO WARRANTY.\nThis is free software, and you are welcome\nto redistribute it under the GNU General Public Licence;\nsee www.gnu.org or the file LICENSE.txt for details.\n\nJPython (Version 1.0.x) is made available subject to the\nterms and conditions in CNRI's License Agreement.\nSee the file LICENSE.txt for details.\n";
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ Xfiletree val$f;

        public void run() {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)clientTree.getModel();
            defaultTreeModel.removeNodeFromParent(this.val$f);
        }

        /* synthetic */ 1(Xfiletree xfiletree) {
            this.val$f = xfiletree;
        }
    }

    private static final class 2
    implements Runnable {
        private final /* synthetic */ Xfiletree val$f;

        public void run() {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)clientTree.getModel();
            TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(this.val$f));
            if (treePath != null) {
                clientTree.scrollPathToVisible(treePath);
                clientTree.setSelectionPath(treePath);
                clientTree.expandPath(treePath);
                clientTree.makeVisible(treePath);
                frame.repaint();
                return;
            }
            System.err.println("warning: selectTreeFile failed");
        }

        /* synthetic */ 2(Xfiletree xfiletree) {
            this.val$f = xfiletree;
        }
    }

    private final class 3
    implements Runnable {
        public void run() {
            compareArea.setText("");
        }

        /* synthetic */ 3() {
        }
    }

    private static final class 4
    implements Runnable {
        private final /* synthetic */ String val$msg;

        public void run() {
            compareArea.append(this.val$msg);
        }

        /* synthetic */ 4(String string) {
            this.val$msg = string;
        }
    }

    private static final class 5
    implements Runnable {
        private final /* synthetic */ String val$msg;
        private final /* synthetic */ boolean val$append;

        public void run() {
            if (this.val$append) {
                clientArea.append(this.val$msg);
                return;
            }
            clientArea.setText(this.val$msg);
        }

        /* synthetic */ 5(boolean bl, String string) {
            this.val$append = bl;
            this.val$msg = string;
        }
    }

    private static final class 6
    implements Runnable {
        private final /* synthetic */ String val$msg;
        private final /* synthetic */ boolean val$append;

        public void run() {
            if (this.val$append) {
                serverArea.append(this.val$msg);
                return;
            }
            serverArea.setText(this.val$msg);
        }

        /* synthetic */ 6(boolean bl, String string) {
            this.val$append = bl;
            this.val$msg = string;
        }
    }

    private static final class 7
    implements Runnable {
        private final /* synthetic */ String val$msg;

        public void run() {
            statusArea.setText(this.val$msg);
        }

        /* synthetic */ 7(String string) {
            this.val$msg = string;
        }
    }

    private final class 8
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            System.out.println("nodes changed");
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            System.out.println("nodes inserted");
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            System.out.println("nodes removed");
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            System.out.println("tree changed");
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            XfilesClient.quitme(0);
        }

        /* synthetic */ 9() {
        }
    }

    private static final class 10
    implements ActionListener {
        private final /* synthetic */ String val$remoteRootPath;
        private final /* synthetic */ String val$localRootPath;

        public void actionPerformed(ActionEvent actionEvent) {
            11 var2_2 = new 11(this.val$localRootPath, this.val$remoteRootPath);
            var2_2.start();
        }

        /* synthetic */ 10(String string, String string2) {
            this.val$localRootPath = string;
            this.val$remoteRootPath = string2;
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CMD = 208;
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CMD = 201;
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CMD = 203;
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CMD = 202;
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CMD = 206;
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            System.err.println("clientDelete");
            CMD = 204;
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            System.err.println("serverDelete");
            CMD = 205;
        }

        /* synthetic */ 18() {
        }
    }
}

