/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class XfilesCommon {
    static boolean gDebug;
    private static byte[] checksumBuf;

    public static BufferedInputStream readFile(String string) throws IOException {
        return new BufferedInputStream(new FileInputStream(string));
    }

    public static int readbuf(BufferedInputStream bufferedInputStream, byte[] byArray) throws IOException {
        int n = bufferedInputStream.read(byArray, 0, byArray.length);
        if (n < 0) {
            ((FilterInputStream)bufferedInputStream).close();
        }
        return n;
    }

    public static final XfilesClient.checksum checksum(String string) throws IOException {
        XfilesClient.checksum checksum2 = new XfilesClient.checksum();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        int n = bufferedInputStream.read(checksumBuf, 0, checksumBuf.length);
        while (n > 0) {
            int n2;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            while (n4 < n) {
                n2 = checksumBuf[n4];
                int n5 = n2;
                if (n5 < 0) {
                    n5 += 128;
                }
                checksum2.sum = (checksum2.sum + n5) % n3;
                checksum2.csum[n5] = (checksum2.csum[n5] + 1) % n3;
                ++n4;
            }
            if (gDebug) {
                System.err.print("checksum read... " + checksum2.sum + " :   ");
                n2 = 64;
                while (n2 < 69) {
                    System.err.print(String.valueOf(checksum2.csum[n2]) + " ");
                    ++n2;
                }
                System.err.println("");
            }
            n = bufferedInputStream.read(checksumBuf, 0, checksumBuf.length);
        }
        ((FilterInputStream)bufferedInputStream).close();
        checksum2.isValid = true;
        return checksum2;
    }

    public static void mkDir(String string) throws IOException {
        File file = new File(string);
        file.mkdirs();
    }

    public static BufferedOutputStream writeFile(String string) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(string));
    }

    public static void delete1(String string) throws IOException {
        System.out.println("delete1 " + string);
        File file = new File(string);
        file.delete();
    }

    static void deleteDir(Xfiletree xfiletree, Hashtable hashtable) throws IOException {
        System.out.println("deleteDir " + xfiletree.file.getPath());
        int n = xfiletree.children.length;
        int n2 = 0;
        while (n2 < n) {
            Xfiletree xfiletree2 = xfiletree.children[n2];
            if (xfiletree2.isDir) {
                XfilesCommon.deleteDir(xfiletree2, hashtable);
            } else {
                XfilesCommon.delete1(xfiletree2.file.getPath());
            }
            hashtable.remove(xfiletree2);
            ++n2;
        }
        xfiletree.children = null;
        xfiletree.file.delete();
    }

    public static void delete(String string, Hashtable hashtable) throws IOException, XfilesClient.XFException {
        Xfiletree xfiletree = (Xfiletree)hashtable.get(string);
        if (xfiletree == null) {
            throw new XfilesClient.XFExnosuchfile(string);
        }
        if (xfiletree.isDir) {
            XfilesCommon.deleteDir(xfiletree, hashtable);
            Xfiletree xfiletree2 = xfiletree.parent;
            if (xfiletree2 != null) {
                xfiletree2.deleteChild(xfiletree);
            }
            hashtable.remove(string);
            return;
        }
        XfilesCommon.delete1(string);
        hashtable.remove(string);
    }

    public static boolean isLink(File file) {
        try {
            if (!file.exists()) {
                return true;
            }
            String string = file.getCanonicalPath();
            String string2 = file.getAbsolutePath();
            return !string2.equals(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void assert(boolean bl) {
        if (!bl) {
            Error error = new Error("assert failed");
            throw error;
        }
    }

    public static String stripRoot(String string, int n, String string2) {
        if (string2.startsWith(string)) {
            String string3 = string2.substring(n);
            return string3;
        }
        throw new Error("striproot failed!");
    }

    static String stripExt(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String stripTrailingSlash(String string) {
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static boolean nameIsSimilar(String string, String string2) {
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return false;
        }
        try {
            String string3 = string.substring(n + 1);
            int n2 = string3.indexOf(46);
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
            }
            boolean bl = string3.equals(string2);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static String htabLookup(Hashtable hashtable, String string) {
        string = XfilesCommon.stripExt(string);
        StringBuffer stringBuffer = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!XfilesCommon.nameIsSimilar(string2, string)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(string2);
            Xfiletree xfiletree = (Xfiletree)hashtable.get(string2);
            if (xfiletree != null) {
                if (xfiletree.isDir) {
                    stringBuffer.append(" (directory)");
                } else {
                    stringBuffer.append(" (file)");
                }
            }
            stringBuffer.append("\n");
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    XfilesCommon() {
    }

    static {
        checksumBuf = new byte[8192];
    }
}

