/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreePath;

public class XfilesClient {
    static Hashtable htab;
    static boolean showAll;
    static final String TMPFILE = "/usr/tmp/XfilesTMP";
    static final boolean gVerbose = true;
    static final boolean gDebug = false;
    static XfilesInterface remote;
    static checksum csLocal;
    static PrintWriter logFile;
    static String remoteRoot;
    static String localRoot;
    static int localRootLen;
    static String EserverRootIsBad;
    static String EserverRootIsLink;

    static final File remotePath(String string) {
        return new File(String.valueOf(remoteRoot) + string);
    }

    static final File remotePath(Cfile cfile) {
        return new File(cfile.rpath);
    }

    static final boolean comparebuf(String string, long l, byte[] byArray, long l2, byte[] byArray2) {
        if (l >= 0L && l != l2) {
            return false;
        }
        int n = 0;
        while ((long)n < l) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static boolean compareFull(Cfile cfile) throws RemoteException, IOException, Exception {
        System.out.println("compare " + cfile.lpath);
        remote.readFile(XfilesClient.remotePath(cfile));
        BufferedInputStream bufferedInputStream = XfilesCommon.readFile(cfile.lpath);
        XfilesCommon.assert(bufferedInputStream != null);
        int n = 4096;
        byte[] byArray = new byte[n];
        long l = 0L;
        long l2 = 0L;
        do {
            bytebuf bytebuf2 = remote.readbuf(n);
            l = XfilesCommon.readbuf(bufferedInputStream, byArray);
            if (!XfilesClient.comparebuf(cfile.lpath, bytebuf2.len, bytebuf2.buf, l, byArray)) {
                return false;
            }
            if (bytebuf2.len <= 0L) continue;
            l2 += bytebuf2.len;
        } while (l >= 0L);
        if (l2 != cfile.rlength) {
            cfile.message = "remote bytes read do not match size " + cfile.cpath + " " + cfile.rlength + " " + l2;
            System.err.println(cfile.message);
            return false;
        }
        return true;
    }

    static boolean compareChecksum(Cfile cfile) throws RemoteException, IOException, Exception {
        checksum checksum2;
        System.out.println("compareChecksum " + cfile.lpath);
        csLocal.clear();
        boolean bl = false;
        if (bl) {
            checksum2 = remote.checksumFile(XfilesClient.remotePath(cfile));
            csLocal = XfilesCommon.checksum(cfile.lpath);
        } else {
            1 var3_3 = new 1(cfile);
            var3_3.start();
            Thread.yield();
            Thread.currentThread();
            Thread.yield();
            checksum2 = remote.checksumFile(XfilesClient.remotePath(cfile));
            var3_3.join();
        }
        boolean bl2 = true;
        if (!checksum2.isValid || !XfilesClient.csLocal.isValid) {
            bl2 = false;
        }
        if (XfilesClient.csLocal.sum != checksum2.sum) {
            bl2 = false;
        }
        int n = 0;
        while (n < 256) {
            if (XfilesClient.csLocal.csum[n] != checksum2.csum[n]) {
                bl2 = false;
                break;
            }
            ++n;
        }
        return bl2;
    }

    static void dir2Client(Cfile cfile) {
        XfilesCommon.assert(cfile.risdir);
        File file = new File(cfile.lpath);
        file.mkdirs();
        try {
            String[] stringArray = remote.readDir(XfilesClient.remotePath(cfile));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = String.valueOf(cfile.cpath) + File.separator + stringArray[n2];
                Cfile cfile2 = new Cfile(null, string);
                if (cfile2.risdir) {
                    XfilesClient.dir2Client(cfile2);
                } else if (!cfile2.rislink) {
                    XfilesClient.file2Client(cfile2);
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            XfilesGui.showCondition(exception.getMessage());
            return;
        }
    }

    private static void _file2client(String string, String string2) {
        try {
            bytebuf bytebuf2;
            XfilesScript.preCopyScript(string2);
            remote.readFile(XfilesClient.remotePath(string));
            System.out.println("writing client file " + string2);
            BufferedOutputStream bufferedOutputStream = XfilesCommon.writeFile(string2);
            int n = 4096;
            do {
                bytebuf2 = remote.readbuf(n);
                if (bytebuf2.len <= 0L) continue;
                bufferedOutputStream.write(bytebuf2.buf, 0, (int)bytebuf2.len);
            } while (bytebuf2.len > -1L);
            bufferedOutputStream.close();
            XfilesScript.postCopyScript(string2);
            return;
        }
        catch (Exception exception) {
            XfilesGui.showAlert(XfilesClient.EwriteFailed("client", exception.getMessage()));
            return;
        }
    }

    static void file2Client(Cfile cfile) {
        System.out.println("copy to client " + cfile);
        if (cfile.risdir) {
            XfilesClient.dir2Client(cfile);
            return;
        }
        XfilesClient._file2client(cfile.cpath, cfile.lpath);
    }

    static void file2Server(Cfile cfile) {
        System.out.println("copy to server " + cfile);
        try {
            if (cfile.lisdir) {
                System.out.println("remote.mkdir " + cfile);
                Xfiletree xfiletree = (Xfiletree)htab.get(cfile.lpath);
                if (xfiletree != null) {
                    xfiletree.traverse(new copier());
                    return;
                }
            } else {
                int n;
                remote.writeFile(XfilesClient.remotePath(cfile));
                System.out.println("writing server file " + cfile.rpath);
                BufferedInputStream bufferedInputStream = XfilesCommon.readFile(cfile.lpath);
                int n2 = 4096;
                byte[] byArray = new byte[n2];
                while ((n = XfilesCommon.readbuf(bufferedInputStream, byArray)) > -1) {
                    remote.writebuf(byArray, n);
                }
                remote.writeClose();
            }
            return;
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        catch (Exception exception) {
            XfilesGui.showAlert(XfilesClient.EwriteFailed("server", exception.getMessage()));
            return;
        }
    }

    static void delete(Cfile cfile) {
        try {
            XfilesCommon.delete(cfile.lpath, htab);
            Xfiletree xfiletree = (Xfiletree)htab.get(cfile.lpath);
            if (xfiletree != null) {
                XfilesGui.deleteTreeFile(xfiletree);
                return;
            }
        }
        catch (XFException xFException) {
            XfilesGui.showAlert(xFException.getMessage());
            return;
        }
        catch (IOException iOException) {
            XfilesGui.showAlert(iOException.getMessage());
        }
    }

    static void showCompare(Cfile cfile) {
        System.out.println("compare " + cfile);
        if (cfile.lisdir || cfile.risdir) {
            XfilesGui.setStatus("cannot display directory comparison!");
            return;
        }
        XfilesClient._file2client(cfile.cpath, TMPFILE);
        String string = "diff " + cfile.lpath + " " + TMPFILE;
        Process process = null;
        int n = 0;
        try {
            int n2;
            process = Runtime.getRuntime().exec(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            byte[] byArray = new byte[4096];
            XfilesGui.clearCompareText();
            while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
                String string2 = new String(byArray, 0, n2);
                XfilesGui.addCompareText(string2);
            }
            ((FilterInputStream)bufferedInputStream).close();
            n = process.waitFor();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            XfilesGui.showAlert(exception.getMessage());
            return;
        }
    }

    private static void showLocalInfo(Cfile cfile) {
        XfilesClient.showLocalInfo(cfile, false);
    }

    private static void showLocalInfo(Cfile cfile, boolean bl) {
        XfilesGui.setClientHighlight(bl);
        XfilesGui.setClientText(cfile.cpath);
        if (cfile.lexists) {
            if (cfile.lisdir) {
                XfilesGui.addClientText("\ndirectory");
            } else if (cfile.llength > -1L) {
                XfilesGui.addClientText("\n" + cfile.llength + " bytes");
            }
            if (cfile.ldate > -1L) {
                XfilesGui.addClientText("\n" + new Date(cfile.ldate).toString());
                return;
            }
        } else {
            XfilesGui.addClientText("\ndoes not exist.");
        }
    }

    private static void showRemoteInfo(Cfile cfile) {
        XfilesClient.showRemoteInfo(cfile, false);
    }

    private static void showRemoteInfo(Cfile cfile, boolean bl) {
        XfilesGui.setServerHighlight(bl);
        XfilesGui.setServerText(cfile.cpath);
        if (cfile.rexists) {
            if (cfile.risdir) {
                XfilesGui.addServerText("\ndirectory");
            } else if (cfile.rlength > -1L) {
                XfilesGui.addServerText("\n" + cfile.rlength + " bytes");
            }
            if (cfile.rdate > -1L) {
                XfilesGui.addServerText("\n" + new Date(cfile.rdate).toString());
                return;
            }
        } else {
            XfilesGui.addServerText("\ndoes not exist.");
        }
    }

    static void waitForPress() {
        XfilesGui.CMD = 200;
        while (XfilesGui.CMD == 200) {
            Thread thread = Thread.currentThread();
            Thread.yield();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                XfilesGui.showError(interruptedException);
            }
        }
    }

    static String localLookup(Cfile cfile) {
        XfilesCommon.assert(cfile.lpath != null);
        File file = new File(cfile.lpath);
        String string = file.getName();
        System.out.println("local.lookup " + string);
        return XfilesCommon.htabLookup(htab, string);
    }

    static void logEntry(String string, boolean bl) {
        if (logFile == null) {
            try {
                logFile = new PrintWriter((Writer)new FileWriter("XFILES.LOG"), true);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        if (bl) {
            System.out.println(string);
            logFile.println(string);
            return;
        }
        System.out.print(string);
        System.out.print("\t");
        logFile.print(string);
        logFile.print("\t");
    }

    static boolean handle(Cfile cfile) throws XFEstop {
        Xfiletree xfiletree = (Xfiletree)htab.get(cfile.lpath);
        if (xfiletree != null) {
            XfilesGui.selectTreeFile(xfiletree);
            Thread.yield();
        }
        boolean bl = true;
        boolean bl2 = false;
        XfilesClient.logEntry(cfile.cpath, false);
        switch (cfile.condition) {
            case 900: 
            case 904: 
            case 905: 
            case 906: {
                XfilesGui.setStatus(cfile.message);
                XfilesClient.logEntry(cfile.message, false);
                bl = false;
                bl2 = true;
                break;
            }
            case 902: {
                XfilesGui.setStatus(cfile.message);
                XfilesClient.showRemoteInfo(cfile);
                XfilesClient.logEntry(cfile.message, false);
                Object object = XfilesClient.localLookup(cfile);
                if (object == null) break;
                XfilesGui.setClientHighlight(false);
                XfilesGui.setClientText("FILES WITH SIMILAR NAMES EXIST AT:\n" + (String)object);
                break;
            }
            case 903: {
                XfilesGui.setStatus(cfile.message);
                XfilesClient.showLocalInfo(cfile);
                XfilesClient.logEntry(cfile.message, false);
                Object object = new File(cfile.lpath);
                String string = ((File)object).getName();
                try {
                    System.out.println("noremote name: " + string);
                    String string2 = remote.lookup(string);
                    if (string2 == null) break;
                    XfilesGui.setServerHighlight(false);
                    XfilesGui.setServerText("FILES WITH SIMILAR NAMES EXIST AT:\n" + string2);
                }
                catch (Exception exception) {
                    XfilesGui.showError(exception);
                }
                break;
            }
            case 901: {
                if (cfile.ldate > -1L && cfile.rdate > -1L) {
                    cfile.message = cfile.ldate > cfile.rdate ? String.valueOf(cfile.message) + ", client is newer" : String.valueOf(cfile.message) + ", server is newer";
                }
                XfilesClient.showLocalInfo(cfile, cfile.ldate > cfile.rdate);
                XfilesClient.showRemoteInfo(cfile, cfile.rdate > cfile.ldate);
                XfilesClient.logEntry(cfile.message, false);
                XfilesGui.setStatus(cfile.message);
                break;
            }
            default: {
                throw new Error("BAD CONDITION: " + cfile.condition);
            }
        }
        do {
            XfilesClient.waitForPress();
            if (bl2) {
                XfilesGui.CMD = 206;
            }
            if (XfilesGui.CMD == 208) {
                throw new XFEstop("");
            }
            switch (XfilesGui.CMD) {
                case 206: {
                    bl = false;
                    XfilesGui.CMD = 207;
                    XfilesClient.logEntry("skip", true);
                    break;
                }
                case 201: {
                    XfilesClient.showCompare(cfile);
                    XfilesGui.CMD = 200;
                    break;
                }
                case 202: {
                    if (cfile.condition == 902) {
                        XfilesGui.showAlert("you are copying in the wrong direction");
                        XfilesGui.CMD = 200;
                        break;
                    }
                    XfilesGui.setStatus("copy->");
                    XfilesClient.file2Server(cfile);
                    XfilesGui.CMD = 207;
                    XfilesClient.logEntry("copy ->", true);
                    bl = false;
                    break;
                }
                case 203: {
                    if (cfile.condition == 903) {
                        XfilesGui.showAlert("you are copying in the wrong direction");
                        XfilesGui.CMD = 200;
                        break;
                    }
                    XfilesGui.setStatus("<-copy");
                    XfilesClient.file2Client(cfile);
                    XfilesGui.CMD = 207;
                    XfilesClient.logEntry("<- copy", true);
                    break;
                }
                case 204: {
                    if (cfile.condition == 902) {
                        XfilesGui.showAlert("you are deleting on the wrong side");
                        XfilesGui.CMD = 200;
                        break;
                    }
                    XfilesGui.setStatus("<-delete");
                    XfilesClient.delete(cfile);
                    XfilesGui.CMD = 207;
                    XfilesClient.logEntry("<- delete", true);
                    bl = false;
                    break;
                }
                case 205: {
                    if (cfile.condition == 903) {
                        XfilesGui.showAlert("you are deleting on the wrong side");
                        XfilesGui.CMD = 200;
                        break;
                    }
                    try {
                        XfilesGui.setStatus("delete ->");
                        remote.delete(XfilesClient.remotePath(cfile));
                        XfilesClient.logEntry("delete ->", true);
                    }
                    catch (XFException xFException) {
                        XfilesGui.showAlert(xFException.getMessage());
                    }
                    catch (RemoteException remoteException) {
                        XfilesGui.showError(remoteException);
                    }
                    XfilesGui.CMD = 207;
                    break;
                }
                default: {
                    XfilesCommon.assert(new Integer(0).toString().equals("bad CMD"));
                    break;
                }
            }
        } while (XfilesGui.CMD != 207);
        XfilesGui.setStatus("");
        XfilesGui.setClientText("");
        XfilesGui.setServerText("");
        XfilesGui.clearCompareText();
        XfilesGui.frame.repaint();
        Thread.yield();
        return bl;
    }

    static final Object needsAttention(Cfile cfile) {
        Cfile cfile2 = null;
        if (!XfilesScript.pathFilter(cfile)) {
            return cfile2;
        }
        if (!cfile.rexists) {
            cfile.message = "server file does not exist";
            cfile.condition = 903;
            cfile2 = cfile;
        } else if (cfile.rislink) {
            cfile.message = "server is link, client is not\ncannot handle this situation";
            cfile.condition = 904;
            cfile2 = cfile;
        } else if (cfile.lisdir && !cfile.risdir) {
            cfile.message = "client is directory, server is file\ncannot handle this situation";
            cfile.condition = 905;
            cfile2 = cfile;
        } else if (!cfile.lisdir && cfile.risdir) {
            cfile.message = "server is directory, client is file\ncannot handle this situation";
            cfile.condition = 906;
            cfile2 = cfile;
        } else if (cfile.lisdir) {
            XfilesCommon.assert(cfile.risdir);
            Vector<Cfile> vector = null;
            try {
                int n;
                String[] stringArray = remote.readDir(XfilesClient.remotePath(cfile));
                int n2 = n = stringArray != null ? stringArray.length : 0;
                if (n != 0) {
                    int n3 = 0;
                    while (n3 < n) {
                        String string = String.valueOf(cfile.lpath) + File.separator + stringArray[n3];
                        System.out.print("hashtable lookup " + string);
                        if (htab.get(string) == null) {
                            System.out.println(" -> no.");
                            if (vector == null) {
                                vector = new Vector<Cfile>();
                            }
                            String string2 = XfilesCommon.stripRoot(localRoot, localRootLen, string);
                            Cfile cfile3 = new Cfile(null, string2);
                            cfile3.message = "client file does not exist.";
                            cfile3.condition = 902;
                            if (XfilesScript.pathFilter(cfile3)) {
                                vector.addElement(cfile3);
                            }
                        } else {
                            System.out.println(" -> exists.");
                        }
                        ++n3;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            if (vector != null) {
                cfile2 = vector;
            }
        } else {
            XfilesCommon.assert(!cfile.lisdir && !cfile.risdir);
            try {
                if (!XfilesClient.compareChecksum(cfile)) {
                    cfile.message = "files are different";
                    cfile.condition = 901;
                    cfile2 = cfile;
                }
            }
            catch (Exception exception) {
                System.err.println("compare generated eXception " + exception.getMessage());
                cfile.message = exception.getMessage();
                cfile.condition = 900;
                cfile2 = cfile;
            }
        }
        if (cfile2 != null && cfile2 instanceof Cfile && cfile2.condition == 0) {
            throw new Error("BAD cfile condition " + cfile2.toString());
        }
        return cfile2;
    }

    static String EwriteFailed(String string, String string2) {
        String string3 = String.valueOf(string) + " file write failed for\n" + string2;
        string3 = String.valueOf(string3) + "\n(write permissions / disk space problem?)";
        return string3;
    }

    static void doSync(XfilesInterface xfilesInterface, String string, String string2) {
        System.out.println("doSync clientroot=" + string);
        System.out.println("doSync serverroot=" + string2);
        XfilesGui.setStatus("");
        try {
            remoteRoot = string2;
            localRoot = string;
            localRootLen = localRoot.length();
            xfilesInterface.setRootPath(new File(remoteRoot));
            visitor visitor2 = new visitor();
            TreePath treePath = XfilesGui.clientTree.getSelectionPath();
            Object object = treePath.getLastPathComponent();
            visitor2.startNode = object == null ? XfilesGui.root : (Xfiletree)treePath.getLastPathComponent();
            System.out.println("starting at " + visitor2.startNode);
            XfilesGui.selectTreeFile(visitor2.startNode);
            String string3 = visitor2.startNode.file.getPath();
            String string4 = XfilesCommon.stripRoot(localRoot, localRootLen, string3);
            XfilesCommon.assert(string4 != null);
            if (!xfilesInterface.fileExists(XfilesClient.remotePath(string4))) {
                XfilesGui.showAlert(String.valueOf(remoteRoot) + string4 + " does not exist.");
                return;
            }
            XfilesGui.setStatus("reading remote tree");
            xfilesInterface.readTree(XfilesClient.remotePath(string4));
            htab = new Hashtable();
            XfilesGui.root.traverse(new hashCB());
            visitor2.active = false;
            visitor2.scanning = true;
            XfilesGui.setStatus("scanning for differences");
            long l = System.currentTimeMillis();
            try {
                visitor2.startNode.traverse(visitor2);
            }
            catch (XFEstop xFEstop) {
                System.out.println("stopped");
            }
            long l2 = System.currentTimeMillis();
            System.out.println("\n\nscanning took " + (double)(l2 - l) / 1000.0 + " seconds.");
            System.out.println("free memory = " + Runtime.getRuntime().freeMemory());
            System.out.println("\n");
            visitor2.active = false;
            visitor2.scanning = false;
            XfilesGui.setStatus("");
            try {
                visitor2.startNode.traverse(visitor2);
            }
            catch (XFEstop xFEstop) {
                System.out.println("stopped");
            }
        }
        catch (XFExServerRootIsBad xFExServerRootIsBad) {
            XfilesGui.showAlert(String.valueOf(EserverRootIsBad) + "\n" + xFExServerRootIsBad.getMessage());
            XfilesClient.quitme(1);
        }
        catch (XFExServerRootIsLink xFExServerRootIsLink) {
            XfilesGui.showAlert(String.valueOf(EserverRootIsLink) + "\n" + xFExServerRootIsLink.getMessage());
            XfilesClient.quitme(1);
        }
        catch (Exception exception) {
            System.err.println("doSync exception");
            XfilesGui.showError(exception);
        }
        XfilesGui.setStatus("done");
    }

    public static void startClient(String string, String string2) {
        try {
            String string3 = System.getProperty("XFILES", "rmi:///XS");
            remote = (XfilesInterface)Naming.lookup(string3);
            XfilesClient.doSync(remote, string, string2);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Failing due to unknownhost, trying again");
            System.err.println(unknownHostException.getMessage());
            return;
        }
        catch (NotBoundException notBoundException) {
            System.err.println(notBoundException);
            return;
        }
        catch (ConnectIOException connectIOException) {
            System.err.println("Failing with connectIOException, trying again");
            System.err.println(connectIOException.getMessage());
            return;
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException);
            remoteException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.err.println("Usage: java [-DRQNAME=<url>] XfilesClient <cmd> [<args>]");
            System.err.println("<cmd> \"help\" to get full usage");
            XfilesClient.quitme(1);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
            XfilesClient.quitme(1);
            return;
        }
    }

    static void quitme(int n) {
        File file = new File(TMPFILE);
        file.delete();
        remote = null;
        System.gc();
        System.runFinalization();
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        try {
            LocateRegistry.createRegistry(9753);
        }
        catch (RemoteException remoteException) {
            System.out.println("can't create rmi-registry!");
            System.exit(-1);
        }
        System.out.println("#args " + stringArray.length);
        if (stringArray.length != 2) {
            System.err.println("Usage:");
            System.err.println("java -DXFILES=rmi://hostname:9753/XF XfilesGui clientroot serverroot");
            System.exit(1);
        }
        String string = XfilesCommon.stripTrailingSlash(stringArray[0]);
        String string2 = XfilesCommon.stripTrailingSlash(stringArray[1]);
        XfilesClient.startClient(string, string2);
    }

    static {
        csLocal = new checksum();
        EserverRootIsBad = "The server root path does not exist\n(on Unix -- may be a dangling link)";
        EserverRootIsLink = "The server root path contains a link\n(use the path it references instead)";
    }

    public interface XfilesInterface
    extends Remote {
        public void setRootPath(File var1) throws RemoteException, XFException;

        public boolean fileExists(File var1) throws RemoteException;

        public void readTree(File var1) throws RemoteException, XFException;

        public String lookup(String var1) throws RemoteException, XFException;

        public boolean isDir(File var1) throws RemoteException, XFException;

        public boolean isLink(File var1) throws RemoteException, XFException;

        public String[] readDir(File var1) throws RemoteException, XFException;

        public checksum checksumFile(File var1) throws RemoteException, XFException;

        public void readFile(File var1) throws RemoteException, XFException;

        public bytebuf readbuf(int var1) throws RemoteException, XFException;

        public long getLength(File var1) throws RemoteException, XFException;

        public long lastModified(File var1) throws RemoteException, XFException;

        public void mkDir(File var1) throws RemoteException, XFException;

        public void writeFile(File var1) throws RemoteException, XFException;

        public void writebuf(byte[] var1, int var2) throws RemoteException, XFException;

        public void writeClose() throws RemoteException, XFException;

        public void delete(File var1) throws RemoteException, XFException;
    }

    static class bytebuf
    implements Serializable {
        byte[] buf;
        long len;

        bytebuf(int n) {
            this.len = n;
            this.buf = new byte[n];
        }
    }

    public static class checksum
    implements Serializable {
        int sum;
        int[] csum = new int[256];
        boolean isValid;
        String errorMsg;

        checksum() {
            this.clear();
        }

        void clear() {
            this.isValid = false;
            this.sum = 0;
            int n = 0;
            while (n < 256) {
                this.csum[n] = 0;
                ++n;
            }
            this.errorMsg = null;
        }
    }

    public static class XFException
    extends Exception {
        public XFException(String string) {
            super(string);
        }
    }

    public static class XFExnoremote
    extends XFException {
        public XFExnoremote(String string) {
            super(string);
        }
    }

    public static class XFExServerRootIsBad
    extends XFException {
        public XFExServerRootIsBad(String string) {
            super(string);
        }
    }

    public static class XFExServerRootIsLink
    extends XFException {
        public XFExServerRootIsLink(String string) {
            super(string);
        }
    }

    public static class XFExnosuchfile
    extends XFException {
        public XFExnosuchfile(String string) {
            super(string);
        }
    }

    public static class XFEstop
    extends XFException {
        public XFEstop(String string) {
            super(string);
        }
    }

    static final class Cfile {
        String cpath;
        String lpath;
        String rpath;
        boolean lexists;
        boolean rexists;
        boolean lisdir;
        boolean risdir;
        boolean lislink;
        boolean rislink;
        long ldate;
        long rdate;
        long llength;
        long rlength;
        String message;
        int condition;
        static final int ERROR = 900;
        static final int DIFFERENT = 901;
        static final int NOLOCAL = 902;
        static final int NOREMOTE = 903;
        static final int LINK = 904;
        static final int RNOTDIR = 905;
        static final int LNOTDIR = 906;

        Cfile(File file, String string) {
            if (string == null) {
                System.err.println("Cpath null!");
                string = "";
            }
            this.cpath = string;
            this.lpath = String.valueOf(localRoot) + string;
            this.rpath = String.valueOf(remoteRoot) + string;
            if (file != null) {
                this.lexists = true;
                this.ldate = file.lastModified();
                this.llength = file.length();
                this.lisdir = file.isDirectory();
            } else {
                this.lexists = false;
                this.llength = -1L;
                this.ldate = -1L;
            }
            this.lislink = false;
            this.rdate = -1L;
            this.rlength = -1L;
            this.rexists = false;
            try {
                this.rdate = remote.lastModified(XfilesClient.remotePath(string));
                this.rlength = remote.getLength(XfilesClient.remotePath(string));
                this.risdir = remote.isDir(XfilesClient.remotePath(string));
                this.rislink = remote.isLink(XfilesClient.remotePath(string));
                this.rexists = true;
            }
            catch (XFException xFException) {
            }
            catch (RemoteException remoteException) {
                System.err.println("cfile constructor");
                if (this.lpath != null) {
                    System.err.println("lpath" + this.lpath);
                }
                if (string != null) {
                    System.err.println("cpath" + string);
                }
                XfilesGui.showError(remoteException);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            this.message = null;
            this.condition = 0;
        }

        public String toString() {
            return this.cpath;
        }
    }

    static final class hashCB
    implements Xfiletree.traverseCB {
        public final boolean cb(Xfiletree xfiletree) {
            String string = xfiletree.file.getPath();
            XfilesCommon.stripRoot(localRoot, localRootLen, string);
            htab.put(string, xfiletree);
            xfiletree.userObject = null;
            return true;
        }

        hashCB() {
        }
    }

    private static final class 1
    extends Thread {
        private final /* synthetic */ Cfile val$cfile;

        public void run() {
            try {
                csLocal = XfilesCommon.checksum(this.val$cfile.lpath);
                return;
            }
            catch (Exception exception) {
                System.err.println("checksum threadexception: " + exception.getMessage());
                XfilesClient.csLocal.errorMsg = exception.getMessage();
                XfilesClient.csLocal.isValid = false;
                return;
            }
        }

        /* synthetic */ 1(Cfile cfile) {
            this.val$cfile = cfile;
        }
    }

    static final class copier
    implements Xfiletree.traverseCB {
        public boolean cb(Xfiletree xfiletree) {
            String string = xfiletree.file.getPath();
            String string2 = XfilesCommon.stripRoot(localRoot, localRootLen, string);
            Cfile cfile = new Cfile(xfiletree.file, string2);
            XfilesClient.logEntry("recursively copying " + string2 + " to server " + cfile.rpath, true);
            if (xfiletree.isDir) {
                try {
                    remote.mkDir(XfilesClient.remotePath(cfile));
                }
                catch (Exception exception) {
                    XfilesGui.showError(exception);
                    return false;
                }
            } else {
                XfilesClient.file2Server(cfile);
            }
            return true;
        }

        copier() {
        }
    }

    static final class visitor
    implements Xfiletree.traverseCB {
        Xfiletree startNode;
        boolean active;
        boolean scanning;
        int selectcount = 1;

        boolean cbScan(Xfiletree xfiletree) {
            String string;
            String string2;
            Cfile cfile;
            Object object;
            if (xfiletree.isDir) {
                XfilesGui.selectTreeFile(xfiletree);
                Thread.yield();
            }
            if ((object = XfilesClient.needsAttention(cfile = new Cfile(xfiletree.file, string2 = XfilesCommon.stripRoot(localRoot, localRootLen, string = xfiletree.file.getPath())))) != null) {
                xfiletree.userObject = object;
            }
            return true;
        }

        boolean cbAct(Xfiletree xfiletree) throws XFEstop {
            if (xfiletree.isDir || ++this.selectcount % 10 == 0 || xfiletree.userObject != null) {
                XfilesGui.selectTreeFile(xfiletree);
                Thread.yield();
            }
            if (xfiletree.userObject == null) {
                return true;
            }
            String string = xfiletree.file.getParent();
            if (string == null) {
                string = "";
            }
            XfilesGui.setStatus(String.valueOf(string) + "\n" + xfiletree.file.getName());
            if (xfiletree.userObject instanceof Vector) {
                Vector vector = (Vector)xfiletree.userObject;
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    XfilesClient.handle((Cfile)vector.elementAt(n2));
                    ++n2;
                }
                return true;
            }
            return XfilesClient.handle((Cfile)xfiletree.userObject);
        }

        public boolean cb(Xfiletree xfiletree) throws XFEstop {
            if (XfilesGui.CMD == 208) {
                throw new XFEstop("");
            }
            if (!this.active) {
                if (xfiletree == this.startNode) {
                    this.active = true;
                } else {
                    return true;
                }
            }
            if (this.scanning) {
                return this.cbScan(xfiletree);
            }
            return this.cbAct(xfiletree);
        }

        visitor() {
        }
    }
}

