
tdir is a command line tool for making directory sets.  It is part of
the tbackup package.

This manual page is an excerpt of the tbackup documentation
in /usr/lib/tbackup/README (man tbackup).

*** TDIR USAGE

 tdir

  Without any options tdir will list the contents of the `tdir'
  directory set.

 tdir [-s setname] -c|-create <description>

  With the -c or -create option you can create a new directory set.
  If you don't specify a set name with the -s option, tdir will work
  on the `tdir' directory set.

 tdir [-s setname] <dirname/filename> [...]

  If you give file or directory names to tdir they are added to the
  directory set.

 tdir [-s setname] not name|ext|dir|fullname <string/"pattern"> [...]

  `Not' instructions can be added in the same way.  Patterns must be
  quoted to prevent expansion by the shell.
  
 tdir [-s setname] -d|-delete|-e|-edit|-l|-list|-u|-undoadd

  Other directory set operations:

  -d or -delete  deletes tdir.set (or setname.set).
  -e or -edit    runs the editor vi on the directory set.  If you don't
                 like vi you can configure another editor in the file
                 /etc/tbackup/Config.
  -l or -list    lists the contents of the directory set.
  -u or -undoadd removes the last line from the directory set, thus
                 undoing a previous tdir command.


*** DIRECTORY SET FILES

The presence of a file /etc/tbackup/foo.set causes the directory set
to be listed as

  | 1    foo        # a set called foo

Where the `# a set called foo' part is the first line of the foo.set
file.

A *.set file may contain:

- lines starting with a #, these are comments
- empty lines

- lines that contain a directory or file name starting with a /.

- lines that contain `not' instructions which cause files to be
  excluded from the backup process.

Here is an example foo.set file:

  > # a set called foo
  > 
  > #these are the directories in the set
  > /usr/foo
  > /usr/src/foo
  > 
  > # some things not to back up
  > not name core
  > not ext .o
  > not ext .aux .dvi
  >
  > #don't back up this subdirectory
  > not dir /usr/foo/pux/tmp
  >
  > #don't back up .a files below /usr/src/linux
  > not fullname /usr/src/linux/*.a

A backup set consists of all files in the specified directories and
their subdirectories, minus the files that are excluded by `not'
instructions.

A full backup of a directory set backs up all files in the set.
Symbolic links are not followed but stored as symbolic links.  Don't
name one directory twice in a .set file, this will cause it to be
included twice in the archive.


*** `NOT' INSTRUCTIONS

Below are the available `not' instructions for excluding files from a
directory set.

not name n1 n2 ...
  Exclude all files named n1, n2, ... from the set.
  Example: `not name core' excludes all core files.
           `nor name a*.log' excludes all files matching this shell
           pattern.

not ext e1 e2 ...
  Exclude all files whose name end with e1, e2, ... from the set.
  (ext stands for extension)
  Examples: `not ext .o' excludes all object files.
            `not ext o' excludes all files ending with an o
            `not ext .aux .log .dvi' excludes temporary TeX files.
  WARNING: Do not use `not ext .o' for the directory set containing
           the /usr/lib directory: this would cause the files
           /usr/lib/crt0.o and /usr/lib/gcrt0.o to be excluded from
           the backup. If these files are missing gcc(1) can't compile
           any programs.
           
not dir d1 d2 ...
  Exclude all files in the directories d1, d2, ... and the directories
  below from the set, where d1, d2, ... are full directory names
  starting with a `/'.   
  Examples: `not dir /usr/tmp' excludes this temporary directory.
            `not dir /usr/man/man[567] /usr/man/cat[567]' excludes all manual
            pages from sections 5,6, and 7.
  Note: The set
           > /usr/src
           > not dir /usr/src/linux
           > /usr/src/linux/boot
  does NOT contain the files in /usr/src/linux/boot!!!! The `not dir'
  instruction is applied to ALL (sub)directories in the set, so the
  /usr/src/linux/boot line has no effect at all.

not fullname f1 f2 ...
  Exclude the files f1, f2, ... from the set, where f1, f2, ... are
  full pathnames starting with a `/'.
  Examples: `not fullname /usr/lib/dutch.hash' excludes this file
            from the set.
            `not fullname /usr/src/linux/*.[oa]' excludes all .o and .a
            files in the /usr/src/linux directory and below    

The above `not' instructions all take shell patterns as arguments.
These patterns can contain the following special constructs:

   * : matches any sequence of zero or more characters
       (the sequence may contain / characters)
   ? : matches any single character

   [...]  : matches any of the enclosed characters, also
   [b-f]  : matches the range b, c, d, e, and f, and
   [^...] : matches all characters but ...

   \c : matches the character c, mainly used to specify the special
        characters * ? [ ] ^  \ and - if it appears between [ ].

