# Installation script for tbackup.

#get parameters from Makefile
bindir=$1
mandir=$2
icom=$3

echo

if [ "$icom" = "ln" ]; then
 echo Making symlinks.....
 ic="ln -vs"
else
 echo Copying files.....
 ic="$icom -v"
fi

rm -f $bindir/tbackup 
$ic /usr/lib/tbackup/tbackup $bindir/tbackup

rm -f $bindir/trestore
$ic /usr/lib/tbackup/trestore $bindir/trestore

rm -f $bindir/tlist
$ic /usr/lib/tbackup/tlist $bindir/tlist

rm -f $bindir/tguess
$ic /usr/lib/tbackup/tguess $bindir/tguess

rm -f $bindir/tdir
$ic /usr/lib/tbackup/tdir $bindir/tdir

rm -f $bindir/tverify
$ic /usr/lib/tbackup/tverify $bindir/tverify

rm -f $mandir/tbackup.1
$ic /usr/lib/tbackup/README.txt $mandir/tbackup.1

rm -f $mandir/tdir.1
$ic /usr/lib/tbackup/tdir.man $mandir/tdir.1

echo
echo Checking configuration files......

if [ ! -e /etc/tbackup ]; then
 echo Creating /etc/tbackup.
 mkdir /etc/tbackup;
fi

if [ ! -e /etc/tbackup/Config ]; then
 echo Installing configuration file /etc/tbackup/Config.
 cp -v /usr/lib/tbackup/bin/Config.std /etc/tbackup/Config;
else
 if [ -z "`grep 'downwardcompatible = 0.9' /etc/tbackup/Config`" ]; then
  cp -v /etc/tbackup/Config /etc/tbackup/Config.old
  echo Adding new configuration fields to /etc/tbackup/Config
  gawk '
(FILENAME ~ /old$/) { if($0 ~ /^export/) ex[substr($0,1,index($0,"="))]=$0;
                      next; }
/export/ { if(ex[substr($0,1,index($0,"="))]!="")
                        $0=ex[substr($0,1,index($0,"="))]; }
 { print; }' \
  /etc/tbackup/Config.old /usr/lib/tbackup/bin/Config.upd >/etc/tbackup/Config
 fi
fi


if [ ! -e /etc/tbackup/Compr.ext ]; then 
 echo Installing configuration file /etc/tbackup/Compr.ext.
 cp -v /usr/lib/tbackup/bin/Compr.ext.std /etc/tbackup/Compr.ext;
fi

echo
for i in 0d 0h 1d 1h tape; do
 if [ ! -e /etc/tbackup/$i.arg ]; then 
  cp -v /usr/lib/tbackup/examples/$i.arg /etc/tbackup/$i.arg
  echo Installing standard $i.arg file in /etc/tbackup.
 fi
done

idx=`gawk -F= '$1=="export indexdir" { print $2 }' </etc/tbackup/Config`
idx=`eval echo $idx`
if [ ! -e $idx ]; then
 echo Creating index file directory $idx, mode \`rwx------\'. 
 mkdir $idx
 chmod 700 $idx
fi

if [ ! -e /etc/tbackup/Floppy ]; then 
 echo Making floppy configuration file /etc/tbackup/Floppy.
 ./bin/fdconfig
else
 if [ -z "`grep = /etc/tbackup/Floppy`" ]; then
#pre-0.8 Floppy file
  echo Making floppy configuration file /etc/tbackup/Floppy.
  ./bin/fdconfig
 fi
fi

echo
echo Installation done.

