#!/bin/bash

auxnames=`cat bin/auxlist`
unalias -a

echo "Looking for auxiliary programs needed by tbackup..."
err=n
ok=y
for i in $auxnames; do
 n=`type -path $i`
 if [ "$n" = "" ]; then
   echo
   echo "ERROR: auxiliary program '$i' not found."
   printf "\007"
   ok=n
   if [ $i = "ecc" ]; then
    echo "Note: you only need to have GNU ecc if you want to use tape error"
    echo "      correcting codes."
   else
     if [ $i = "setfdprm" ]; then
      echo "Note: you only need to have setdfprm if you want to use extended"
      echo "      floppy densities."
     else
      err=y
     fi
   fi
 fi
done

if [ $err = y ]; then
 echo
 echo "Please install the missing programs; if some auxiliary programs are"
 echo "missing, tbackup will not run or will silently fail."
 echo
 exit 1
fi

if [ $ok = y ]; then
 echo "OK, all auxiliary programs needed by tbackup are present."
fi

echo

