/*

NAME
  splitter - `in situ' data splitter.

SYNOPSYS
  splitter [-b`bytes' -k`kb' -e`command' -f] filename
  (for internal use by tbackup)

DESCRIPTION
  -b`bytes' or -k`kb' needs to be the size of filename.
  -f fills the rest of the last of a part with zeroes, no -f truncates.
  -e runs `command' when a part is finished but before writing splitstatus.

  For the rest, read the code.

AUTHOR
  Koen Holtman, koen@blade.stack.urc.tue.nl   (kh1994)

*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>

#define BUFFERSIZE 4*1024

 void usage();
 void doit(); 
 int makepart();

 char *pnam;

 char *snam="./splitstatus";
 char *command=NULL;

 char *fnam=NULL;

 long partsize=-1;
 int fflag=0;

int main(int argc, char *argv[])
{ 
 int i;

 pnam=argv[0];

 for(i=1; i<argc; i++)
   { if(argv[i][0]!='-')
       {  if(fnam!=NULL) usage();
          fnam=argv[i];
       }
     else
       {
        switch(argv[i][1])
	  {
            case 'b' :
                  if(partsize!=-1) usage();
                  if(sscanf(&argv[i][2],"%ld",&partsize)!=1) usage();
                  if(partsize<0) usage();
                  break;

            case 'k' : 
                  if(partsize!=-1) usage();
                  if(sscanf(&argv[i][2],"%ld",&partsize)!=1) usage();
                  partsize*=1024;
                  if(partsize<0) usage();
                  break;

            case 'e' : 
		  command=&argv[i][2];
                  break;

            case 'f' : 
		  fflag=1;
                  break;

            default: usage();
	  }
       }
   }

 if(partsize==-1) usage();
 if(fnam==NULL) usage();

 doit();

 return 0;
}


void doit()
{
 int nr,lastone;
 FILE *f; 
 struct stat buf;

 nr=1;

 while(1)
   {
    /* make one part */
    lastone=makepart();
    
    /* run command */
    if(command!=NULL) system(command);

    /* report ready */
    f=fopen(snam,"w");
    if(f==NULL)
     { fprintf(stderr,"%s: error opening %s!\n",pnam,snam);
           exit(1);
     } 

    fprintf(f,"%d\n",nr);
    fprintf(f,"%s\n",lastone ? "last" : "more");
    fclose(f);
        
    if(lastone) break;

    /* wait for status file to be deleted */
    while(1)
      {
        sleep(1);
        if(stat(snam,&buf)!=0) break;
      }

    /* next part */
    nr++;
   }
}

/* overwrite contents of filename with data taken from stdin.
   on eof, return 1, else return 0.
*/   

int makepart()
{
    char buffer[BUFFERSIZE];
    long bcount;
    int b,ofh;
    off_t rb;
    
    ofh=open(fnam,O_WRONLY);
    if(ofh==-1)
    {
	fprintf(stderr,"%s: error opening %s!\n",pnam,fnam);
	exit(1);
    } 
    
    bcount=0;
    
    while(bcount<partsize)
    {  
	rb=partsize-bcount;
	if(rb>BUFFERSIZE) rb=BUFFERSIZE;
	
	b=read(0,buffer,rb);
	if(b==0)
        { /* eof */
	    
	    if(!fflag)
	    { 
		/* truncate file */
		ftruncate(ofh,(size_t)bcount);
		close(ofh);
		return 1;
	    }
	    else
	    {
		/* fill rest with zeroes */
		bzero(buffer,BUFFERSIZE);
		while(bcount<partsize)
		{
		    rb=partsize-bcount;
		    if(rb>BUFFERSIZE) rb=BUFFERSIZE;
		    if(write(ofh,buffer,rb)!=rb)
		    {
			fprintf(stderr,"%s: error writing to %s!\n",pnam,fnam);
			exit(1);
		    } 		
		    bcount+=rb;  
		}
		close(ofh);
		return 1;
	    }
	    
        }
	
	if(b<0)
        {
	    fprintf(stderr,"%s: error reading stdin!\n",pnam);
	    exit(1);
	} 
	
	bcount+=b;
	
	if(write(ofh,buffer,b)!=b)
        {
	    fprintf(stderr,"%s: error writing to %s!\n",pnam,fnam);
	    exit(1);
	} 
	
    }
    
    close(ofh);
    return 0;
}


void usage()
{
 fprintf(stderr,
  "usage: %s [-b`bytes' -k`kb' -e`command' -f] filename\n"
        ,pnam);
 exit(1);
}

