echo
echo "Type the name of the file or directory to back up. (e.g. /usr/src)"
echo "This must be a full pathname starting with / ."
echo "  All subdirectories will also be backed up."
echo "  Symbolic links are not followed but will be stored as symbolic links."
echo

if ! preset onename; then
 while true; do
  printf "file/directory name "
  getpar onename
  if [ "`echo $onename | grep "^/"`" = "" ]; then 
    echo "Please specify a full path starting with /"
    continue
  fi
  if [ -e $onename ]; then break; fi
  echo "This file or directory does not exist, try again."
 done
fi
allpars onename

export packhome=`dirname $onename`
if [ packhome = "." ]; then packhome="/"; fi

export filedirname=`basename $onename`

dea_rpars onename
dea_rpars packhome

if [ -f $onename ]; then
 cd /tmp/tbup
 echo "Backup of the file $onename." >descr
else
 cd /tmp/tbup
 echo "Backup of directory $onename." >descr
fi

echo "(Filenames in archive relative to $packhome)" >>descr

echo
printf " Size in kilobytes: "
du -k -s $onename
echo
