/* 
myklog: customised kernel message logger.

This is actually the third version of myklog, using yet another
mechanism to read them.  I hope it compiles with older C include file
and library versions.

Reads kernel messages through the SYS_klog #4 operation.

This is a 99% reliable way to get a kernel message stream while the
`real' kernel message log deamon is also reading them.

Inserts the message "<myklog>Some kernel messages are lost.\n" if the
messages are produced faster than it polls the buffer, i.e. more than
4k messages per 0.25 sec.

Writes messages to stdout and stderr, which can be redirected to a file or
tty. Disk change messages are filtered out, this is needed because
  grep -v "Disk change detected" </proc/kmsg 2>/dev/null | tee >kernmeslog &
won't work properly due to buffering in the pipe.  Ugh.


AUTHOR
  Koen Holtman, koen@stack.urc.tue.nl   (kh1994)

*/




#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <syscall.h>

char lost[]="<myklog>Some kernel messages are lost.\n";


int klog(int type, char * buf, int len)
{
 return syscall(SYS_klog,type,buf,len);
}

void print(char *m, int l)
{
   if(strncmp(m,"VFS: Disk change detect",15)!=0)
    if(strncmp(m,"<6>VFS: Disk change detect",15)!=0)
     if(strncmp(m,"<7>VFS: Disk change detect",15)!=0)
     {
       write(1,m,l);
       write(2,m,l);
       if(m[l-1]!='\n')
	 {
	          write(1,"\n",1);
		  write(2,"\n",1);
	 }
     }
 }

void main(int argc, char ** argv)
{
  char buffer[1024*4+1];
  int len,p,l;

  while(1)
    {
      len=klog(4,buffer,1024*4);
      if(len<0) { perror("SYS_klog"); exit(1); }

      if(len>=4096) print(lost,strlen(lost));

      /* feed \n terminated lines in buffer to print */
      p=0;
      while(p<len)
	{
	  l=0;
	  while(p+l<len)
	    {
	      l++;
	      if(buffer[p+l-1]=='\n') break;
	    }
          print(buffer+p,l);
          p+=l;
        }

      if(len==0) usleep(250L*1000L); else sleep(0);
   }

}




