#full/incremental backup stuff


lastfullv="<never>"
lastincv="<never>"
export lastfull=""
export lastinc=""

#now2 is recalculated later.
export now2=`expr \`date +%j\` + 365 \* \`date +%Y\``

if [ -e /etc/tbackup/$setname.log ]; then
 grep "^f " /etc/tbackup/$setname.log | tail -1 >bla
 if [ -s bla ]; then
  lastfull=`gawk '{ print $2; }' bla`
  nowyy=`gawk '{ print $3; }' bla`
  lastfullv=`gawk -F/ '{ print substr($2,2); }' bla`
  lastfullmet=`gawk '{ print $4; }' bla`
  echo "The last full backup of $setname was made on"
  echo "$lastfullv, that was approx." `expr $now2 - $nowyy` "days ago."
  echo
 fi

 gawk -f- /etc/tbackup/$setname.log >bla <<-WUXTA
 BEGIN { i=""; }
 \$1 == "f" { i=""; }
 \$1 == "if" { i=\$0; }
 \$1 == "ii" { i=\$0; }
 END { if(i!="") print i; }
WUXTA
 if [ -s bla ]; then
  nowzz=`gawk '{ print $3; }' bla`
  lastinc=`gawk '{ print $2; }' bla`
  lastincv=`gawk -F/ '{ print substr($2,2); }' bla`
  lastincmet=`gawk '{ print $4; }' bla`
  echo "The last incremental backup of $setname was made on"
  echo "$lastincv, that was approx." `expr $now2 - $nowzz` "days ago."
  echo
 fi

fi

if ! preset level; then
 while true; do
  echo "Choose a backup level."
  echo " f  = full backup of all files"
  if [ "$lastfull" != "" ]; then
   echo " if = incremental backup of all files changed since last full backup"
  fi
  if [ "$lastinc" != "" ]; then
   echo " ii = incremental backup of all files changed since last incremental backup"
  fi
  getpar level
  if [ $level = "f" -o $level = "if" -o $level = "ii" ]; then 
    break; 
  fi
 done
fi

#Translate illegal levels as a service to script writers.
if [ $level = "ii" ]; then
  if [ "$lastinc" = "" ]; then
    echo "WARNING: No 'ii' backup done yet, doing 'if' in stead of 'ii'."
    level="if";
  fi
fi

if [ $level = "if" ]; then
  if [ "$lastfull" = "" ]; then
    echo "WARNING: No 'if' backup done yet, doing 'f' in stead of 'if'."
    level="f";
  fi
fi
 
if [ $level = "f"  ]; then  ldes="Full"; fi
if [ $level = "if" ]; then  ldes="Incremental (on full)"; fi
if [ $level = "ii" ]; then  ldes="Incremental (on incr.)"; fi


allpars level
dea_rpars level

echo

#Determine date of this backup.
#Note that seconds are not used.  Rounding down does no harm.

export now=`date "+%m%d%H%M%Y"`
export backupdate=$now
dea_rpars backupdate

touch -t$now nowfile

#bash want to interpret day of year 018 as octal and dumps core!
#export now2=$[`find nowfile -printf "%Tj + 365 * %TY"`]
dd=`find nowfile -printf '%Tj'`
yy=`find nowfile -printf '%TY'`
export now2=`expr $dd + 365 "*" $yy`

export nowv="`find nowfile -printf '%Tc\n'`"
export nowsecs=`find nowfile -printf "%T@\n"`


# all files newer than timefile need to be written on an incremental backup.

if [ $level = "if" ]; then
 touch -t$lastfull timefile
 export lastimethod=$lastfullmet
fi

if [ $level = "ii" ]; then
 touch -t$lastinc timefile
 export lastimethod=$lastincmet
fi

if [ $level != "f" ]; then
 export timeoflast=`find timefile -printf "%T@"`

#dir set edited?
 setfilestamp=`find /etc/tbackup/$setname.set -printf "%T@"`
 if [ $timeoflast -lt $setfilestamp ]; then
  printf "\007"
  echo "WARNING: The directory set description file /etc/tbackup/$setname.set"
  if [ $level = if ]; then
   echo "seems to have been edited after the last full backup."
  else
   echo "seems to have been edited after the last incremental backup."
  fi
  echo "If the set definition changed this may have unexpected effects"
  echo "on the contents of the incremental backup."
  echo
  echo "If you have redefined a directory set, you should make a full backup"
  echo "first, unless you know exactly what you are doing."
  echo
  if [ $batchmode = n ]; then	
    echo -n "Press ^C to abort, enter to continue."
    enter
  fi
 fi

fi


if [ -f $bupbin/$incmethod\.ip ]; then
  cd /tmp/tbup
  source $incmethod\.ip
fi
cd /tmp/tbup

