/*

NAME
  i2split -- integer to split number conversion.


SYNOPSYS
  i2split integer [-i] [-p`prefix'] [-s`suffix']


DESCRIPTION
 Convert an integer in decimal notation to the base 26 number system used
 by split(1), and print it.

 (0=aa, 1=ab, 2=ac, ... , 1000=bmm, ...)

   -p`prefix' : print `prefix' before the number
   -s`suffix' : print `suffix' after the number
   -i : inverse function : expects an argument `prefix'split-number`suffix'
         and prints split-number in decimal notation
   -h : print help

EXAMPLE
  partnam=`i2split $partnr -p/tmp/part`
  partnr=`i2split -i -p/tmp/part $partnam`

BUS
  No overflow checking is done so e.g. `i2split zzzzzzzzzzzzzzzzzzzzzzzzzzzz'
  prints an incorrect result.
  

AUTHOR

  Koen Holtman, koen@blade.stack.urc.tue.nl   (kh1993)


*/


#include <stdio.h>
#include <string.h>
#include <ctype.h>


/* max. split number length */
#define MPL 8


 char *number=NULL;
 char *prefix=NULL;
 char *suffix=NULL;
 int inverse=0;

 char *pnam;

 void usage();
 void help();
 char *i2aa(long nr);
 void doit();


int main(int argc, char *argv[])
{ 
 int i;

 pnam=argv[0];

 for(i=1; i<argc; i++)
   { if(argv[i][0]!='-')
       {  if(number==NULL) number=argv[i];
          else usage();
       }
     else
       {
        switch(argv[i][1])
	  { case 'i' :
                  if(inverse!=0) usage();
                  if(strlen(argv[i])!=2) usage();
        	  inverse=1;
                  break;

            case 'p' :
                  if(prefix!=NULL) usage();
                  prefix=&argv[i][2];
                  break;

            case 's' :
                  if(suffix!=NULL) usage();
                  suffix=&argv[i][2];
                  break;

	    case 'h' :
                  if(strlen(argv[i])!=2) usage();
        	  help();

            default: usage();
	  }
       }
   }

 if(number==NULL) usage();
 if(prefix==NULL) prefix="";
 if(suffix==NULL) suffix="";

 doit();

 return 0;
}


void usage()
{
 fprintf(stderr,"usage: %s integer [-i] [-p`prefix'] [-s`suffix']\n",pnam);
 fprintf(stderr,"  %s -h prints help.\n",pnam);
 exit(1);
}

void help()
{
 fprintf(stderr,"i2split V0.1\n");
 fprintf(stderr,"usage: %s integer [-i] [-p`prefix'] [-s`suffix']\n",pnam);

 fprintf(stderr,
" Convert an integer in decimal notation to the base 26 number system used\n"
" by split(1), and print it.\n"
" (0=aa, 1=ab, 2=ac, ... , 1000=bmm, ...)\n"
"   -p`prefix' : print `prefix' before the number\n"
"   -s`suffix' : print `suffix' after the number\n"
"   -i : inverse function : expects an argument `prefix'split-number`suffix'\n"
"         and prints split-number in decimal notation\n"
"   -h : print help\n"
            );

 exit(1);
}




char *i2aa(long nr)
{
 long n; int i;
 static char pof[MPL+1];
 char *result;

 n=nr; 
 for(i=MPL-1; i>=0; i--) { pof[i]=n%26+'a'; n=n/26; }
 pof[MPL]=0;
 
 result=&pof[MPL-1-1];
 for(i=MPL-1-2; i>=0; i--) { if(pof[i]!='a') result=&pof[i]; }
     
 return result;
}


void doit()
{
 long nr; int i,ln,lp,ls;

 if(!inverse)
   {
    /*i2aa*/
    if(sscanf(number,"%ld",&nr)!=1) usage();

    printf("%s%s%s\n",prefix,i2aa(nr),suffix);        
   }
 else
   {
   ln=strlen(number);
   lp=strlen(prefix);
   ls=strlen(suffix);

   if(lp+ls>ln) usage();
   if(strncmp(prefix,number,lp)!=0) usage();
   if(strncmp(suffix,&number[ln-ls],ls)!=0) usage();

   i=lp;
   nr=0;
   while(i<ln-ls)
     {
      if(!islower(number[i])) usage();
      nr=nr*26+(number[i++]-'a');
     }

    printf("%ld\n",nr);
   }

}





