/* for internal use by tbackup. KH1994 */

/* Opens a fifo (named pipe) in read/write mode and sleeps until
killed. Never does a read or write.  This is provides for more
convenient fifo semantics in some cases.  Some subtle race conditions
(in bash) sometimes let a fifo being opened for reading without
blocking for a writer to appear.  This leads to immidiately getting an
eof after the open.  This bug is extremely hard to reproduce but
having a holdfifo on the pipe circumvents it.  */

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

int p,l;
char s[81];

void usage()
{
 fprintf(stderr,"usage: holdfifo fifoname\n");
 exit(1);
}

void main(int argc, char *argv[])
{
 if(argc!=2) usage();
 p=open(argv[1],O_RDWR);
 if(p<0) {
            fprintf(stderr,"holdfifo: can't open %s.\n",argv[1]);
            exit(1);
         }
 while(1) sleep(24*60*60);
}
