/* fdsize.c  -  print size (in bytes) of floppy disk.

  kh1993, loosely based on fdformat.c

  usage : fdsize /dev/fd...
            print size of device in bytes
          fdsize conv
            read little endian 2 byte number on stdin and print number*512
	    (because we don't want to use hexdump in floppy.rp)
*/


#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/fd.h>
#include <sys/ioctl.h>

static int ctrl;
struct floppy_struct param;

int main(int argc,char **argv)
{
  int size;

    if(argc!=2)
      { fprintf(stderr,"usage : %s /dev/fd...\n",argv[0]); 
        exit(1);
      }

    if(strcmp(argv[1],"conv")==0)
      {
	/*special case*/
	size=getchar()+getchar()*256;
	printf("%ld\n",(long)((long)size * (long)512) );
	return 0;
      }


    if ((ctrl = open(argv[1],3)) < 0) 
      { fprintf(stderr,"%s : error opening %s.\n",argv[0],argv[1]); 
        exit(1);
      }

    if (ioctl(ctrl,FDGETPRM,(int) &param) < 0) 
      { fprintf(stderr,"%s : error getting size of %s.\n"
             ,argv[0],argv[1]); 
        exit(1);
      }

    printf("%ld\n",(long)((long)param.size * (long)512) );

    return 0;
}

