/* fdflush.c  -  flushes the floppy disk buffers.

  kh1993, loosely based on fdformat.c

  usage : fdflush /dev/fd...

  issues a FDFLUSH ioctl for /dev/fd..., which has the description:
      flush buffers for media; either for verifying media, or for
      handling a media change without closing the file
      descriptor
*/


#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/fd.h>
#include <sys/ioctl.h>

static int ctrl;

int main(int argc,char **argv)
{

    if(argc!=2)
      { fprintf(stderr,"usage : %s /dev/fd...\n",argv[0]); 
        exit(1);
      }

    if ((ctrl = open(argv[1],3)) < 0) 
      { fprintf(stderr,"%s : error opening %s.\n",argv[0],argv[1]); 
        exit(1);
      }

    if (ioctl(ctrl,FDFLUSH,NULL) < 0) 
      { fprintf(stderr,"%s : error flushing buffers of %s.\n"
             ,argv[0],argv[1]); 
        exit(1);
      }
    
   return 0;
}

