/*

NAME
 enter -- safe 'press enter to continue' implementation

SYNOPSYS
 enter [-f]

DESCRIPTION
  Flushes keyboard buffer and waits for user to press enter.

  This is for use in interactive shell scripts. It prevents disaster
  scenario's like
   computer: insert next floppy disk and press enter
   user:     [inserts next floppy and presses enter, but holds down the
             enter key a bit too long so that multiple \n's are produced]
   computer: [writes data to disk]
   computer: insert next floppy disk and press enter
   computer: [reads a \n from the keyboard buffer and imediately begins
             to overwrite the old floppy]
   user:     aargh!

  If the -f option is given, just flushes all characters up to and including
  the last enter from the keyboard buffer.
  Intended use is `enter -f;read'.


AUTHOR
  Koen Holtman, koen@blade.stack.urc.tue.nl   (kh1993)

**/


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>

 void usage();
 void flushkb();
 void doit();

 int flush=0;

 char *pnam;

int main(int argc, char *argv[])
{ 

 pnam=argv[0];

 if(argc==2)
   {
    if(strcmp(argv[1],"-f")==0) flush=1;
    else usage();
   }
 else if(argc!=1) usage();

 doit();
 return 0;
}

void usage()
{
 fprintf(stderr,
  "usage: %s [-f]\n"
        ,pnam);
 fprintf(stderr,
"  Flushes keyboard buffer and waits for user to press enter.\n"
"  If the -f option is given, just flushes keyboard buffer.\n"
        );

 exit(1);
}


/* flush keyboard buffer */
void flushkb()
{ 
 char s[10];
 int stat;
 fd_set desc;
 struct timeval wacht;

 /* can't flush a non-terminal, this would cause an infinite loop, so
    we return early. */
 if(!isatty(0)) return;

 while(1)
   {
      wacht.tv_sec=(long)0;
      wacht.tv_usec=(long)0;

      FD_ZERO((&desc));
      FD_SET(0,(&desc));

      stat=select(1,&desc,0,0,&wacht);
      if(stat==0) break;
      read(0,s,5);
   }

}

void doit()
{ 
 char s[100];
 
 flushkb(); 

 if(flush) return;

 fgets(s,99,stdin);
}



