#include <stdio.h>
/*
 * fixtar - a filter to convert absolute pathnames
 * in tar to relative, by shifting them left one byte..
 * this filter changes "/path/name" to "path/name"
 *
 * Usage: something like
 * dd if=$TAPE | fixtar | tar xf -
 *
 * If the tar tape has "/path/name" in it, fixtar will
 * convert that to "path/name" and tar will extract it
 * relative to the current directory.
 *
 * You might want something like "dd if=$TAPE ibs=10k" to read
 * the tape properly.
 * I have used this on 4.3 BSD only.  It ought to work on
 * other versions of Unix but unfortunately I have no way of knowing.
 *
 * This program knows about tar format and is careful to diddle
 * only the header blocks, not the data blocks.
 *
 * You're probably better off using John Gilmore's public-domain "tar",
 * which always extracts with relative pathnames.  (And which has
 * many other nice features.)
 *
 * .. Steve Hayman, U. of Waterloo
 *    sahayman@math.waterloo.edu
 */

/*
 * these definitions are straight out of "man 5 tar"
 */
#define TBLOCK	512
#define NAMSIZ	100

union hblock {
	char dummy[TBLOCK];
	struct header {
		char name[NAMSIZ];
		char mode[8];
		char uid[8];
		char gid[8];
		char size[12];
		char mtime[12];
		char chksum[8];
		char linkflag;
		char linkname[NAMSIZ];
	} dbuf;
};

union hblock hb;

main()
{
	register int i;
	char *p;
	int size;
	int chksum;
	int zerob = 0;

	while ( ( i = read(0, hb.dummy, (int)sizeof(hb.dummy))) > 0   ) {
		if ( hb.dbuf.name[0] == '\0' ) {
			zerob++;
			write(1, hb.dummy, i);
			/*
			 * two zero blocks in a row means end-of-archive
			 */
			if ( zerob == 2 ) {
				/*
				 * read and write anything that's left,
				 * what the heck.
				 */
				while ( (i = read(0, hb.dummy,
						(int)sizeof(hb.dummy))) > 0 ) {
					write(1, hb.dummy, i);
				}
				exit(0);
			}
			continue;
		}
		zerob = 0;
		p = hb.dbuf.name;
		if ( *p == '/' ) {
			/*
			 * Shift the name left one char, which
			 * removes the leading '/'
			 */
			p++;
			do {
				*(p-1) = *p;
			} while ( *p++ );	/* up to and including '\0' */

			fprintf(stderr, "Adjusted: /%s\n", hb.dbuf.name );

			/*
			 * Fix the checksum - we have one less '/' in the
			 * header (and one more '\0' that doesn't change
			 * the checksum)
			 */
			sscanf(hb.dbuf.chksum, " %o", &chksum );
			chksum -= '/';
			/*
			 * "each field of width w has w-2 digits,
			 *  a space and a null, except chksum which
			 *  has a null followed by a space"
			 */
			sprintf( hb.dbuf.chksum, "%6o", chksum);
			
		}
		write( 1, hb.dummy, i);
		sscanf(hb.dbuf.size, " %o", &size);
		while ( size > 0 ) {
			i = read(0, hb.dummy, (int)sizeof(hb.dummy) );
			write( 1, hb.dummy, i);
			size -= sizeof(hb.dummy);
		}
	}
	exit(0);
}
