/* $Id: volumes.c,v 1.3 1998/03/23 22:57:35 fraserm Exp $ : volume stuff for span
   $Log: volumes.c,v $
   Revision 1.3  1998/03/23 22:57:35  fraserm
   changed status messages
   added getopt support for -q quiet and -l volume label options
   more minor bugfixes

   Revision 1.2  1998/03/22 20:36:43  fraserm
   moved blocks_this_volume out of struct and into a global -
   fixed incorrect blocks-this-volume bug

   Revision 1.1  1998/03/22 19:29:56  fraserm
   Initial revision

*/

#include "span.h"

void next_volume (bd)
     struct device *bd;
     /* since standard input or output are probably unuseable, open
	/dev/tty and request new volume */
{
  FILE *tty;
  char inch;
  int okay;
  struct timeval temptime;

  disarm_timer ();
  if (volume_number > 0) {
    print_status (1);
  }
  do {
    if (bd->fd > 2) {
      if (close_file (bd) == -1) {
	die ("close of file returned error", errno, ERR_CLOSE);
      }
    }
    /* try opening /dev/tty */
    if ((tty = fopen (TTY, "w")) == NULL) {
      die ("unable to open user's terminal to display message",
	   errno, ERR_NOUSER);
    }
    fprintf (tty, "%s: %cmount volume %d (%s) [Enter]",
	     progname, BELL, volume_number+1, bd->name);
    fflush (tty);
    fclose (tty);
    if ((tty = fopen (TTY, "r")) == NULL) {
      die ("unable to open terminal to read user's reply",
	   errno, ERR_NOUSER);
    }
    while ((inch = fgetc (tty)) >= 0 && inch != '\n');
    fclose (tty);
    if (bd == &out) {
      if ((bd->fd = open_file (bd, O_WRONLY)) == -1) {
	okay = 0;
	fprintf (stderr, "%s: unable to write volume in %s (%s)\n",
		 progname, bd->name, strerror(errno));
      }
      else {
	okay = 1;
      }
    }
    else {
      if ((bd->fd = open_file (bd, O_RDONLY)) == -1) {
	okay = 0;
	fprintf (stderr, "%s: unable to read volume in %s (%s)\n",
		 progname, bd->name, strerror(errno));
      }
      else {
	okay = 1;
      }
    }
  } while (!okay);
  if (gettimeofday (&temptime, NULL) == -1) {
    die ("get time", errno, ERR_OTHER);
  }
  first_volume = last = temptime.tv_sec * 1000 + temptime.tv_usec / 1000; /* milliseconds */
  if (volume_number+1 == 1) {
    first_all = first_volume;
  }
  bytes_this_volume = 0; /* reset volume bytecount */
  arm_timer();
}
