/* $Id: status.c,v 1.4 1998/07/24 22:17:33 fraserm Exp $ : status printing stuff for span
   $Log: status.c,v $
   Revision 1.4  1998/07/24 22:17:33  fraserm
   hack to fix compile on RedHat

   Revision 1.3  1998/03/23 22:57:35  fraserm
   changed status messages
   added getopt support for -q quiet and -l volume label options
   more minor bugfixes

   Revision 1.2  1998/03/22 20:36:43  fraserm
   moved blocks_this_volume out of struct and into a global -
   fixed incorrect blocks-this-volume bug

   Revision 1.1  1998/03/22 19:29:56  fraserm
   Initial revision

*/

#include "span.h"

void set_timer(tick)
{
  struct itimerval tmr;

  /* initialize interval timer to tick every TICK seconds */
  tmr.it_interval.tv_sec = tick;
  tmr.it_interval.tv_usec = 0;
  tmr.it_value.tv_sec = tick;
  tmr.it_value.tv_usec = 0;
  if (setitimer (ITIMER_REAL, &tmr, NULL) != 0) {
    die ("can't set interval timer", errno, ERR_TIMER);
  }
}

void arm_timer ()
{
  if (!quiet) {
    set_timer (TICK);
  }
}

void disarm_timer ()
{
  if (!quiet) {
    set_timer (0);
  }
}

void print_status (newline)
     int newline;
{
  char time[32];
  char status[MAXLINESIZE];
  long this, elapsed, sincelast;
  struct timeval thistime;

  if (!quiet) {
    /* calculate time since last call */
    if (gettimeofday (&thistime, NULL) == -1) {
      time[0] = '\0';
    }
    else {
      this = thistime.tv_sec * 1000 + thistime.tv_usec / 1000; /* milliseconds */
      elapsed = this - first_all;
      sincelast = this - last;
      last = this;
      if (sincelast > 0 && elapsed > 0) {
	sprintf (time, "[%02ld:%02ld cur/avg %4ld/%-4ld K/s]",
		 (elapsed / 1000) / 60, (elapsed / 1000) % 60,
		 ((out.bytes_so_far - last_written) / 1024) * 1000 / sincelast,
		 (out.bytes_so_far / 1024) * 1000 / elapsed);
      }
      else {
	sprintf (time, "[-]");
      }
      last_written = out.bytes_so_far;
    }
    sprintf (status, "%s->%s vol %d: K cur/all%8ld/%-8ld %s",
	     in.name, out.name, volume_number, bytes_this_volume/1024,
	     out.bytes_so_far / 1024, time);
    fprintf (stderr, "%-70s%c", status, (newline) ? '\n' : '\r');
    fflush(stderr);
  }
}

void timertick (sig, code, scp, addr)
  int sig, code;
  struct sigcontext *scp;
  char *addr;
{
  print_status (0);
}

void die (char *errstr, int errno, int diecode)
     /* char *errstr;
     int errno, diecode;*/
     /* display error and die */
{
  fprintf (stderr, "%s: %s\n\t(%s)\n",
	   progname, errstr, strerror (errno));
  /* hope the error didn't come from these guys, and try to unmount the
     any filesystem cleanly */
  exit (diecode);
}
