/* $Id: span.h,v 1.4 1998/03/23 23:07:40 fraserm Exp $
   $Log: span.h,v $
   Revision 1.4  1998/03/23 23:07:40  fraserm
   various minor changes

   Revision 1.3  1998/03/22 20:37:31  fraserm
   blocks_this_volume moved from struct to global

   Revision 1.2  1998/03/07 01:33:57  fraserm
   cosmetic bug

   Revision 1.1  1998/03/06 02:28:41  fraserm
   Initial revision

   Revision 1.1  1998/03/06 02:26:36  fraserm
   Initial revision

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/uio.h>
#include <errno.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>

#define TICK 1 /* status reports every this number of seconds */

/* format and magic number stuff for the ID block:
 volume name, volume number, total data on the volume, total data
 written so far, time of write to first volume, time or write to this volume,
 time now */
#define ID_MAGIC "SPAN-MAGIC-ID-BLOCK-PRECURSOR"
#define ID_VERSION "0.10"
#define ID_FORMAT_VERSION "0.10"
#define NO_LABEL "unlabelled"

/* program names to check for - this affects the mode - reading or writing
   from the block device */
#define OUTNAME "span"
#define INNAME "despan"

#ifndef MOUNTCMD
#define MOUNTCMD "mount"
#endif

#ifndef UMOUNTCMD
#define UMOUNTCMD "umount"
#endif

#define BELL '\007'

/* constants passed to the write_id_block() routine which determine its
   mode */
#define YES_SEEK 1 /* do a seek to the start of the device before
		      writing ID block */
#define NO_SEEK 0 /* or not, as the case may be */

/* nunber of times to try a read or write before giving up */
#define IOTRIES 16

/* the following are used in various struct device fields */
/* file identifying characters */
#define N_FILE 'F' /* normal file */
#define N_BLOCKDEVICE 'B' /* block device */
#define N_PIPE '|' /* pipe */
#define N_UNSUPPORTED '?' /* anything else which is farily certain to be
			     unsupported or pointless */
#define SIZE_UNKNOWN -1 /* if the file size is unknown */

#define NAMESIZE 100 /* maximum size of the name of a file, or of
			a volume label */
#define COMMANDSIZE 1024 /* max size of a mount or unmount command line */

#define MAXLINESIZE 160 /* maximum size of a status line */

#define DEFAULT_BLOCKSIZE 512  /* fairly random innocuous value - must be
				  greater than the length of the id-block
				  information - used as the blocksize
				  when reading an id-block before we know
				  the actual blocksize of the volume */

/* volume-mounting stuff */
#define TTY "/dev/tty" /* device to open to communicate with the user */

/* errors */
#define ERR_NOUSER -1 /* can't open terminal to talk to user */
#define ERR_MOUNT -2 /* error mounting or unmounting a filesystem */
#define ERR_TIMER -3 /* can't set the interval timer */
#define ERR_WBLOCK -4 /* I/O error writing block device; perhaps after
		       several tries */
#define ERR_WOUT -5 /* error writing output (if not a block device; perhaps
		       a broken pipe or some such thing) */
#define ERR_NOTBLOCK -6 /* device given is not a blcok device */
#define ERR_IDBLOCK -7 /* error occurred trying to write id_block */
#define ERR_CANTSEEK -8 /* wasn't able to seek on the block device */
#define ERR_CLOSE -9 /* closing a file or block device returned an error */
#define ERR_CANTREAD -10 /* an error reading something, either data or
			    id-block */
#define ERR_COMMAND -11 /* error in command line arguments */
#define ERR_ALLOC -12 /* wasn't able to allocate memory for the buffer */
#define ERR_OTHER -999 /* generic other error */

struct device {
  int fd; /* the files descriptor once opened */
  char id; /* the identifying character */
  char name[NAMESIZE]; /* the name of the block device or if writing to
			  a filesystem, the entry in /etc/fstab */
  char fname[NAMESIZE]; /* if writing to a filesystem, the filename to use */
  off_t size; /* its size, or SIZE_UNKNOWN if unknown */
  long blocksize; /* preferred blocksize; we write in blocks of the largest
		     preferred blocksize */
  /* now the variable stuff */
  long bytes_so_far; /* total bytes read/written so far */
};

extern int quiet; /* boolean; whether we are in quiet mode, that is,
		     no regular updates */

extern int bufsize; /* size of the read/write buffer */
extern char *buffer; /* and the buffer itself */

extern int volume_number;				      
extern long bytes_this_volume; /* total written or read from current
				  volume */

/* these are all time values from gettimeofday() */
extern long first_all; /* when we started writing the first volume */
extern long first_volume; /* when we started writing this volume */
extern long last; /* when we last printed any status */
extern long expected; /* if reading, how much we expect to find on this
			 volume */
extern long last_written; /* total data we had written the last time we printed
			     any status */

extern struct device in, out; /* the input and output file descriptors */

extern int errno; /* too many comments, anyone? :-) */
extern char progname[]; /* where the program name gets squirrelled */
extern char label[]; /* the volume label, when reading */

/* function declarations */
void set_timer();
void arm_timer();
void disarm_timer();
int open_file();
int close_file();
void write_id_block();
long read_id_block();
void next_volume();
void print_status();
void timertick();
int identify();
void die();
ssize_t read_robust();
ssize_t write_robust();
