/* $Id: robustio.c,v 1.1 1998/03/22 19:29:56 fraserm Exp $ : robust read and write routines for span
   $Log: robustio.c,v $
   Revision 1.1  1998/03/22 19:29:56  fraserm
   Initial revision

*/

#include "span.h"

ssize_t read_robust (fd, buf, count)
     int fd;
     char *buf;
     size_t count;
     /* read, and on failure, repeat the read several times, if still doesn't
	work, zero out the buffer, and seek forward - if the seek fails,
	return an error */
{
  ssize_t retval;
  int attempts = 0;
  int num_errors = 0;

  errno = 0; /* just in case :-) */
  do {
    ++attempts;
    retval = read (fd, buf, count);
    if (retval == -1) { /* an error occurred */
      ++num_errors;
    }
  } while (retval == -1 && attempts < IOTRIES);
  if (retval == -1) {
    fprintf (stderr, "\nWarning: read of %d bytes failed after %d tries - skipping\n",
	     count, attempts);
    if (lseek (fd, count, SEEK_CUR) == -1) { /* aw man, can't seek either */
      return -1; /* really return an error :-) */
    }
    else {
      memset (buf, 0, count); /* zero out the buffer, in the hope that the
				 target can deal with it */
      return count; /* pretend that the read worked */
    }
  }
  else {
    if (attempts > 1) {
      fprintf (stderr, "\nWarning: needed %d tries to read %d bytes\n",
	       attempts, count);
    }
    return retval; /* return the actual return value, since it'll be
		      valid here */
  }
}

ssize_t write_robust (fd, buf, count)
     int fd;
     char *buf;
     size_t count;
     /* read, and on failure (assuming it's no ENOSPC, repeat the read
	several times, if still doesn't work, zero out the buffer, and
	seek forward - if the seek fails, return an error */
{
  ssize_t retval;
  int attempts = 0;
  int num_errors = 0;

  errno = 0; /* just in case :-) */
  do {
    ++attempts;
    retval = write (fd, buf, count);
    if (retval == -1 && errno != ENOSPC) { /* an error occurred */
      ++num_errors;
    }
    /* ENOSPC (out of space) is a valid error that we allow */
  } while ((retval == -1 && errno != ENOSPC) && attempts < IOTRIES);
  if (retval == -1 && errno != ENOSPC) {
    fprintf (stderr, "\nWarning: write of %d bytes failed after %d tries - skipping\n",
	     count, attempts);
    if (lseek (fd, count, SEEK_CUR) == -1) { /* aw man, can't seek either */
      return -1; /* really return an error :-) */
    }
    else {
      return count; /* pretend that the read worked */
    }
  }
  else {
    if (attempts > 1) {
      fprintf (stderr, "\nWarning: needed %d tries to write %d bytes\n",
	       attempts, count);
    }
    return retval; /* return the actual return value, since it'll be
		      valid here */
  }
}
