/* $Id: openclose.c,v 1.2 1998/03/22 20:36:43 fraserm Exp $: opening and closing stuff for span
   $Log: openclose.c,v $
   Revision 1.2  1998/03/22 20:36:43  fraserm
   moved blocks_this_volume out of struct and into a global -
   fixed incorrect blocks-this-volume bug

   Revision 1.1  1998/03/22 19:29:56  fraserm
   Initial revision

*/

#include "span.h"

int span_mount (fs)
     char *fs;
{
  int r;
  static char str[COMMANDSIZE];

  /* mount the filesystem - build the mount command */
  sprintf (str, "%s %s", MOUNTCMD, fs);
  r = system (str);
  if (r < 0) { /* system() failed */
    fprintf (stderr, "Unable to execute the command:\n\t%s\nto mount the filesystem (%s)\n",
	     str, strerror(errno));
    return r;
  }
  else if (r > 0) { /* return code from mount, likely */
    return -1;
  }
  return r;
}

int span_umount (fs)
     char *fs;
{
  int r;
  static char str[COMMANDSIZE];

  /* unmount the filesystem - build the unmount command */
  sprintf (str, "%s %s", UMOUNTCMD, fs);
  r = system (str);
  if (r < 0) { /* system() failed */
    fprintf (stderr, "Unable to execute the command:\n\t%s\nto un-mount the filesystem (%s)\n",
	     str, strerror(errno));
    return r;
  }
  else if (r > 0) { /* return code from umount, likely */
    return -1;
  }
  return r;
}

int open_file (bd, mode)
     /* open block special device or mount filesystem and open file in the
	desired manner for reading */
     struct device *bd;
     int mode;
{
  int r;
  int openbits = 0;
  static char str[COMMANDSIZE];

  if (mode == O_WRONLY) {
    mode |= O_CREAT | O_TRUNC;
    openbits |= S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH;
  }
  if (*(bd->fname) == '\0') { /* raw block device */
    r = open (bd->name, mode, openbits);
  }
  else { /* file on a filesystem */
    /* first, mount the filesystem */
    r = span_mount (bd->name);
    if (r < 0) {
      return r;
    }
    /* if we got here, it worked, so open the file on the filesystem */
    sprintf (str, "%s/%s", bd->name, bd->fname);
    r = open (str, mode, openbits);
    if (r == -1) { /* uh oh, failed to open the file, so we better unmount
		      the filesystem */
      fprintf (stderr, "Unable to open the file %s on %s (%s)\n",
	       bd->fname, bd->name, strerror(errno));
      r = span_umount (bd->name);
      if (r < 0) { /* oh feck, can't unmount it either, just shoot me now */
	die ("unable to unmount filesystem after failed open",
	     errno, ERR_MOUNT);
      }
      return -1;
    }
  }
  return r;
}

int close_file (bd)
     /* close block special device or close file and unmount filesystem */
     struct device *bd;
{
  int r;

  r = close (bd->fd);
  if (r < 0) { /* uh oh, close failed, bad state */
    die ("unable to close file on current volume", errno, ERR_CLOSE);
  }
  if (*(bd->fname) != '\0') { /* filesystem, so unmount it as well */
    r = span_umount (bd->name);
    if (r < 0) {
      die ("unable to unmount current volume", errno, ERR_MOUNT);
    }
  }
  return r;
}

int identify (dev)
  struct device *dev;
{
  struct stat buf;

  if (fstat (dev->fd, &buf) == -1) {
    return -1;
  }
  if (S_ISREG(buf.st_mode)) { /* regular file */
    dev->id = N_FILE;
    dev->size = buf.st_size;
    dev->blocksize = buf.st_blksize;
  } else if (S_ISBLK(buf.st_mode)) { /* block special file, so size unknown */
    dev->id = N_BLOCKDEVICE;
    dev->size = SIZE_UNKNOWN;
    dev->blocksize = buf.st_blksize;
  } else if (S_ISFIFO(buf.st_mode)) { /* pipe */
    dev->id = N_PIPE;
    dev->size = SIZE_UNKNOWN;
    dev->blocksize = buf.st_blksize;
  }
  else {
    dev->id = N_UNSUPPORTED;
  }
  bytes_this_volume = 0; /* zero out this - new volume after all */
  return 0;
}
